/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.apis;

import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.clients.ProgressRequestBody;
import com.mailslurp.clients.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.mailslurp.models.CreateInboxRulesetOptions;
import com.mailslurp.models.InboxRulesetDto;
import com.mailslurp.models.InboxRulesetTestOptions;
import com.mailslurp.models.InboxRulesetTestResult;
import java.time.OffsetDateTime;
import com.mailslurp.models.PageInboxRulesetDto;
import com.mailslurp.models.TestNewInboxRulesetOptions;
import java.util.UUID;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InboxRulesetControllerApi {
    private ApiClient localVarApiClient;

    public InboxRulesetControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InboxRulesetControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for createNewInboxRuleset
     * @param inboxId Inbox id to attach ruleset to (required)
     * @param createInboxRulesetOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createNewInboxRulesetCall(UUID inboxId, CreateInboxRulesetOptions createInboxRulesetOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = createInboxRulesetOptions;

        // create path and map variables
        String localVarPath = "/rulesets";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createNewInboxRulesetValidateBeforeCall(UUID inboxId, CreateInboxRulesetOptions createInboxRulesetOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling createNewInboxRuleset(Async)");
        }
        
        // verify the required parameter 'createInboxRulesetOptions' is set
        if (createInboxRulesetOptions == null) {
            throw new ApiException("Missing the required parameter 'createInboxRulesetOptions' when calling createNewInboxRuleset(Async)");
        }
        

        okhttp3.Call localVarCall = createNewInboxRulesetCall(inboxId, createInboxRulesetOptions, _callback);
        return localVarCall;

    }

    /**
     * Create an inbox ruleset
     * Create a new inbox rule for forwarding, blocking, and allowing emails when sending and receiving
     * @param inboxId Inbox id to attach ruleset to (required)
     * @param createInboxRulesetOptions  (required)
     * @return InboxRulesetDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InboxRulesetDto createNewInboxRuleset(UUID inboxId, CreateInboxRulesetOptions createInboxRulesetOptions) throws ApiException {
        ApiResponse<InboxRulesetDto> localVarResp = createNewInboxRulesetWithHttpInfo(inboxId, createInboxRulesetOptions);
        return localVarResp.getData();
    }

    /**
     * Create an inbox ruleset
     * Create a new inbox rule for forwarding, blocking, and allowing emails when sending and receiving
     * @param inboxId Inbox id to attach ruleset to (required)
     * @param createInboxRulesetOptions  (required)
     * @return ApiResponse&lt;InboxRulesetDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InboxRulesetDto> createNewInboxRulesetWithHttpInfo(UUID inboxId, CreateInboxRulesetOptions createInboxRulesetOptions) throws ApiException {
        okhttp3.Call localVarCall = createNewInboxRulesetValidateBeforeCall(inboxId, createInboxRulesetOptions, null);
        Type localVarReturnType = new TypeToken<InboxRulesetDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create an inbox ruleset (asynchronously)
     * Create a new inbox rule for forwarding, blocking, and allowing emails when sending and receiving
     * @param inboxId Inbox id to attach ruleset to (required)
     * @param createInboxRulesetOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createNewInboxRulesetAsync(UUID inboxId, CreateInboxRulesetOptions createInboxRulesetOptions, final ApiCallback<InboxRulesetDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = createNewInboxRulesetValidateBeforeCall(inboxId, createInboxRulesetOptions, _callback);
        Type localVarReturnType = new TypeToken<InboxRulesetDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteInboxRuleset
     * @param id ID of inbox ruleset (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteInboxRulesetCall(UUID id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/rulesets/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteInboxRulesetValidateBeforeCall(UUID id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteInboxRuleset(Async)");
        }
        

        okhttp3.Call localVarCall = deleteInboxRulesetCall(id, _callback);
        return localVarCall;

    }

    /**
     * Delete an inbox ruleset
     * Delete inbox ruleset
     * @param id ID of inbox ruleset (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteInboxRuleset(UUID id) throws ApiException {
        deleteInboxRulesetWithHttpInfo(id);
    }

    /**
     * Delete an inbox ruleset
     * Delete inbox ruleset
     * @param id ID of inbox ruleset (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteInboxRulesetWithHttpInfo(UUID id) throws ApiException {
        okhttp3.Call localVarCall = deleteInboxRulesetValidateBeforeCall(id, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete an inbox ruleset (asynchronously)
     * Delete inbox ruleset
     * @param id ID of inbox ruleset (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteInboxRulesetAsync(UUID id, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteInboxRulesetValidateBeforeCall(id, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteInboxRulesets
     * @param inboxId Optional inbox id to attach ruleset to (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteInboxRulesetsCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/rulesets";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteInboxRulesetsValidateBeforeCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = deleteInboxRulesetsCall(inboxId, _callback);
        return localVarCall;

    }

    /**
     * Delete inbox rulesets
     * Delete inbox rulesets. Accepts optional inboxId filter.
     * @param inboxId Optional inbox id to attach ruleset to (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteInboxRulesets(UUID inboxId) throws ApiException {
        deleteInboxRulesetsWithHttpInfo(inboxId);
    }

    /**
     * Delete inbox rulesets
     * Delete inbox rulesets. Accepts optional inboxId filter.
     * @param inboxId Optional inbox id to attach ruleset to (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteInboxRulesetsWithHttpInfo(UUID inboxId) throws ApiException {
        okhttp3.Call localVarCall = deleteInboxRulesetsValidateBeforeCall(inboxId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete inbox rulesets (asynchronously)
     * Delete inbox rulesets. Accepts optional inboxId filter.
     * @param inboxId Optional inbox id to attach ruleset to (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteInboxRulesetsAsync(UUID inboxId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteInboxRulesetsValidateBeforeCall(inboxId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getInboxRuleset
     * @param id ID of inbox ruleset (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxRulesetCall(UUID id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/rulesets/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getInboxRulesetValidateBeforeCall(UUID id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getInboxRuleset(Async)");
        }
        

        okhttp3.Call localVarCall = getInboxRulesetCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get an inbox ruleset
     * Get inbox ruleset
     * @param id ID of inbox ruleset (required)
     * @return InboxRulesetDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InboxRulesetDto getInboxRuleset(UUID id) throws ApiException {
        ApiResponse<InboxRulesetDto> localVarResp = getInboxRulesetWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get an inbox ruleset
     * Get inbox ruleset
     * @param id ID of inbox ruleset (required)
     * @return ApiResponse&lt;InboxRulesetDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InboxRulesetDto> getInboxRulesetWithHttpInfo(UUID id) throws ApiException {
        okhttp3.Call localVarCall = getInboxRulesetValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<InboxRulesetDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get an inbox ruleset (asynchronously)
     * Get inbox ruleset
     * @param id ID of inbox ruleset (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxRulesetAsync(UUID id, final ApiCallback<InboxRulesetDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getInboxRulesetValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<InboxRulesetDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getInboxRulesets
     * @param inboxId Optional inbox id to get rulesets from (optional)
     * @param page Optional page index in inbox ruleset list pagination (optional, default to 0)
     * @param size Optional page size in inbox ruleset list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxRulesetsCall(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/rulesets";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (searchFilter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("searchFilter", searchFilter));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getInboxRulesetsValidateBeforeCall(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getInboxRulesetsCall(inboxId, page, size, sort, searchFilter, since, before, _callback);
        return localVarCall;

    }

    /**
     * List inbox rulesets
     * List all rulesets attached to an inbox
     * @param inboxId Optional inbox id to get rulesets from (optional)
     * @param page Optional page index in inbox ruleset list pagination (optional, default to 0)
     * @param size Optional page size in inbox ruleset list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return PageInboxRulesetDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageInboxRulesetDto getInboxRulesets(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        ApiResponse<PageInboxRulesetDto> localVarResp = getInboxRulesetsWithHttpInfo(inboxId, page, size, sort, searchFilter, since, before);
        return localVarResp.getData();
    }

    /**
     * List inbox rulesets
     * List all rulesets attached to an inbox
     * @param inboxId Optional inbox id to get rulesets from (optional)
     * @param page Optional page index in inbox ruleset list pagination (optional, default to 0)
     * @param size Optional page size in inbox ruleset list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return ApiResponse&lt;PageInboxRulesetDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageInboxRulesetDto> getInboxRulesetsWithHttpInfo(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        okhttp3.Call localVarCall = getInboxRulesetsValidateBeforeCall(inboxId, page, size, sort, searchFilter, since, before, null);
        Type localVarReturnType = new TypeToken<PageInboxRulesetDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List inbox rulesets (asynchronously)
     * List all rulesets attached to an inbox
     * @param inboxId Optional inbox id to get rulesets from (optional)
     * @param page Optional page index in inbox ruleset list pagination (optional, default to 0)
     * @param size Optional page size in inbox ruleset list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxRulesetsAsync(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback<PageInboxRulesetDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getInboxRulesetsValidateBeforeCall(inboxId, page, size, sort, searchFilter, since, before, _callback);
        Type localVarReturnType = new TypeToken<PageInboxRulesetDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for testInboxRuleset
     * @param id ID of inbox ruleset (required)
     * @param inboxRulesetTestOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call testInboxRulesetCall(UUID id, InboxRulesetTestOptions inboxRulesetTestOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = inboxRulesetTestOptions;

        // create path and map variables
        String localVarPath = "/rulesets/{id}/test"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call testInboxRulesetValidateBeforeCall(UUID id, InboxRulesetTestOptions inboxRulesetTestOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling testInboxRuleset(Async)");
        }
        
        // verify the required parameter 'inboxRulesetTestOptions' is set
        if (inboxRulesetTestOptions == null) {
            throw new ApiException("Missing the required parameter 'inboxRulesetTestOptions' when calling testInboxRuleset(Async)");
        }
        

        okhttp3.Call localVarCall = testInboxRulesetCall(id, inboxRulesetTestOptions, _callback);
        return localVarCall;

    }

    /**
     * Test an inbox ruleset
     * Test an inbox ruleset
     * @param id ID of inbox ruleset (required)
     * @param inboxRulesetTestOptions  (required)
     * @return InboxRulesetTestResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InboxRulesetTestResult testInboxRuleset(UUID id, InboxRulesetTestOptions inboxRulesetTestOptions) throws ApiException {
        ApiResponse<InboxRulesetTestResult> localVarResp = testInboxRulesetWithHttpInfo(id, inboxRulesetTestOptions);
        return localVarResp.getData();
    }

    /**
     * Test an inbox ruleset
     * Test an inbox ruleset
     * @param id ID of inbox ruleset (required)
     * @param inboxRulesetTestOptions  (required)
     * @return ApiResponse&lt;InboxRulesetTestResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InboxRulesetTestResult> testInboxRulesetWithHttpInfo(UUID id, InboxRulesetTestOptions inboxRulesetTestOptions) throws ApiException {
        okhttp3.Call localVarCall = testInboxRulesetValidateBeforeCall(id, inboxRulesetTestOptions, null);
        Type localVarReturnType = new TypeToken<InboxRulesetTestResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Test an inbox ruleset (asynchronously)
     * Test an inbox ruleset
     * @param id ID of inbox ruleset (required)
     * @param inboxRulesetTestOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call testInboxRulesetAsync(UUID id, InboxRulesetTestOptions inboxRulesetTestOptions, final ApiCallback<InboxRulesetTestResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = testInboxRulesetValidateBeforeCall(id, inboxRulesetTestOptions, _callback);
        Type localVarReturnType = new TypeToken<InboxRulesetTestResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for testInboxRulesetsForInbox
     * @param inboxId ID of inbox (required)
     * @param inboxRulesetTestOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call testInboxRulesetsForInboxCall(UUID inboxId, InboxRulesetTestOptions inboxRulesetTestOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = inboxRulesetTestOptions;

        // create path and map variables
        String localVarPath = "/rulesets";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call testInboxRulesetsForInboxValidateBeforeCall(UUID inboxId, InboxRulesetTestOptions inboxRulesetTestOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling testInboxRulesetsForInbox(Async)");
        }
        
        // verify the required parameter 'inboxRulesetTestOptions' is set
        if (inboxRulesetTestOptions == null) {
            throw new ApiException("Missing the required parameter 'inboxRulesetTestOptions' when calling testInboxRulesetsForInbox(Async)");
        }
        

        okhttp3.Call localVarCall = testInboxRulesetsForInboxCall(inboxId, inboxRulesetTestOptions, _callback);
        return localVarCall;

    }

    /**
     * Test inbox rulesets for inbox
     * Test inbox rulesets for inbox
     * @param inboxId ID of inbox (required)
     * @param inboxRulesetTestOptions  (required)
     * @return InboxRulesetTestResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InboxRulesetTestResult testInboxRulesetsForInbox(UUID inboxId, InboxRulesetTestOptions inboxRulesetTestOptions) throws ApiException {
        ApiResponse<InboxRulesetTestResult> localVarResp = testInboxRulesetsForInboxWithHttpInfo(inboxId, inboxRulesetTestOptions);
        return localVarResp.getData();
    }

    /**
     * Test inbox rulesets for inbox
     * Test inbox rulesets for inbox
     * @param inboxId ID of inbox (required)
     * @param inboxRulesetTestOptions  (required)
     * @return ApiResponse&lt;InboxRulesetTestResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InboxRulesetTestResult> testInboxRulesetsForInboxWithHttpInfo(UUID inboxId, InboxRulesetTestOptions inboxRulesetTestOptions) throws ApiException {
        okhttp3.Call localVarCall = testInboxRulesetsForInboxValidateBeforeCall(inboxId, inboxRulesetTestOptions, null);
        Type localVarReturnType = new TypeToken<InboxRulesetTestResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Test inbox rulesets for inbox (asynchronously)
     * Test inbox rulesets for inbox
     * @param inboxId ID of inbox (required)
     * @param inboxRulesetTestOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call testInboxRulesetsForInboxAsync(UUID inboxId, InboxRulesetTestOptions inboxRulesetTestOptions, final ApiCallback<InboxRulesetTestResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = testInboxRulesetsForInboxValidateBeforeCall(inboxId, inboxRulesetTestOptions, _callback);
        Type localVarReturnType = new TypeToken<InboxRulesetTestResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for testNewInboxRuleset
     * @param testNewInboxRulesetOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call testNewInboxRulesetCall(TestNewInboxRulesetOptions testNewInboxRulesetOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = testNewInboxRulesetOptions;

        // create path and map variables
        String localVarPath = "/rulesets";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call testNewInboxRulesetValidateBeforeCall(TestNewInboxRulesetOptions testNewInboxRulesetOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'testNewInboxRulesetOptions' is set
        if (testNewInboxRulesetOptions == null) {
            throw new ApiException("Missing the required parameter 'testNewInboxRulesetOptions' when calling testNewInboxRuleset(Async)");
        }
        

        okhttp3.Call localVarCall = testNewInboxRulesetCall(testNewInboxRulesetOptions, _callback);
        return localVarCall;

    }

    /**
     * Test new inbox ruleset
     * Test new inbox ruleset
     * @param testNewInboxRulesetOptions  (required)
     * @return InboxRulesetTestResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InboxRulesetTestResult testNewInboxRuleset(TestNewInboxRulesetOptions testNewInboxRulesetOptions) throws ApiException {
        ApiResponse<InboxRulesetTestResult> localVarResp = testNewInboxRulesetWithHttpInfo(testNewInboxRulesetOptions);
        return localVarResp.getData();
    }

    /**
     * Test new inbox ruleset
     * Test new inbox ruleset
     * @param testNewInboxRulesetOptions  (required)
     * @return ApiResponse&lt;InboxRulesetTestResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InboxRulesetTestResult> testNewInboxRulesetWithHttpInfo(TestNewInboxRulesetOptions testNewInboxRulesetOptions) throws ApiException {
        okhttp3.Call localVarCall = testNewInboxRulesetValidateBeforeCall(testNewInboxRulesetOptions, null);
        Type localVarReturnType = new TypeToken<InboxRulesetTestResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Test new inbox ruleset (asynchronously)
     * Test new inbox ruleset
     * @param testNewInboxRulesetOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call testNewInboxRulesetAsync(TestNewInboxRulesetOptions testNewInboxRulesetOptions, final ApiCallback<InboxRulesetTestResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = testNewInboxRulesetValidateBeforeCall(testNewInboxRulesetOptions, _callback);
        Type localVarReturnType = new TypeToken<InboxRulesetTestResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
