/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.apis;

import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.clients.ProgressRequestBody;
import com.mailslurp.clients.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.mailslurp.models.MissedEmail;
import java.time.OffsetDateTime;
import com.mailslurp.models.PageMissedEmailProjection;
import com.mailslurp.models.PageUnknownMissedEmailProjection;
import java.util.UUID;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MissedEmailControllerApi {
    private ApiClient localVarApiClient;

    public MissedEmailControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MissedEmailControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getAllMissedEmails
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param inboxId Optional inbox ID filter (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllMissedEmailsCall(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, UUID inboxId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/missed-emails";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (searchFilter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("searchFilter", searchFilter));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAllMissedEmailsValidateBeforeCall(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, UUID inboxId, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getAllMissedEmailsCall(page, size, sort, searchFilter, since, before, inboxId, _callback);
        return localVarCall;

    }

    /**
     * Get all MissedEmails in paginated format
     * 
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param inboxId Optional inbox ID filter (optional)
     * @return PageMissedEmailProjection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageMissedEmailProjection getAllMissedEmails(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, UUID inboxId) throws ApiException {
        ApiResponse<PageMissedEmailProjection> localVarResp = getAllMissedEmailsWithHttpInfo(page, size, sort, searchFilter, since, before, inboxId);
        return localVarResp.getData();
    }

    /**
     * Get all MissedEmails in paginated format
     * 
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param inboxId Optional inbox ID filter (optional)
     * @return ApiResponse&lt;PageMissedEmailProjection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageMissedEmailProjection> getAllMissedEmailsWithHttpInfo(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, UUID inboxId) throws ApiException {
        okhttp3.Call localVarCall = getAllMissedEmailsValidateBeforeCall(page, size, sort, searchFilter, since, before, inboxId, null);
        Type localVarReturnType = new TypeToken<PageMissedEmailProjection>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get all MissedEmails in paginated format (asynchronously)
     * 
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param inboxId Optional inbox ID filter (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllMissedEmailsAsync(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, UUID inboxId, final ApiCallback<PageMissedEmailProjection> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAllMissedEmailsValidateBeforeCall(page, size, sort, searchFilter, since, before, inboxId, _callback);
        Type localVarReturnType = new TypeToken<PageMissedEmailProjection>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAllUnknownMissedEmails
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param inboxId Optional inbox ID filter (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllUnknownMissedEmailsCall(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, UUID inboxId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/missed-emails/unknown";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (searchFilter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("searchFilter", searchFilter));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAllUnknownMissedEmailsValidateBeforeCall(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, UUID inboxId, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getAllUnknownMissedEmailsCall(page, size, sort, searchFilter, since, before, inboxId, _callback);
        return localVarCall;

    }

    /**
     * Get all unknown missed emails in paginated format
     * Unknown missed emails are emails that were sent to MailSlurp but could not be assigned to an existing inbox.
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param inboxId Optional inbox ID filter (optional)
     * @return PageUnknownMissedEmailProjection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageUnknownMissedEmailProjection getAllUnknownMissedEmails(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, UUID inboxId) throws ApiException {
        ApiResponse<PageUnknownMissedEmailProjection> localVarResp = getAllUnknownMissedEmailsWithHttpInfo(page, size, sort, searchFilter, since, before, inboxId);
        return localVarResp.getData();
    }

    /**
     * Get all unknown missed emails in paginated format
     * Unknown missed emails are emails that were sent to MailSlurp but could not be assigned to an existing inbox.
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param inboxId Optional inbox ID filter (optional)
     * @return ApiResponse&lt;PageUnknownMissedEmailProjection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageUnknownMissedEmailProjection> getAllUnknownMissedEmailsWithHttpInfo(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, UUID inboxId) throws ApiException {
        okhttp3.Call localVarCall = getAllUnknownMissedEmailsValidateBeforeCall(page, size, sort, searchFilter, since, before, inboxId, null);
        Type localVarReturnType = new TypeToken<PageUnknownMissedEmailProjection>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get all unknown missed emails in paginated format (asynchronously)
     * Unknown missed emails are emails that were sent to MailSlurp but could not be assigned to an existing inbox.
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param inboxId Optional inbox ID filter (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllUnknownMissedEmailsAsync(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, UUID inboxId, final ApiCallback<PageUnknownMissedEmailProjection> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAllUnknownMissedEmailsValidateBeforeCall(page, size, sort, searchFilter, since, before, inboxId, _callback);
        Type localVarReturnType = new TypeToken<PageUnknownMissedEmailProjection>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getMissedEmail
     * @param missedEmailId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMissedEmailCall(UUID missedEmailId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/missed-emails/{missedEmailId}"
            .replaceAll("\\{" + "missedEmailId" + "\\}", localVarApiClient.escapeString(missedEmailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getMissedEmailValidateBeforeCall(UUID missedEmailId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'missedEmailId' is set
        if (missedEmailId == null) {
            throw new ApiException("Missing the required parameter 'missedEmailId' when calling getMissedEmail(Async)");
        }
        

        okhttp3.Call localVarCall = getMissedEmailCall(missedEmailId, _callback);
        return localVarCall;

    }

    /**
     * Get MissedEmail
     * 
     * @param missedEmailId  (required)
     * @return MissedEmail
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MissedEmail getMissedEmail(UUID missedEmailId) throws ApiException {
        ApiResponse<MissedEmail> localVarResp = getMissedEmailWithHttpInfo(missedEmailId);
        return localVarResp.getData();
    }

    /**
     * Get MissedEmail
     * 
     * @param missedEmailId  (required)
     * @return ApiResponse&lt;MissedEmail&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MissedEmail> getMissedEmailWithHttpInfo(UUID missedEmailId) throws ApiException {
        okhttp3.Call localVarCall = getMissedEmailValidateBeforeCall(missedEmailId, null);
        Type localVarReturnType = new TypeToken<MissedEmail>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get MissedEmail (asynchronously)
     * 
     * @param missedEmailId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMissedEmailAsync(UUID missedEmailId, final ApiCallback<MissedEmail> _callback) throws ApiException {

        okhttp3.Call localVarCall = getMissedEmailValidateBeforeCall(missedEmailId, _callback);
        Type localVarReturnType = new TypeToken<MissedEmail>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for waitForNthMissedEmail
     * @param index Zero based index of the email to wait for. If 1 missed email already and you want to wait for the 2nd email pass index&#x3D;1 (required)
     * @param inboxId Optional inbox ID filter (optional)
     * @param timeout Optional timeout milliseconds (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForNthMissedEmailCall(Integer index, UUID inboxId, Long timeout, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/missed-emails/waitForNthMissedEmail";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        if (timeout != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timeout", timeout));
        }

        if (index != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("index", index));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call waitForNthMissedEmailValidateBeforeCall(Integer index, UUID inboxId, Long timeout, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling waitForNthMissedEmail(Async)");
        }
        

        okhttp3.Call localVarCall = waitForNthMissedEmailCall(index, inboxId, timeout, since, before, _callback);
        return localVarCall;

    }

    /**
     * Wait for Nth missed email
     * Wait for 0 based index missed email
     * @param index Zero based index of the email to wait for. If 1 missed email already and you want to wait for the 2nd email pass index&#x3D;1 (required)
     * @param inboxId Optional inbox ID filter (optional)
     * @param timeout Optional timeout milliseconds (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return MissedEmail
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MissedEmail waitForNthMissedEmail(Integer index, UUID inboxId, Long timeout, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        ApiResponse<MissedEmail> localVarResp = waitForNthMissedEmailWithHttpInfo(index, inboxId, timeout, since, before);
        return localVarResp.getData();
    }

    /**
     * Wait for Nth missed email
     * Wait for 0 based index missed email
     * @param index Zero based index of the email to wait for. If 1 missed email already and you want to wait for the 2nd email pass index&#x3D;1 (required)
     * @param inboxId Optional inbox ID filter (optional)
     * @param timeout Optional timeout milliseconds (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return ApiResponse&lt;MissedEmail&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MissedEmail> waitForNthMissedEmailWithHttpInfo(Integer index, UUID inboxId, Long timeout, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        okhttp3.Call localVarCall = waitForNthMissedEmailValidateBeforeCall(index, inboxId, timeout, since, before, null);
        Type localVarReturnType = new TypeToken<MissedEmail>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Wait for Nth missed email (asynchronously)
     * Wait for 0 based index missed email
     * @param index Zero based index of the email to wait for. If 1 missed email already and you want to wait for the 2nd email pass index&#x3D;1 (required)
     * @param inboxId Optional inbox ID filter (optional)
     * @param timeout Optional timeout milliseconds (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForNthMissedEmailAsync(Integer index, UUID inboxId, Long timeout, OffsetDateTime since, OffsetDateTime before, final ApiCallback<MissedEmail> _callback) throws ApiException {

        okhttp3.Call localVarCall = waitForNthMissedEmailValidateBeforeCall(index, inboxId, timeout, since, before, _callback);
        Type localVarReturnType = new TypeToken<MissedEmail>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
