/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.apis;

import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.clients.ProgressRequestBody;
import com.mailslurp.clients.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.mailslurp.models.EmailPreviewUrls;
import java.time.OffsetDateTime;
import com.mailslurp.models.PageSentEmailProjection;
import com.mailslurp.models.PageTrackingPixelProjection;
import com.mailslurp.models.RawEmailJson;
import com.mailslurp.models.SentEmailDto;
import java.util.UUID;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SentEmailsControllerApi {
    private ApiClient localVarApiClient;

    public SentEmailsControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SentEmailsControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for deleteAllSentEmails
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteAllSentEmailsCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/sent";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteAllSentEmailsValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = deleteAllSentEmailsCall(_callback);
        return localVarCall;

    }

    /**
     * Delete all sent email receipts
     * 
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteAllSentEmails() throws ApiException {
        deleteAllSentEmailsWithHttpInfo();
    }

    /**
     * Delete all sent email receipts
     * 
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteAllSentEmailsWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = deleteAllSentEmailsValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete all sent email receipts (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteAllSentEmailsAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteAllSentEmailsValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteSentEmail
     * @param id  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteSentEmailCall(UUID id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/sent/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteSentEmailValidateBeforeCall(UUID id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteSentEmail(Async)");
        }
        

        okhttp3.Call localVarCall = deleteSentEmailCall(id, _callback);
        return localVarCall;

    }

    /**
     * Delete sent email receipt
     * 
     * @param id  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteSentEmail(UUID id) throws ApiException {
        deleteSentEmailWithHttpInfo(id);
    }

    /**
     * Delete sent email receipt
     * 
     * @param id  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteSentEmailWithHttpInfo(UUID id) throws ApiException {
        okhttp3.Call localVarCall = deleteSentEmailValidateBeforeCall(id, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete sent email receipt (asynchronously)
     * 
     * @param id  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteSentEmailAsync(UUID id, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteSentEmailValidateBeforeCall(id, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAllSentTrackingPixels
     * @param page Optional page index in sent email tracking pixel list pagination (optional, default to 0)
     * @param size Optional page size in sent email tracking pixel list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllSentTrackingPixelsCall(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/sent/tracking-pixels";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (searchFilter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("searchFilter", searchFilter));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAllSentTrackingPixelsValidateBeforeCall(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getAllSentTrackingPixelsCall(page, size, sort, searchFilter, since, before, _callback);
        return localVarCall;

    }

    /**
     * 
     * Get all sent email tracking pixels in paginated form
     * @param page Optional page index in sent email tracking pixel list pagination (optional, default to 0)
     * @param size Optional page size in sent email tracking pixel list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return PageTrackingPixelProjection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageTrackingPixelProjection getAllSentTrackingPixels(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        ApiResponse<PageTrackingPixelProjection> localVarResp = getAllSentTrackingPixelsWithHttpInfo(page, size, sort, searchFilter, since, before);
        return localVarResp.getData();
    }

    /**
     * 
     * Get all sent email tracking pixels in paginated form
     * @param page Optional page index in sent email tracking pixel list pagination (optional, default to 0)
     * @param size Optional page size in sent email tracking pixel list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return ApiResponse&lt;PageTrackingPixelProjection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageTrackingPixelProjection> getAllSentTrackingPixelsWithHttpInfo(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        okhttp3.Call localVarCall = getAllSentTrackingPixelsValidateBeforeCall(page, size, sort, searchFilter, since, before, null);
        Type localVarReturnType = new TypeToken<PageTrackingPixelProjection>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get all sent email tracking pixels in paginated form
     * @param page Optional page index in sent email tracking pixel list pagination (optional, default to 0)
     * @param size Optional page size in sent email tracking pixel list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllSentTrackingPixelsAsync(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback<PageTrackingPixelProjection> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAllSentTrackingPixelsValidateBeforeCall(page, size, sort, searchFilter, since, before, _callback);
        Type localVarReturnType = new TypeToken<PageTrackingPixelProjection>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getRawSentEmailContents
     * @param emailId ID of email (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRawSentEmailContentsCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/sent/{emailId}/raw"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getRawSentEmailContentsValidateBeforeCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getRawSentEmailContents(Async)");
        }
        

        okhttp3.Call localVarCall = getRawSentEmailContentsCall(emailId, _callback);
        return localVarCall;

    }

    /**
     * Get raw sent email string. Returns unparsed raw SMTP message with headers and body.
     * Returns a raw, unparsed, and unprocessed sent email. If your client has issues processing the response it is likely due to the response content-type which is text/plain. If you need a JSON response content-type use the getRawSentEmailJson endpoint
     * @param emailId ID of email (required)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public String getRawSentEmailContents(UUID emailId) throws ApiException {
        ApiResponse<String> localVarResp = getRawSentEmailContentsWithHttpInfo(emailId);
        return localVarResp.getData();
    }

    /**
     * Get raw sent email string. Returns unparsed raw SMTP message with headers and body.
     * Returns a raw, unparsed, and unprocessed sent email. If your client has issues processing the response it is likely due to the response content-type which is text/plain. If you need a JSON response content-type use the getRawSentEmailJson endpoint
     * @param emailId ID of email (required)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<String> getRawSentEmailContentsWithHttpInfo(UUID emailId) throws ApiException {
        okhttp3.Call localVarCall = getRawSentEmailContentsValidateBeforeCall(emailId, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get raw sent email string. Returns unparsed raw SMTP message with headers and body. (asynchronously)
     * Returns a raw, unparsed, and unprocessed sent email. If your client has issues processing the response it is likely due to the response content-type which is text/plain. If you need a JSON response content-type use the getRawSentEmailJson endpoint
     * @param emailId ID of email (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRawSentEmailContentsAsync(UUID emailId, final ApiCallback<String> _callback) throws ApiException {

        okhttp3.Call localVarCall = getRawSentEmailContentsValidateBeforeCall(emailId, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getRawSentEmailJson
     * @param emailId ID of email (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRawSentEmailJsonCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/sent/{emailId}/raw/json"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getRawSentEmailJsonValidateBeforeCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getRawSentEmailJson(Async)");
        }
        

        okhttp3.Call localVarCall = getRawSentEmailJsonCall(emailId, _callback);
        return localVarCall;

    }

    /**
     * Get raw sent email in JSON. Unparsed SMTP message in JSON wrapper format.
     * Returns a raw, unparsed, and unprocessed sent email wrapped in a JSON response object for easier handling when compared with the getRawSentEmail text/plain response
     * @param emailId ID of email (required)
     * @return RawEmailJson
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public RawEmailJson getRawSentEmailJson(UUID emailId) throws ApiException {
        ApiResponse<RawEmailJson> localVarResp = getRawSentEmailJsonWithHttpInfo(emailId);
        return localVarResp.getData();
    }

    /**
     * Get raw sent email in JSON. Unparsed SMTP message in JSON wrapper format.
     * Returns a raw, unparsed, and unprocessed sent email wrapped in a JSON response object for easier handling when compared with the getRawSentEmail text/plain response
     * @param emailId ID of email (required)
     * @return ApiResponse&lt;RawEmailJson&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<RawEmailJson> getRawSentEmailJsonWithHttpInfo(UUID emailId) throws ApiException {
        okhttp3.Call localVarCall = getRawSentEmailJsonValidateBeforeCall(emailId, null);
        Type localVarReturnType = new TypeToken<RawEmailJson>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get raw sent email in JSON. Unparsed SMTP message in JSON wrapper format. (asynchronously)
     * Returns a raw, unparsed, and unprocessed sent email wrapped in a JSON response object for easier handling when compared with the getRawSentEmail text/plain response
     * @param emailId ID of email (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRawSentEmailJsonAsync(UUID emailId, final ApiCallback<RawEmailJson> _callback) throws ApiException {

        okhttp3.Call localVarCall = getRawSentEmailJsonValidateBeforeCall(emailId, _callback);
        Type localVarReturnType = new TypeToken<RawEmailJson>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getSentEmail
     * @param id  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSentEmailCall(UUID id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/sent/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getSentEmailValidateBeforeCall(UUID id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getSentEmail(Async)");
        }
        

        okhttp3.Call localVarCall = getSentEmailCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get sent email receipt
     * 
     * @param id  (required)
     * @return SentEmailDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public SentEmailDto getSentEmail(UUID id) throws ApiException {
        ApiResponse<SentEmailDto> localVarResp = getSentEmailWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get sent email receipt
     * 
     * @param id  (required)
     * @return ApiResponse&lt;SentEmailDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SentEmailDto> getSentEmailWithHttpInfo(UUID id) throws ApiException {
        okhttp3.Call localVarCall = getSentEmailValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get sent email receipt (asynchronously)
     * 
     * @param id  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSentEmailAsync(UUID id, final ApiCallback<SentEmailDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getSentEmailValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getSentEmailHTMLContent
     * @param id  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSentEmailHTMLContentCall(UUID id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/sent/{id}/html"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "text/html"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getSentEmailHTMLContentValidateBeforeCall(UUID id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getSentEmailHTMLContent(Async)");
        }
        

        okhttp3.Call localVarCall = getSentEmailHTMLContentCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get sent email HTML content
     * 
     * @param id  (required)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public String getSentEmailHTMLContent(UUID id) throws ApiException {
        ApiResponse<String> localVarResp = getSentEmailHTMLContentWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get sent email HTML content
     * 
     * @param id  (required)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<String> getSentEmailHTMLContentWithHttpInfo(UUID id) throws ApiException {
        okhttp3.Call localVarCall = getSentEmailHTMLContentValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get sent email HTML content (asynchronously)
     * 
     * @param id  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSentEmailHTMLContentAsync(UUID id, final ApiCallback<String> _callback) throws ApiException {

        okhttp3.Call localVarCall = getSentEmailHTMLContentValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getSentEmailPreviewURLs
     * @param id  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSentEmailPreviewURLsCall(UUID id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/sent/{id}/urls"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getSentEmailPreviewURLsValidateBeforeCall(UUID id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getSentEmailPreviewURLs(Async)");
        }
        

        okhttp3.Call localVarCall = getSentEmailPreviewURLsCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get sent email URL for viewing in browser or downloading
     * Get a list of URLs for sent email content as text/html or raw SMTP message for viewing the message in a browser.
     * @param id  (required)
     * @return EmailPreviewUrls
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public EmailPreviewUrls getSentEmailPreviewURLs(UUID id) throws ApiException {
        ApiResponse<EmailPreviewUrls> localVarResp = getSentEmailPreviewURLsWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get sent email URL for viewing in browser or downloading
     * Get a list of URLs for sent email content as text/html or raw SMTP message for viewing the message in a browser.
     * @param id  (required)
     * @return ApiResponse&lt;EmailPreviewUrls&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<EmailPreviewUrls> getSentEmailPreviewURLsWithHttpInfo(UUID id) throws ApiException {
        okhttp3.Call localVarCall = getSentEmailPreviewURLsValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<EmailPreviewUrls>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get sent email URL for viewing in browser or downloading (asynchronously)
     * Get a list of URLs for sent email content as text/html or raw SMTP message for viewing the message in a browser.
     * @param id  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSentEmailPreviewURLsAsync(UUID id, final ApiCallback<EmailPreviewUrls> _callback) throws ApiException {

        okhttp3.Call localVarCall = getSentEmailPreviewURLsValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<EmailPreviewUrls>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getSentEmailTrackingPixels
     * @param id  (required)
     * @param page Optional page index in sent email tracking pixel list pagination (optional, default to 0)
     * @param size Optional page size in sent email tracking pixel list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSentEmailTrackingPixelsCall(UUID id, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/sent/{id}/tracking-pixels"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (searchFilter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("searchFilter", searchFilter));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getSentEmailTrackingPixelsValidateBeforeCall(UUID id, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getSentEmailTrackingPixels(Async)");
        }
        

        okhttp3.Call localVarCall = getSentEmailTrackingPixelsCall(id, page, size, sort, searchFilter, since, before, _callback);
        return localVarCall;

    }

    /**
     * 
     * Get all tracking pixels for a sent email in paginated form
     * @param id  (required)
     * @param page Optional page index in sent email tracking pixel list pagination (optional, default to 0)
     * @param size Optional page size in sent email tracking pixel list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return PageTrackingPixelProjection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageTrackingPixelProjection getSentEmailTrackingPixels(UUID id, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        ApiResponse<PageTrackingPixelProjection> localVarResp = getSentEmailTrackingPixelsWithHttpInfo(id, page, size, sort, searchFilter, since, before);
        return localVarResp.getData();
    }

    /**
     * 
     * Get all tracking pixels for a sent email in paginated form
     * @param id  (required)
     * @param page Optional page index in sent email tracking pixel list pagination (optional, default to 0)
     * @param size Optional page size in sent email tracking pixel list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return ApiResponse&lt;PageTrackingPixelProjection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageTrackingPixelProjection> getSentEmailTrackingPixelsWithHttpInfo(UUID id, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        okhttp3.Call localVarCall = getSentEmailTrackingPixelsValidateBeforeCall(id, page, size, sort, searchFilter, since, before, null);
        Type localVarReturnType = new TypeToken<PageTrackingPixelProjection>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get all tracking pixels for a sent email in paginated form
     * @param id  (required)
     * @param page Optional page index in sent email tracking pixel list pagination (optional, default to 0)
     * @param size Optional page size in sent email tracking pixel list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSentEmailTrackingPixelsAsync(UUID id, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback<PageTrackingPixelProjection> _callback) throws ApiException {

        okhttp3.Call localVarCall = getSentEmailTrackingPixelsValidateBeforeCall(id, page, size, sort, searchFilter, since, before, _callback);
        Type localVarReturnType = new TypeToken<PageTrackingPixelProjection>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getSentEmails
     * @param inboxId Optional inboxId to filter sender of sent emails by (optional)
     * @param page Optional page index in inbox sent email list pagination (optional, default to 0)
     * @param size Optional page size in inbox sent email list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSentEmailsCall(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/sent";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (searchFilter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("searchFilter", searchFilter));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getSentEmailsValidateBeforeCall(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getSentEmailsCall(inboxId, page, size, sort, searchFilter, since, before, _callback);
        return localVarCall;

    }

    /**
     * Get all sent emails in paginated form
     * 
     * @param inboxId Optional inboxId to filter sender of sent emails by (optional)
     * @param page Optional page index in inbox sent email list pagination (optional, default to 0)
     * @param size Optional page size in inbox sent email list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return PageSentEmailProjection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageSentEmailProjection getSentEmails(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        ApiResponse<PageSentEmailProjection> localVarResp = getSentEmailsWithHttpInfo(inboxId, page, size, sort, searchFilter, since, before);
        return localVarResp.getData();
    }

    /**
     * Get all sent emails in paginated form
     * 
     * @param inboxId Optional inboxId to filter sender of sent emails by (optional)
     * @param page Optional page index in inbox sent email list pagination (optional, default to 0)
     * @param size Optional page size in inbox sent email list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return ApiResponse&lt;PageSentEmailProjection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageSentEmailProjection> getSentEmailsWithHttpInfo(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        okhttp3.Call localVarCall = getSentEmailsValidateBeforeCall(inboxId, page, size, sort, searchFilter, since, before, null);
        Type localVarReturnType = new TypeToken<PageSentEmailProjection>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get all sent emails in paginated form (asynchronously)
     * 
     * @param inboxId Optional inboxId to filter sender of sent emails by (optional)
     * @param page Optional page index in inbox sent email list pagination (optional, default to 0)
     * @param size Optional page size in inbox sent email list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSentEmailsAsync(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback<PageSentEmailProjection> _callback) throws ApiException {

        okhttp3.Call localVarCall = getSentEmailsValidateBeforeCall(inboxId, page, size, sort, searchFilter, since, before, _callback);
        Type localVarReturnType = new TypeToken<PageSentEmailProjection>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getSentOrganizationEmails
     * @param inboxId Optional inboxId to filter sender of sent emails by (optional)
     * @param page Optional page index in sent email list pagination (optional, default to 0)
     * @param size Optional page size in sent email list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSentOrganizationEmailsCall(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/sent/organization";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (searchFilter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("searchFilter", searchFilter));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getSentOrganizationEmailsValidateBeforeCall(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getSentOrganizationEmailsCall(inboxId, page, size, sort, searchFilter, since, before, _callback);
        return localVarCall;

    }

    /**
     * 
     * Get all sent organization emails in paginated form
     * @param inboxId Optional inboxId to filter sender of sent emails by (optional)
     * @param page Optional page index in sent email list pagination (optional, default to 0)
     * @param size Optional page size in sent email list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return PageSentEmailProjection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageSentEmailProjection getSentOrganizationEmails(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        ApiResponse<PageSentEmailProjection> localVarResp = getSentOrganizationEmailsWithHttpInfo(inboxId, page, size, sort, searchFilter, since, before);
        return localVarResp.getData();
    }

    /**
     * 
     * Get all sent organization emails in paginated form
     * @param inboxId Optional inboxId to filter sender of sent emails by (optional)
     * @param page Optional page index in sent email list pagination (optional, default to 0)
     * @param size Optional page size in sent email list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return ApiResponse&lt;PageSentEmailProjection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageSentEmailProjection> getSentOrganizationEmailsWithHttpInfo(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        okhttp3.Call localVarCall = getSentOrganizationEmailsValidateBeforeCall(inboxId, page, size, sort, searchFilter, since, before, null);
        Type localVarReturnType = new TypeToken<PageSentEmailProjection>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get all sent organization emails in paginated form
     * @param inboxId Optional inboxId to filter sender of sent emails by (optional)
     * @param page Optional page index in sent email list pagination (optional, default to 0)
     * @param size Optional page size in sent email list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSentOrganizationEmailsAsync(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback<PageSentEmailProjection> _callback) throws ApiException {

        okhttp3.Call localVarCall = getSentOrganizationEmailsValidateBeforeCall(inboxId, page, size, sort, searchFilter, since, before, _callback);
        Type localVarReturnType = new TypeToken<PageSentEmailProjection>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
