/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.apis;

import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.clients.ProgressRequestBody;
import com.mailslurp.clients.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.mailslurp.models.CreateTrackingPixelOptions;
import java.time.OffsetDateTime;
import com.mailslurp.models.PageTrackingPixelProjection;
import com.mailslurp.models.TrackingPixelDto;
import java.util.UUID;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TrackingControllerApi {
    private ApiClient localVarApiClient;

    public TrackingControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TrackingControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for createTrackingPixel
     * @param createTrackingPixelOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTrackingPixelCall(CreateTrackingPixelOptions createTrackingPixelOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = createTrackingPixelOptions;

        // create path and map variables
        String localVarPath = "/tracking/pixels";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createTrackingPixelValidateBeforeCall(CreateTrackingPixelOptions createTrackingPixelOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'createTrackingPixelOptions' is set
        if (createTrackingPixelOptions == null) {
            throw new ApiException("Missing the required parameter 'createTrackingPixelOptions' when calling createTrackingPixel(Async)");
        }
        

        okhttp3.Call localVarCall = createTrackingPixelCall(createTrackingPixelOptions, _callback);
        return localVarCall;

    }

    /**
     * Create tracking pixel
     * Create a tracking pixel. A tracking pixel is an image that can be embedded in an email. When the email is viewed and the image is seen MailSlurp will mark the pixel as seen. Use tracking pixels to monitor email open events. You can receive open notifications via webhook or by fetching the pixel.
     * @param createTrackingPixelOptions  (required)
     * @return TrackingPixelDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public TrackingPixelDto createTrackingPixel(CreateTrackingPixelOptions createTrackingPixelOptions) throws ApiException {
        ApiResponse<TrackingPixelDto> localVarResp = createTrackingPixelWithHttpInfo(createTrackingPixelOptions);
        return localVarResp.getData();
    }

    /**
     * Create tracking pixel
     * Create a tracking pixel. A tracking pixel is an image that can be embedded in an email. When the email is viewed and the image is seen MailSlurp will mark the pixel as seen. Use tracking pixels to monitor email open events. You can receive open notifications via webhook or by fetching the pixel.
     * @param createTrackingPixelOptions  (required)
     * @return ApiResponse&lt;TrackingPixelDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TrackingPixelDto> createTrackingPixelWithHttpInfo(CreateTrackingPixelOptions createTrackingPixelOptions) throws ApiException {
        okhttp3.Call localVarCall = createTrackingPixelValidateBeforeCall(createTrackingPixelOptions, null);
        Type localVarReturnType = new TypeToken<TrackingPixelDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create tracking pixel (asynchronously)
     * Create a tracking pixel. A tracking pixel is an image that can be embedded in an email. When the email is viewed and the image is seen MailSlurp will mark the pixel as seen. Use tracking pixels to monitor email open events. You can receive open notifications via webhook or by fetching the pixel.
     * @param createTrackingPixelOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTrackingPixelAsync(CreateTrackingPixelOptions createTrackingPixelOptions, final ApiCallback<TrackingPixelDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = createTrackingPixelValidateBeforeCall(createTrackingPixelOptions, _callback);
        Type localVarReturnType = new TypeToken<TrackingPixelDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAllTrackingPixels
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllTrackingPixelsCall(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/tracking/pixels";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (searchFilter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("searchFilter", searchFilter));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAllTrackingPixelsValidateBeforeCall(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getAllTrackingPixelsCall(page, size, sort, searchFilter, since, before, _callback);
        return localVarCall;

    }

    /**
     * Get tracking pixels
     * List tracking pixels in paginated form
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return PageTrackingPixelProjection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageTrackingPixelProjection getAllTrackingPixels(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        ApiResponse<PageTrackingPixelProjection> localVarResp = getAllTrackingPixelsWithHttpInfo(page, size, sort, searchFilter, since, before);
        return localVarResp.getData();
    }

    /**
     * Get tracking pixels
     * List tracking pixels in paginated form
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return ApiResponse&lt;PageTrackingPixelProjection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageTrackingPixelProjection> getAllTrackingPixelsWithHttpInfo(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        okhttp3.Call localVarCall = getAllTrackingPixelsValidateBeforeCall(page, size, sort, searchFilter, since, before, null);
        Type localVarReturnType = new TypeToken<PageTrackingPixelProjection>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get tracking pixels (asynchronously)
     * List tracking pixels in paginated form
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllTrackingPixelsAsync(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback<PageTrackingPixelProjection> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAllTrackingPixelsValidateBeforeCall(page, size, sort, searchFilter, since, before, _callback);
        Type localVarReturnType = new TypeToken<PageTrackingPixelProjection>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getTrackingPixel
     * @param id  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTrackingPixelCall(UUID id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/tracking/pixels/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTrackingPixelValidateBeforeCall(UUID id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getTrackingPixel(Async)");
        }
        

        okhttp3.Call localVarCall = getTrackingPixelCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get pixel
     * 
     * @param id  (required)
     * @return TrackingPixelDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TrackingPixelDto getTrackingPixel(UUID id) throws ApiException {
        ApiResponse<TrackingPixelDto> localVarResp = getTrackingPixelWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get pixel
     * 
     * @param id  (required)
     * @return ApiResponse&lt;TrackingPixelDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TrackingPixelDto> getTrackingPixelWithHttpInfo(UUID id) throws ApiException {
        okhttp3.Call localVarCall = getTrackingPixelValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<TrackingPixelDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get pixel (asynchronously)
     * 
     * @param id  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTrackingPixelAsync(UUID id, final ApiCallback<TrackingPixelDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getTrackingPixelValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<TrackingPixelDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
