/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.apis;

import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.clients.ProgressRequestBody;
import com.mailslurp.clients.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.mailslurp.models.Email;
import com.mailslurp.models.EmailPreview;
import com.mailslurp.models.MatchOptions;
import java.time.OffsetDateTime;
import java.util.UUID;
import com.mailslurp.models.WaitForConditions;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WaitForControllerApi {
    private ApiClient localVarApiClient;

    public WaitForControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WaitForControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for waitFor
     * @param waitForConditions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForCall(WaitForConditions waitForConditions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = waitForConditions;

        // create path and map variables
        String localVarPath = "/waitFor";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call waitForValidateBeforeCall(WaitForConditions waitForConditions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'waitForConditions' is set
        if (waitForConditions == null) {
            throw new ApiException("Missing the required parameter 'waitForConditions' when calling waitFor(Async)");
        }
        

        okhttp3.Call localVarCall = waitForCall(waitForConditions, _callback);
        return localVarCall;

    }

    /**
     * Wait for an email to match the provided filter conditions such as subject contains keyword.
     * Generic waitFor method that will wait until an inbox meets given conditions or return immediately if already met
     * @param waitForConditions  (required)
     * @return List&lt;EmailPreview&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public List<EmailPreview> waitFor(WaitForConditions waitForConditions) throws ApiException {
        ApiResponse<List<EmailPreview>> localVarResp = waitForWithHttpInfo(waitForConditions);
        return localVarResp.getData();
    }

    /**
     * Wait for an email to match the provided filter conditions such as subject contains keyword.
     * Generic waitFor method that will wait until an inbox meets given conditions or return immediately if already met
     * @param waitForConditions  (required)
     * @return ApiResponse&lt;List&lt;EmailPreview&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<EmailPreview>> waitForWithHttpInfo(WaitForConditions waitForConditions) throws ApiException {
        okhttp3.Call localVarCall = waitForValidateBeforeCall(waitForConditions, null);
        Type localVarReturnType = new TypeToken<List<EmailPreview>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Wait for an email to match the provided filter conditions such as subject contains keyword. (asynchronously)
     * Generic waitFor method that will wait until an inbox meets given conditions or return immediately if already met
     * @param waitForConditions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForAsync(WaitForConditions waitForConditions, final ApiCallback<List<EmailPreview>> _callback) throws ApiException {

        okhttp3.Call localVarCall = waitForValidateBeforeCall(waitForConditions, _callback);
        Type localVarReturnType = new TypeToken<List<EmailPreview>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for waitForEmailCount
     * @param inboxId Id of the inbox we are fetching emails from (required)
     * @param count Number of emails to wait for. Must be greater that 1 (required)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @param before Filter for emails that were received before the given timestamp (optional)
     * @param since Filter for emails that were received after the given timestamp (optional)
     * @param sort Sort direction (optional)
     * @param delay Max milliseconds delay between calls (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForEmailCountCall(UUID inboxId, Integer count, Long timeout, Boolean unreadOnly, OffsetDateTime before, OffsetDateTime since, String sort, Long delay, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/waitForEmailCount";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        if (count != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("count", count));
        }

        if (timeout != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timeout", timeout));
        }

        if (unreadOnly != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unreadOnly", unreadOnly));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (delay != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("delay", delay));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call waitForEmailCountValidateBeforeCall(UUID inboxId, Integer count, Long timeout, Boolean unreadOnly, OffsetDateTime before, OffsetDateTime since, String sort, Long delay, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling waitForEmailCount(Async)");
        }
        
        // verify the required parameter 'count' is set
        if (count == null) {
            throw new ApiException("Missing the required parameter 'count' when calling waitForEmailCount(Async)");
        }
        

        okhttp3.Call localVarCall = waitForEmailCountCall(inboxId, count, timeout, unreadOnly, before, since, sort, delay, _callback);
        return localVarCall;

    }

    /**
     * Wait for and return count number of emails. Hold connection until inbox count matches expected or timeout occurs
     * If inbox contains count or more emails at time of request then return count worth of emails. If not wait until the count is reached and return those or return an error if timeout is exceeded.
     * @param inboxId Id of the inbox we are fetching emails from (required)
     * @param count Number of emails to wait for. Must be greater that 1 (required)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @param before Filter for emails that were received before the given timestamp (optional)
     * @param since Filter for emails that were received after the given timestamp (optional)
     * @param sort Sort direction (optional)
     * @param delay Max milliseconds delay between calls (optional)
     * @return List&lt;EmailPreview&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public List<EmailPreview> waitForEmailCount(UUID inboxId, Integer count, Long timeout, Boolean unreadOnly, OffsetDateTime before, OffsetDateTime since, String sort, Long delay) throws ApiException {
        ApiResponse<List<EmailPreview>> localVarResp = waitForEmailCountWithHttpInfo(inboxId, count, timeout, unreadOnly, before, since, sort, delay);
        return localVarResp.getData();
    }

    /**
     * Wait for and return count number of emails. Hold connection until inbox count matches expected or timeout occurs
     * If inbox contains count or more emails at time of request then return count worth of emails. If not wait until the count is reached and return those or return an error if timeout is exceeded.
     * @param inboxId Id of the inbox we are fetching emails from (required)
     * @param count Number of emails to wait for. Must be greater that 1 (required)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @param before Filter for emails that were received before the given timestamp (optional)
     * @param since Filter for emails that were received after the given timestamp (optional)
     * @param sort Sort direction (optional)
     * @param delay Max milliseconds delay between calls (optional)
     * @return ApiResponse&lt;List&lt;EmailPreview&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<EmailPreview>> waitForEmailCountWithHttpInfo(UUID inboxId, Integer count, Long timeout, Boolean unreadOnly, OffsetDateTime before, OffsetDateTime since, String sort, Long delay) throws ApiException {
        okhttp3.Call localVarCall = waitForEmailCountValidateBeforeCall(inboxId, count, timeout, unreadOnly, before, since, sort, delay, null);
        Type localVarReturnType = new TypeToken<List<EmailPreview>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Wait for and return count number of emails. Hold connection until inbox count matches expected or timeout occurs (asynchronously)
     * If inbox contains count or more emails at time of request then return count worth of emails. If not wait until the count is reached and return those or return an error if timeout is exceeded.
     * @param inboxId Id of the inbox we are fetching emails from (required)
     * @param count Number of emails to wait for. Must be greater that 1 (required)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @param before Filter for emails that were received before the given timestamp (optional)
     * @param since Filter for emails that were received after the given timestamp (optional)
     * @param sort Sort direction (optional)
     * @param delay Max milliseconds delay between calls (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForEmailCountAsync(UUID inboxId, Integer count, Long timeout, Boolean unreadOnly, OffsetDateTime before, OffsetDateTime since, String sort, Long delay, final ApiCallback<List<EmailPreview>> _callback) throws ApiException {

        okhttp3.Call localVarCall = waitForEmailCountValidateBeforeCall(inboxId, count, timeout, unreadOnly, before, since, sort, delay, _callback);
        Type localVarReturnType = new TypeToken<List<EmailPreview>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for waitForLatestEmail
     * @param inboxId Id of the inbox we are fetching emails from (optional)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only. (optional, default to false)
     * @param before Filter for emails that were before after the given timestamp (optional)
     * @param since Filter for emails that were received after the given timestamp (optional)
     * @param sort Sort direction (optional)
     * @param delay Max milliseconds delay between calls (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForLatestEmailCall(UUID inboxId, Long timeout, Boolean unreadOnly, OffsetDateTime before, OffsetDateTime since, String sort, Long delay, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/waitForLatestEmail";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        if (timeout != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timeout", timeout));
        }

        if (unreadOnly != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unreadOnly", unreadOnly));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (delay != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("delay", delay));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call waitForLatestEmailValidateBeforeCall(UUID inboxId, Long timeout, Boolean unreadOnly, OffsetDateTime before, OffsetDateTime since, String sort, Long delay, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = waitForLatestEmailCall(inboxId, timeout, unreadOnly, before, since, sort, delay, _callback);
        return localVarCall;

    }

    /**
     * Fetch inbox&#39;s latest email or if empty wait for an email to arrive
     * Will return either the last received email or wait for an email to arrive and return that. If you need to wait for an email for a non-empty inbox set &#x60;unreadOnly&#x3D;true&#x60; or see the other receive methods such as &#x60;waitForNthEmail&#x60; or &#x60;waitForEmailCount&#x60;.
     * @param inboxId Id of the inbox we are fetching emails from (optional)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only. (optional, default to false)
     * @param before Filter for emails that were before after the given timestamp (optional)
     * @param since Filter for emails that were received after the given timestamp (optional)
     * @param sort Sort direction (optional)
     * @param delay Max milliseconds delay between calls (optional)
     * @return Email
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public Email waitForLatestEmail(UUID inboxId, Long timeout, Boolean unreadOnly, OffsetDateTime before, OffsetDateTime since, String sort, Long delay) throws ApiException {
        ApiResponse<Email> localVarResp = waitForLatestEmailWithHttpInfo(inboxId, timeout, unreadOnly, before, since, sort, delay);
        return localVarResp.getData();
    }

    /**
     * Fetch inbox&#39;s latest email or if empty wait for an email to arrive
     * Will return either the last received email or wait for an email to arrive and return that. If you need to wait for an email for a non-empty inbox set &#x60;unreadOnly&#x3D;true&#x60; or see the other receive methods such as &#x60;waitForNthEmail&#x60; or &#x60;waitForEmailCount&#x60;.
     * @param inboxId Id of the inbox we are fetching emails from (optional)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only. (optional, default to false)
     * @param before Filter for emails that were before after the given timestamp (optional)
     * @param since Filter for emails that were received after the given timestamp (optional)
     * @param sort Sort direction (optional)
     * @param delay Max milliseconds delay between calls (optional)
     * @return ApiResponse&lt;Email&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Email> waitForLatestEmailWithHttpInfo(UUID inboxId, Long timeout, Boolean unreadOnly, OffsetDateTime before, OffsetDateTime since, String sort, Long delay) throws ApiException {
        okhttp3.Call localVarCall = waitForLatestEmailValidateBeforeCall(inboxId, timeout, unreadOnly, before, since, sort, delay, null);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Fetch inbox&#39;s latest email or if empty wait for an email to arrive (asynchronously)
     * Will return either the last received email or wait for an email to arrive and return that. If you need to wait for an email for a non-empty inbox set &#x60;unreadOnly&#x3D;true&#x60; or see the other receive methods such as &#x60;waitForNthEmail&#x60; or &#x60;waitForEmailCount&#x60;.
     * @param inboxId Id of the inbox we are fetching emails from (optional)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only. (optional, default to false)
     * @param before Filter for emails that were before after the given timestamp (optional)
     * @param since Filter for emails that were received after the given timestamp (optional)
     * @param sort Sort direction (optional)
     * @param delay Max milliseconds delay between calls (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForLatestEmailAsync(UUID inboxId, Long timeout, Boolean unreadOnly, OffsetDateTime before, OffsetDateTime since, String sort, Long delay, final ApiCallback<Email> _callback) throws ApiException {

        okhttp3.Call localVarCall = waitForLatestEmailValidateBeforeCall(inboxId, timeout, unreadOnly, before, since, sort, delay, _callback);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for waitForMatchingEmails
     * @param inboxId Id of the inbox we are fetching emails from (required)
     * @param count Number of emails to wait for. Must be greater or equal to 1 (required)
     * @param matchOptions  (required)
     * @param before Filter for emails that were received before the given timestamp (optional)
     * @param since Filter for emails that were received after the given timestamp (optional)
     * @param sort Sort direction (optional)
     * @param delay Max milliseconds delay between calls (optional)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForMatchingEmailsCall(UUID inboxId, Integer count, MatchOptions matchOptions, OffsetDateTime before, OffsetDateTime since, String sort, Long delay, Long timeout, Boolean unreadOnly, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = matchOptions;

        // create path and map variables
        String localVarPath = "/waitForMatchingEmails";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        if (count != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("count", count));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (delay != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("delay", delay));
        }

        if (timeout != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timeout", timeout));
        }

        if (unreadOnly != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unreadOnly", unreadOnly));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call waitForMatchingEmailsValidateBeforeCall(UUID inboxId, Integer count, MatchOptions matchOptions, OffsetDateTime before, OffsetDateTime since, String sort, Long delay, Long timeout, Boolean unreadOnly, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling waitForMatchingEmails(Async)");
        }
        
        // verify the required parameter 'count' is set
        if (count == null) {
            throw new ApiException("Missing the required parameter 'count' when calling waitForMatchingEmails(Async)");
        }
        
        // verify the required parameter 'matchOptions' is set
        if (matchOptions == null) {
            throw new ApiException("Missing the required parameter 'matchOptions' when calling waitForMatchingEmails(Async)");
        }
        

        okhttp3.Call localVarCall = waitForMatchingEmailsCall(inboxId, count, matchOptions, before, since, sort, delay, timeout, unreadOnly, _callback);
        return localVarCall;

    }

    /**
     * Wait or return list of emails that match simple matching patterns
     * Perform a search of emails in an inbox with the given patterns. If results match expected count then return or else retry the search until results are found or timeout is reached. Match options allow simple CONTAINS or EQUALS filtering on SUBJECT, TO, BCC, CC, and FROM. See the &#x60;MatchOptions&#x60; object for options. An example payload is &#x60;{ matches: [{field: &#39;SUBJECT&#39;,should:&#39;CONTAIN&#39;,value:&#39;needle&#39;}] }&#x60;. You can use an array of matches and they will be applied sequentially to filter out emails. If you want to perform matches and extractions of content using Regex patterns see the EmailController &#x60;getEmailContentMatch&#x60; method.
     * @param inboxId Id of the inbox we are fetching emails from (required)
     * @param count Number of emails to wait for. Must be greater or equal to 1 (required)
     * @param matchOptions  (required)
     * @param before Filter for emails that were received before the given timestamp (optional)
     * @param since Filter for emails that were received after the given timestamp (optional)
     * @param sort Sort direction (optional)
     * @param delay Max milliseconds delay between calls (optional)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @return List&lt;EmailPreview&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public List<EmailPreview> waitForMatchingEmails(UUID inboxId, Integer count, MatchOptions matchOptions, OffsetDateTime before, OffsetDateTime since, String sort, Long delay, Long timeout, Boolean unreadOnly) throws ApiException {
        ApiResponse<List<EmailPreview>> localVarResp = waitForMatchingEmailsWithHttpInfo(inboxId, count, matchOptions, before, since, sort, delay, timeout, unreadOnly);
        return localVarResp.getData();
    }

    /**
     * Wait or return list of emails that match simple matching patterns
     * Perform a search of emails in an inbox with the given patterns. If results match expected count then return or else retry the search until results are found or timeout is reached. Match options allow simple CONTAINS or EQUALS filtering on SUBJECT, TO, BCC, CC, and FROM. See the &#x60;MatchOptions&#x60; object for options. An example payload is &#x60;{ matches: [{field: &#39;SUBJECT&#39;,should:&#39;CONTAIN&#39;,value:&#39;needle&#39;}] }&#x60;. You can use an array of matches and they will be applied sequentially to filter out emails. If you want to perform matches and extractions of content using Regex patterns see the EmailController &#x60;getEmailContentMatch&#x60; method.
     * @param inboxId Id of the inbox we are fetching emails from (required)
     * @param count Number of emails to wait for. Must be greater or equal to 1 (required)
     * @param matchOptions  (required)
     * @param before Filter for emails that were received before the given timestamp (optional)
     * @param since Filter for emails that were received after the given timestamp (optional)
     * @param sort Sort direction (optional)
     * @param delay Max milliseconds delay between calls (optional)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @return ApiResponse&lt;List&lt;EmailPreview&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<EmailPreview>> waitForMatchingEmailsWithHttpInfo(UUID inboxId, Integer count, MatchOptions matchOptions, OffsetDateTime before, OffsetDateTime since, String sort, Long delay, Long timeout, Boolean unreadOnly) throws ApiException {
        okhttp3.Call localVarCall = waitForMatchingEmailsValidateBeforeCall(inboxId, count, matchOptions, before, since, sort, delay, timeout, unreadOnly, null);
        Type localVarReturnType = new TypeToken<List<EmailPreview>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Wait or return list of emails that match simple matching patterns (asynchronously)
     * Perform a search of emails in an inbox with the given patterns. If results match expected count then return or else retry the search until results are found or timeout is reached. Match options allow simple CONTAINS or EQUALS filtering on SUBJECT, TO, BCC, CC, and FROM. See the &#x60;MatchOptions&#x60; object for options. An example payload is &#x60;{ matches: [{field: &#39;SUBJECT&#39;,should:&#39;CONTAIN&#39;,value:&#39;needle&#39;}] }&#x60;. You can use an array of matches and they will be applied sequentially to filter out emails. If you want to perform matches and extractions of content using Regex patterns see the EmailController &#x60;getEmailContentMatch&#x60; method.
     * @param inboxId Id of the inbox we are fetching emails from (required)
     * @param count Number of emails to wait for. Must be greater or equal to 1 (required)
     * @param matchOptions  (required)
     * @param before Filter for emails that were received before the given timestamp (optional)
     * @param since Filter for emails that were received after the given timestamp (optional)
     * @param sort Sort direction (optional)
     * @param delay Max milliseconds delay between calls (optional)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForMatchingEmailsAsync(UUID inboxId, Integer count, MatchOptions matchOptions, OffsetDateTime before, OffsetDateTime since, String sort, Long delay, Long timeout, Boolean unreadOnly, final ApiCallback<List<EmailPreview>> _callback) throws ApiException {

        okhttp3.Call localVarCall = waitForMatchingEmailsValidateBeforeCall(inboxId, count, matchOptions, before, since, sort, delay, timeout, unreadOnly, _callback);
        Type localVarReturnType = new TypeToken<List<EmailPreview>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for waitForMatchingFirstEmail
     * @param inboxId Id of the inbox we are matching an email for (required)
     * @param matchOptions  (required)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @param since Filter for emails that were received after the given timestamp (optional)
     * @param before Filter for emails that were received before the given timestamp (optional)
     * @param sort Sort direction (optional)
     * @param delay Max milliseconds delay between calls (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForMatchingFirstEmailCall(UUID inboxId, MatchOptions matchOptions, Long timeout, Boolean unreadOnly, OffsetDateTime since, OffsetDateTime before, String sort, Long delay, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = matchOptions;

        // create path and map variables
        String localVarPath = "/waitForMatchingFirstEmail";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        if (timeout != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timeout", timeout));
        }

        if (unreadOnly != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unreadOnly", unreadOnly));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (delay != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("delay", delay));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call waitForMatchingFirstEmailValidateBeforeCall(UUID inboxId, MatchOptions matchOptions, Long timeout, Boolean unreadOnly, OffsetDateTime since, OffsetDateTime before, String sort, Long delay, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling waitForMatchingFirstEmail(Async)");
        }
        
        // verify the required parameter 'matchOptions' is set
        if (matchOptions == null) {
            throw new ApiException("Missing the required parameter 'matchOptions' when calling waitForMatchingFirstEmail(Async)");
        }
        

        okhttp3.Call localVarCall = waitForMatchingFirstEmailCall(inboxId, matchOptions, timeout, unreadOnly, since, before, sort, delay, _callback);
        return localVarCall;

    }

    /**
     * Wait for or return the first email that matches provided MatchOptions array
     * Perform a search of emails in an inbox with the given patterns. If a result if found then return or else retry the search until a result is found or timeout is reached. Match options allow simple CONTAINS or EQUALS filtering on SUBJECT, TO, BCC, CC, and FROM. See the &#x60;MatchOptions&#x60; object for options. An example payload is &#x60;{ matches: [{field: &#39;SUBJECT&#39;,should:&#39;CONTAIN&#39;,value:&#39;needle&#39;}] }&#x60;. You can use an array of matches and they will be applied sequentially to filter out emails. If you want to perform matches and extractions of content using Regex patterns see the EmailController &#x60;getEmailContentMatch&#x60; method.
     * @param inboxId Id of the inbox we are matching an email for (required)
     * @param matchOptions  (required)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @param since Filter for emails that were received after the given timestamp (optional)
     * @param before Filter for emails that were received before the given timestamp (optional)
     * @param sort Sort direction (optional)
     * @param delay Max milliseconds delay between calls (optional)
     * @return Email
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public Email waitForMatchingFirstEmail(UUID inboxId, MatchOptions matchOptions, Long timeout, Boolean unreadOnly, OffsetDateTime since, OffsetDateTime before, String sort, Long delay) throws ApiException {
        ApiResponse<Email> localVarResp = waitForMatchingFirstEmailWithHttpInfo(inboxId, matchOptions, timeout, unreadOnly, since, before, sort, delay);
        return localVarResp.getData();
    }

    /**
     * Wait for or return the first email that matches provided MatchOptions array
     * Perform a search of emails in an inbox with the given patterns. If a result if found then return or else retry the search until a result is found or timeout is reached. Match options allow simple CONTAINS or EQUALS filtering on SUBJECT, TO, BCC, CC, and FROM. See the &#x60;MatchOptions&#x60; object for options. An example payload is &#x60;{ matches: [{field: &#39;SUBJECT&#39;,should:&#39;CONTAIN&#39;,value:&#39;needle&#39;}] }&#x60;. You can use an array of matches and they will be applied sequentially to filter out emails. If you want to perform matches and extractions of content using Regex patterns see the EmailController &#x60;getEmailContentMatch&#x60; method.
     * @param inboxId Id of the inbox we are matching an email for (required)
     * @param matchOptions  (required)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @param since Filter for emails that were received after the given timestamp (optional)
     * @param before Filter for emails that were received before the given timestamp (optional)
     * @param sort Sort direction (optional)
     * @param delay Max milliseconds delay between calls (optional)
     * @return ApiResponse&lt;Email&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Email> waitForMatchingFirstEmailWithHttpInfo(UUID inboxId, MatchOptions matchOptions, Long timeout, Boolean unreadOnly, OffsetDateTime since, OffsetDateTime before, String sort, Long delay) throws ApiException {
        okhttp3.Call localVarCall = waitForMatchingFirstEmailValidateBeforeCall(inboxId, matchOptions, timeout, unreadOnly, since, before, sort, delay, null);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Wait for or return the first email that matches provided MatchOptions array (asynchronously)
     * Perform a search of emails in an inbox with the given patterns. If a result if found then return or else retry the search until a result is found or timeout is reached. Match options allow simple CONTAINS or EQUALS filtering on SUBJECT, TO, BCC, CC, and FROM. See the &#x60;MatchOptions&#x60; object for options. An example payload is &#x60;{ matches: [{field: &#39;SUBJECT&#39;,should:&#39;CONTAIN&#39;,value:&#39;needle&#39;}] }&#x60;. You can use an array of matches and they will be applied sequentially to filter out emails. If you want to perform matches and extractions of content using Regex patterns see the EmailController &#x60;getEmailContentMatch&#x60; method.
     * @param inboxId Id of the inbox we are matching an email for (required)
     * @param matchOptions  (required)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @param since Filter for emails that were received after the given timestamp (optional)
     * @param before Filter for emails that were received before the given timestamp (optional)
     * @param sort Sort direction (optional)
     * @param delay Max milliseconds delay between calls (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForMatchingFirstEmailAsync(UUID inboxId, MatchOptions matchOptions, Long timeout, Boolean unreadOnly, OffsetDateTime since, OffsetDateTime before, String sort, Long delay, final ApiCallback<Email> _callback) throws ApiException {

        okhttp3.Call localVarCall = waitForMatchingFirstEmailValidateBeforeCall(inboxId, matchOptions, timeout, unreadOnly, since, before, sort, delay, _callback);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for waitForNthEmail
     * @param inboxId Id of the inbox you are fetching emails from (optional)
     * @param index Zero based index of the email to wait for. If an inbox has 1 email already and you want to wait for the 2nd email pass index&#x3D;1 (optional, default to 0)
     * @param timeout Max milliseconds to wait for the nth email if not already present (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @param since Filter for emails that were received after the given timestamp (optional)
     * @param before Filter for emails that were received before the given timestamp (optional)
     * @param sort Sort direction (optional)
     * @param delay Max milliseconds delay between calls (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForNthEmailCall(UUID inboxId, Integer index, Long timeout, Boolean unreadOnly, OffsetDateTime since, OffsetDateTime before, String sort, Long delay, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/waitForNthEmail";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        if (index != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("index", index));
        }

        if (timeout != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timeout", timeout));
        }

        if (unreadOnly != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unreadOnly", unreadOnly));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (delay != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("delay", delay));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call waitForNthEmailValidateBeforeCall(UUID inboxId, Integer index, Long timeout, Boolean unreadOnly, OffsetDateTime since, OffsetDateTime before, String sort, Long delay, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = waitForNthEmailCall(inboxId, index, timeout, unreadOnly, since, before, sort, delay, _callback);
        return localVarCall;

    }

    /**
     * Wait for or fetch the email with a given index in the inbox specified. If index doesn&#39;t exist waits for it to exist or timeout to occur.
     * If nth email is already present in inbox then return it. If not hold the connection open until timeout expires or the nth email is received and returned.
     * @param inboxId Id of the inbox you are fetching emails from (optional)
     * @param index Zero based index of the email to wait for. If an inbox has 1 email already and you want to wait for the 2nd email pass index&#x3D;1 (optional, default to 0)
     * @param timeout Max milliseconds to wait for the nth email if not already present (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @param since Filter for emails that were received after the given timestamp (optional)
     * @param before Filter for emails that were received before the given timestamp (optional)
     * @param sort Sort direction (optional)
     * @param delay Max milliseconds delay between calls (optional)
     * @return Email
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public Email waitForNthEmail(UUID inboxId, Integer index, Long timeout, Boolean unreadOnly, OffsetDateTime since, OffsetDateTime before, String sort, Long delay) throws ApiException {
        ApiResponse<Email> localVarResp = waitForNthEmailWithHttpInfo(inboxId, index, timeout, unreadOnly, since, before, sort, delay);
        return localVarResp.getData();
    }

    /**
     * Wait for or fetch the email with a given index in the inbox specified. If index doesn&#39;t exist waits for it to exist or timeout to occur.
     * If nth email is already present in inbox then return it. If not hold the connection open until timeout expires or the nth email is received and returned.
     * @param inboxId Id of the inbox you are fetching emails from (optional)
     * @param index Zero based index of the email to wait for. If an inbox has 1 email already and you want to wait for the 2nd email pass index&#x3D;1 (optional, default to 0)
     * @param timeout Max milliseconds to wait for the nth email if not already present (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @param since Filter for emails that were received after the given timestamp (optional)
     * @param before Filter for emails that were received before the given timestamp (optional)
     * @param sort Sort direction (optional)
     * @param delay Max milliseconds delay between calls (optional)
     * @return ApiResponse&lt;Email&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Email> waitForNthEmailWithHttpInfo(UUID inboxId, Integer index, Long timeout, Boolean unreadOnly, OffsetDateTime since, OffsetDateTime before, String sort, Long delay) throws ApiException {
        okhttp3.Call localVarCall = waitForNthEmailValidateBeforeCall(inboxId, index, timeout, unreadOnly, since, before, sort, delay, null);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Wait for or fetch the email with a given index in the inbox specified. If index doesn&#39;t exist waits for it to exist or timeout to occur. (asynchronously)
     * If nth email is already present in inbox then return it. If not hold the connection open until timeout expires or the nth email is received and returned.
     * @param inboxId Id of the inbox you are fetching emails from (optional)
     * @param index Zero based index of the email to wait for. If an inbox has 1 email already and you want to wait for the 2nd email pass index&#x3D;1 (optional, default to 0)
     * @param timeout Max milliseconds to wait for the nth email if not already present (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @param since Filter for emails that were received after the given timestamp (optional)
     * @param before Filter for emails that were received before the given timestamp (optional)
     * @param sort Sort direction (optional)
     * @param delay Max milliseconds delay between calls (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForNthEmailAsync(UUID inboxId, Integer index, Long timeout, Boolean unreadOnly, OffsetDateTime since, OffsetDateTime before, String sort, Long delay, final ApiCallback<Email> _callback) throws ApiException {

        okhttp3.Call localVarCall = waitForNthEmailValidateBeforeCall(inboxId, index, timeout, unreadOnly, since, before, sort, delay, _callback);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
