/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.apis;

import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.clients.ProgressRequestBody;
import com.mailslurp.clients.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.mailslurp.models.AbstractWebhookPayload;
import com.mailslurp.models.CreateWebhookOptions;
import com.mailslurp.models.JSONSchemaDto;
import java.time.OffsetDateTime;
import com.mailslurp.models.PageWebhookProjection;
import com.mailslurp.models.PageWebhookResult;
import java.util.UUID;
import com.mailslurp.models.UnseenErrorCountDto;
import com.mailslurp.models.WebhookDto;
import com.mailslurp.models.WebhookEmailOpenedPayload;
import com.mailslurp.models.WebhookEmailReadPayload;
import com.mailslurp.models.WebhookNewAttachmentPayload;
import com.mailslurp.models.WebhookNewContactPayload;
import com.mailslurp.models.WebhookNewEmailPayload;
import com.mailslurp.models.WebhookRedriveResult;
import com.mailslurp.models.WebhookResultDto;
import com.mailslurp.models.WebhookTestResult;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebhookControllerApi {
    private ApiClient localVarApiClient;

    public WebhookControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WebhookControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for createWebhook
     * @param inboxId  (required)
     * @param createWebhookOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createWebhookCall(UUID inboxId, CreateWebhookOptions createWebhookOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = createWebhookOptions;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}/webhooks"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createWebhookValidateBeforeCall(UUID inboxId, CreateWebhookOptions createWebhookOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling createWebhook(Async)");
        }
        
        // verify the required parameter 'createWebhookOptions' is set
        if (createWebhookOptions == null) {
            throw new ApiException("Missing the required parameter 'createWebhookOptions' when calling createWebhook(Async)");
        }
        

        okhttp3.Call localVarCall = createWebhookCall(inboxId, createWebhookOptions, _callback);
        return localVarCall;

    }

    /**
     * Attach a WebHook URL to an inbox
     * Get notified whenever an inbox receives an email via a WebHook URL. An emailID will be posted to this URL every time an email is received for this inbox. The URL must be publicly reachable by the MailSlurp server. You can provide basicAuth values if you wish to secure this endpoint.
     * @param inboxId  (required)
     * @param createWebhookOptions  (required)
     * @return WebhookDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public WebhookDto createWebhook(UUID inboxId, CreateWebhookOptions createWebhookOptions) throws ApiException {
        ApiResponse<WebhookDto> localVarResp = createWebhookWithHttpInfo(inboxId, createWebhookOptions);
        return localVarResp.getData();
    }

    /**
     * Attach a WebHook URL to an inbox
     * Get notified whenever an inbox receives an email via a WebHook URL. An emailID will be posted to this URL every time an email is received for this inbox. The URL must be publicly reachable by the MailSlurp server. You can provide basicAuth values if you wish to secure this endpoint.
     * @param inboxId  (required)
     * @param createWebhookOptions  (required)
     * @return ApiResponse&lt;WebhookDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WebhookDto> createWebhookWithHttpInfo(UUID inboxId, CreateWebhookOptions createWebhookOptions) throws ApiException {
        okhttp3.Call localVarCall = createWebhookValidateBeforeCall(inboxId, createWebhookOptions, null);
        Type localVarReturnType = new TypeToken<WebhookDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Attach a WebHook URL to an inbox (asynchronously)
     * Get notified whenever an inbox receives an email via a WebHook URL. An emailID will be posted to this URL every time an email is received for this inbox. The URL must be publicly reachable by the MailSlurp server. You can provide basicAuth values if you wish to secure this endpoint.
     * @param inboxId  (required)
     * @param createWebhookOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createWebhookAsync(UUID inboxId, CreateWebhookOptions createWebhookOptions, final ApiCallback<WebhookDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = createWebhookValidateBeforeCall(inboxId, createWebhookOptions, _callback);
        Type localVarReturnType = new TypeToken<WebhookDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteAllWebhooks
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteAllWebhooksCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/webhooks";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteAllWebhooksValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = deleteAllWebhooksCall(_callback);
        return localVarCall;

    }

    /**
     * Delete all webhooks
     * 
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteAllWebhooks() throws ApiException {
        deleteAllWebhooksWithHttpInfo();
    }

    /**
     * Delete all webhooks
     * 
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteAllWebhooksWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = deleteAllWebhooksValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete all webhooks (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteAllWebhooksAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteAllWebhooksValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteWebhook
     * @param inboxId  (required)
     * @param webhookId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteWebhookCall(UUID inboxId, UUID webhookId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}/webhooks/{webhookId}"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()))
            .replaceAll("\\{" + "webhookId" + "\\}", localVarApiClient.escapeString(webhookId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteWebhookValidateBeforeCall(UUID inboxId, UUID webhookId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling deleteWebhook(Async)");
        }
        
        // verify the required parameter 'webhookId' is set
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId' when calling deleteWebhook(Async)");
        }
        

        okhttp3.Call localVarCall = deleteWebhookCall(inboxId, webhookId, _callback);
        return localVarCall;

    }

    /**
     * Delete and disable a Webhook for an Inbox
     * 
     * @param inboxId  (required)
     * @param webhookId  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteWebhook(UUID inboxId, UUID webhookId) throws ApiException {
        deleteWebhookWithHttpInfo(inboxId, webhookId);
    }

    /**
     * Delete and disable a Webhook for an Inbox
     * 
     * @param inboxId  (required)
     * @param webhookId  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteWebhookWithHttpInfo(UUID inboxId, UUID webhookId) throws ApiException {
        okhttp3.Call localVarCall = deleteWebhookValidateBeforeCall(inboxId, webhookId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete and disable a Webhook for an Inbox (asynchronously)
     * 
     * @param inboxId  (required)
     * @param webhookId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteWebhookAsync(UUID inboxId, UUID webhookId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteWebhookValidateBeforeCall(inboxId, webhookId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAllWebhookResults
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param unseenOnly Filter for unseen exceptions only (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllWebhookResultsCall(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, Boolean unseenOnly, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/webhooks/results";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (searchFilter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("searchFilter", searchFilter));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        if (unseenOnly != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unseenOnly", unseenOnly));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAllWebhookResultsValidateBeforeCall(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, Boolean unseenOnly, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getAllWebhookResultsCall(page, size, sort, searchFilter, since, before, unseenOnly, _callback);
        return localVarCall;

    }

    /**
     * Get results for all webhooks
     * 
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param unseenOnly Filter for unseen exceptions only (optional)
     * @return PageWebhookResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageWebhookResult getAllWebhookResults(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, Boolean unseenOnly) throws ApiException {
        ApiResponse<PageWebhookResult> localVarResp = getAllWebhookResultsWithHttpInfo(page, size, sort, searchFilter, since, before, unseenOnly);
        return localVarResp.getData();
    }

    /**
     * Get results for all webhooks
     * 
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param unseenOnly Filter for unseen exceptions only (optional)
     * @return ApiResponse&lt;PageWebhookResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageWebhookResult> getAllWebhookResultsWithHttpInfo(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, Boolean unseenOnly) throws ApiException {
        okhttp3.Call localVarCall = getAllWebhookResultsValidateBeforeCall(page, size, sort, searchFilter, since, before, unseenOnly, null);
        Type localVarReturnType = new TypeToken<PageWebhookResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get results for all webhooks (asynchronously)
     * 
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param unseenOnly Filter for unseen exceptions only (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllWebhookResultsAsync(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, Boolean unseenOnly, final ApiCallback<PageWebhookResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAllWebhookResultsValidateBeforeCall(page, size, sort, searchFilter, since, before, unseenOnly, _callback);
        Type localVarReturnType = new TypeToken<PageWebhookResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAllWebhooks
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size for paginated result list. (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to DESC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllWebhooksCall(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/webhooks/paginated";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (searchFilter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("searchFilter", searchFilter));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAllWebhooksValidateBeforeCall(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getAllWebhooksCall(page, size, sort, searchFilter, since, before, _callback);
        return localVarCall;

    }

    /**
     * List Webhooks Paginated
     * List webhooks in paginated form. Allows for page index, page size, and sort direction.
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size for paginated result list. (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to DESC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return PageWebhookProjection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageWebhookProjection getAllWebhooks(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        ApiResponse<PageWebhookProjection> localVarResp = getAllWebhooksWithHttpInfo(page, size, sort, searchFilter, since, before);
        return localVarResp.getData();
    }

    /**
     * List Webhooks Paginated
     * List webhooks in paginated form. Allows for page index, page size, and sort direction.
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size for paginated result list. (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to DESC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return ApiResponse&lt;PageWebhookProjection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageWebhookProjection> getAllWebhooksWithHttpInfo(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        okhttp3.Call localVarCall = getAllWebhooksValidateBeforeCall(page, size, sort, searchFilter, since, before, null);
        Type localVarReturnType = new TypeToken<PageWebhookProjection>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List Webhooks Paginated (asynchronously)
     * List webhooks in paginated form. Allows for page index, page size, and sort direction.
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size for paginated result list. (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to DESC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllWebhooksAsync(Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback<PageWebhookProjection> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAllWebhooksValidateBeforeCall(page, size, sort, searchFilter, since, before, _callback);
        Type localVarReturnType = new TypeToken<PageWebhookProjection>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getInboxWebhooksPaginated
     * @param inboxId  (required)
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxWebhooksPaginatedCall(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}/webhooks/paginated"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (searchFilter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("searchFilter", searchFilter));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getInboxWebhooksPaginatedValidateBeforeCall(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling getInboxWebhooksPaginated(Async)");
        }
        

        okhttp3.Call localVarCall = getInboxWebhooksPaginatedCall(inboxId, page, size, sort, searchFilter, since, before, _callback);
        return localVarCall;

    }

    /**
     * Get paginated webhooks for an Inbox
     * 
     * @param inboxId  (required)
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return PageWebhookProjection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageWebhookProjection getInboxWebhooksPaginated(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        ApiResponse<PageWebhookProjection> localVarResp = getInboxWebhooksPaginatedWithHttpInfo(inboxId, page, size, sort, searchFilter, since, before);
        return localVarResp.getData();
    }

    /**
     * Get paginated webhooks for an Inbox
     * 
     * @param inboxId  (required)
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @return ApiResponse&lt;PageWebhookProjection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageWebhookProjection> getInboxWebhooksPaginatedWithHttpInfo(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        okhttp3.Call localVarCall = getInboxWebhooksPaginatedValidateBeforeCall(inboxId, page, size, sort, searchFilter, since, before, null);
        Type localVarReturnType = new TypeToken<PageWebhookProjection>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get paginated webhooks for an Inbox (asynchronously)
     * 
     * @param inboxId  (required)
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxWebhooksPaginatedAsync(UUID inboxId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, final ApiCallback<PageWebhookProjection> _callback) throws ApiException {

        okhttp3.Call localVarCall = getInboxWebhooksPaginatedValidateBeforeCall(inboxId, page, size, sort, searchFilter, since, before, _callback);
        Type localVarReturnType = new TypeToken<PageWebhookProjection>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getJsonSchemaForWebhookPayload
     * @param webhookId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getJsonSchemaForWebhookPayloadCall(UUID webhookId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/webhooks/{webhookId}/schema"
            .replaceAll("\\{" + "webhookId" + "\\}", localVarApiClient.escapeString(webhookId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getJsonSchemaForWebhookPayloadValidateBeforeCall(UUID webhookId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'webhookId' is set
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId' when calling getJsonSchemaForWebhookPayload(Async)");
        }
        

        okhttp3.Call localVarCall = getJsonSchemaForWebhookPayloadCall(webhookId, _callback);
        return localVarCall;

    }

    /**
     * 
     * Get JSON Schema definition for webhook payload
     * @param webhookId  (required)
     * @return JSONSchemaDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public JSONSchemaDto getJsonSchemaForWebhookPayload(UUID webhookId) throws ApiException {
        ApiResponse<JSONSchemaDto> localVarResp = getJsonSchemaForWebhookPayloadWithHttpInfo(webhookId);
        return localVarResp.getData();
    }

    /**
     * 
     * Get JSON Schema definition for webhook payload
     * @param webhookId  (required)
     * @return ApiResponse&lt;JSONSchemaDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<JSONSchemaDto> getJsonSchemaForWebhookPayloadWithHttpInfo(UUID webhookId) throws ApiException {
        okhttp3.Call localVarCall = getJsonSchemaForWebhookPayloadValidateBeforeCall(webhookId, null);
        Type localVarReturnType = new TypeToken<JSONSchemaDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get JSON Schema definition for webhook payload
     * @param webhookId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getJsonSchemaForWebhookPayloadAsync(UUID webhookId, final ApiCallback<JSONSchemaDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getJsonSchemaForWebhookPayloadValidateBeforeCall(webhookId, _callback);
        Type localVarReturnType = new TypeToken<JSONSchemaDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getTestWebhookPayload
     * @param eventName  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTestWebhookPayloadCall(String eventName, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/webhooks/test";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (eventName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("eventName", eventName));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTestWebhookPayloadValidateBeforeCall(String eventName, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getTestWebhookPayloadCall(eventName, _callback);
        return localVarCall;

    }

    /**
     * 
     * Get test webhook payload example. Response content depends on eventName passed. Uses &#x60;EMAIL_RECEIVED&#x60; as default.
     * @param eventName  (optional)
     * @return AbstractWebhookPayload
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AbstractWebhookPayload getTestWebhookPayload(String eventName) throws ApiException {
        ApiResponse<AbstractWebhookPayload> localVarResp = getTestWebhookPayloadWithHttpInfo(eventName);
        return localVarResp.getData();
    }

    /**
     * 
     * Get test webhook payload example. Response content depends on eventName passed. Uses &#x60;EMAIL_RECEIVED&#x60; as default.
     * @param eventName  (optional)
     * @return ApiResponse&lt;AbstractWebhookPayload&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AbstractWebhookPayload> getTestWebhookPayloadWithHttpInfo(String eventName) throws ApiException {
        okhttp3.Call localVarCall = getTestWebhookPayloadValidateBeforeCall(eventName, null);
        Type localVarReturnType = new TypeToken<AbstractWebhookPayload>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get test webhook payload example. Response content depends on eventName passed. Uses &#x60;EMAIL_RECEIVED&#x60; as default.
     * @param eventName  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTestWebhookPayloadAsync(String eventName, final ApiCallback<AbstractWebhookPayload> _callback) throws ApiException {

        okhttp3.Call localVarCall = getTestWebhookPayloadValidateBeforeCall(eventName, _callback);
        Type localVarReturnType = new TypeToken<AbstractWebhookPayload>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getTestWebhookPayloadEmailOpened
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTestWebhookPayloadEmailOpenedCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/webhooks/test/email-opened-payload";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTestWebhookPayloadEmailOpenedValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getTestWebhookPayloadEmailOpenedCall(_callback);
        return localVarCall;

    }

    /**
     * 
     * Get webhook test payload for email opened event
     * @return WebhookEmailOpenedPayload
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public WebhookEmailOpenedPayload getTestWebhookPayloadEmailOpened() throws ApiException {
        ApiResponse<WebhookEmailOpenedPayload> localVarResp = getTestWebhookPayloadEmailOpenedWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * 
     * Get webhook test payload for email opened event
     * @return ApiResponse&lt;WebhookEmailOpenedPayload&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WebhookEmailOpenedPayload> getTestWebhookPayloadEmailOpenedWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getTestWebhookPayloadEmailOpenedValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<WebhookEmailOpenedPayload>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get webhook test payload for email opened event
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTestWebhookPayloadEmailOpenedAsync(final ApiCallback<WebhookEmailOpenedPayload> _callback) throws ApiException {

        okhttp3.Call localVarCall = getTestWebhookPayloadEmailOpenedValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<WebhookEmailOpenedPayload>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getTestWebhookPayloadEmailRead
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTestWebhookPayloadEmailReadCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/webhooks/test/email-read-payload";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTestWebhookPayloadEmailReadValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getTestWebhookPayloadEmailReadCall(_callback);
        return localVarCall;

    }

    /**
     * 
     * Get webhook test payload for email opened event
     * @return WebhookEmailReadPayload
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public WebhookEmailReadPayload getTestWebhookPayloadEmailRead() throws ApiException {
        ApiResponse<WebhookEmailReadPayload> localVarResp = getTestWebhookPayloadEmailReadWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * 
     * Get webhook test payload for email opened event
     * @return ApiResponse&lt;WebhookEmailReadPayload&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WebhookEmailReadPayload> getTestWebhookPayloadEmailReadWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getTestWebhookPayloadEmailReadValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<WebhookEmailReadPayload>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get webhook test payload for email opened event
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTestWebhookPayloadEmailReadAsync(final ApiCallback<WebhookEmailReadPayload> _callback) throws ApiException {

        okhttp3.Call localVarCall = getTestWebhookPayloadEmailReadValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<WebhookEmailReadPayload>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getTestWebhookPayloadForWebhook
     * @param webhookId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTestWebhookPayloadForWebhookCall(UUID webhookId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/webhooks/{webhookId}/example"
            .replaceAll("\\{" + "webhookId" + "\\}", localVarApiClient.escapeString(webhookId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTestWebhookPayloadForWebhookValidateBeforeCall(UUID webhookId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'webhookId' is set
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId' when calling getTestWebhookPayloadForWebhook(Async)");
        }
        

        okhttp3.Call localVarCall = getTestWebhookPayloadForWebhookCall(webhookId, _callback);
        return localVarCall;

    }

    /**
     * 
     * Get example payload for webhook
     * @param webhookId  (required)
     * @return AbstractWebhookPayload
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public AbstractWebhookPayload getTestWebhookPayloadForWebhook(UUID webhookId) throws ApiException {
        ApiResponse<AbstractWebhookPayload> localVarResp = getTestWebhookPayloadForWebhookWithHttpInfo(webhookId);
        return localVarResp.getData();
    }

    /**
     * 
     * Get example payload for webhook
     * @param webhookId  (required)
     * @return ApiResponse&lt;AbstractWebhookPayload&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AbstractWebhookPayload> getTestWebhookPayloadForWebhookWithHttpInfo(UUID webhookId) throws ApiException {
        okhttp3.Call localVarCall = getTestWebhookPayloadForWebhookValidateBeforeCall(webhookId, null);
        Type localVarReturnType = new TypeToken<AbstractWebhookPayload>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get example payload for webhook
     * @param webhookId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTestWebhookPayloadForWebhookAsync(UUID webhookId, final ApiCallback<AbstractWebhookPayload> _callback) throws ApiException {

        okhttp3.Call localVarCall = getTestWebhookPayloadForWebhookValidateBeforeCall(webhookId, _callback);
        Type localVarReturnType = new TypeToken<AbstractWebhookPayload>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getTestWebhookPayloadNewAttachment
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTestWebhookPayloadNewAttachmentCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/webhooks/test/new-attachment-payload";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTestWebhookPayloadNewAttachmentValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getTestWebhookPayloadNewAttachmentCall(_callback);
        return localVarCall;

    }

    /**
     * Get webhook test payload for new attachment event
     * 
     * @return WebhookNewAttachmentPayload
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public WebhookNewAttachmentPayload getTestWebhookPayloadNewAttachment() throws ApiException {
        ApiResponse<WebhookNewAttachmentPayload> localVarResp = getTestWebhookPayloadNewAttachmentWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Get webhook test payload for new attachment event
     * 
     * @return ApiResponse&lt;WebhookNewAttachmentPayload&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WebhookNewAttachmentPayload> getTestWebhookPayloadNewAttachmentWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getTestWebhookPayloadNewAttachmentValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<WebhookNewAttachmentPayload>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get webhook test payload for new attachment event (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTestWebhookPayloadNewAttachmentAsync(final ApiCallback<WebhookNewAttachmentPayload> _callback) throws ApiException {

        okhttp3.Call localVarCall = getTestWebhookPayloadNewAttachmentValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<WebhookNewAttachmentPayload>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getTestWebhookPayloadNewContact
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTestWebhookPayloadNewContactCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/webhooks/test/new-contact-payload";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTestWebhookPayloadNewContactValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getTestWebhookPayloadNewContactCall(_callback);
        return localVarCall;

    }

    /**
     * Get webhook test payload for new contact event
     * 
     * @return WebhookNewContactPayload
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public WebhookNewContactPayload getTestWebhookPayloadNewContact() throws ApiException {
        ApiResponse<WebhookNewContactPayload> localVarResp = getTestWebhookPayloadNewContactWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Get webhook test payload for new contact event
     * 
     * @return ApiResponse&lt;WebhookNewContactPayload&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WebhookNewContactPayload> getTestWebhookPayloadNewContactWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getTestWebhookPayloadNewContactValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<WebhookNewContactPayload>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get webhook test payload for new contact event (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTestWebhookPayloadNewContactAsync(final ApiCallback<WebhookNewContactPayload> _callback) throws ApiException {

        okhttp3.Call localVarCall = getTestWebhookPayloadNewContactValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<WebhookNewContactPayload>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getTestWebhookPayloadNewEmail
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTestWebhookPayloadNewEmailCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/webhooks/test/new-email-payload";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTestWebhookPayloadNewEmailValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getTestWebhookPayloadNewEmailCall(_callback);
        return localVarCall;

    }

    /**
     * Get webhook test payload for new email event
     * 
     * @return WebhookNewEmailPayload
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public WebhookNewEmailPayload getTestWebhookPayloadNewEmail() throws ApiException {
        ApiResponse<WebhookNewEmailPayload> localVarResp = getTestWebhookPayloadNewEmailWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Get webhook test payload for new email event
     * 
     * @return ApiResponse&lt;WebhookNewEmailPayload&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WebhookNewEmailPayload> getTestWebhookPayloadNewEmailWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getTestWebhookPayloadNewEmailValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<WebhookNewEmailPayload>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get webhook test payload for new email event (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTestWebhookPayloadNewEmailAsync(final ApiCallback<WebhookNewEmailPayload> _callback) throws ApiException {

        okhttp3.Call localVarCall = getTestWebhookPayloadNewEmailValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<WebhookNewEmailPayload>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getWebhook
     * @param webhookId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getWebhookCall(UUID webhookId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/webhooks/{webhookId}"
            .replaceAll("\\{" + "webhookId" + "\\}", localVarApiClient.escapeString(webhookId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getWebhookValidateBeforeCall(UUID webhookId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'webhookId' is set
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId' when calling getWebhook(Async)");
        }
        

        okhttp3.Call localVarCall = getWebhookCall(webhookId, _callback);
        return localVarCall;

    }

    /**
     * Get a webhook for an Inbox
     * 
     * @param webhookId  (required)
     * @return WebhookDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public WebhookDto getWebhook(UUID webhookId) throws ApiException {
        ApiResponse<WebhookDto> localVarResp = getWebhookWithHttpInfo(webhookId);
        return localVarResp.getData();
    }

    /**
     * Get a webhook for an Inbox
     * 
     * @param webhookId  (required)
     * @return ApiResponse&lt;WebhookDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WebhookDto> getWebhookWithHttpInfo(UUID webhookId) throws ApiException {
        okhttp3.Call localVarCall = getWebhookValidateBeforeCall(webhookId, null);
        Type localVarReturnType = new TypeToken<WebhookDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a webhook for an Inbox (asynchronously)
     * 
     * @param webhookId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getWebhookAsync(UUID webhookId, final ApiCallback<WebhookDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getWebhookValidateBeforeCall(webhookId, _callback);
        Type localVarReturnType = new TypeToken<WebhookDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getWebhookResult
     * @param webhookResultId Webhook Result ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getWebhookResultCall(UUID webhookResultId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/webhooks/results/{webhookResultId}"
            .replaceAll("\\{" + "webhookResultId" + "\\}", localVarApiClient.escapeString(webhookResultId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getWebhookResultValidateBeforeCall(UUID webhookResultId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'webhookResultId' is set
        if (webhookResultId == null) {
            throw new ApiException("Missing the required parameter 'webhookResultId' when calling getWebhookResult(Async)");
        }
        

        okhttp3.Call localVarCall = getWebhookResultCall(webhookResultId, _callback);
        return localVarCall;

    }

    /**
     * Get a webhook result for a webhook
     * 
     * @param webhookResultId Webhook Result ID (required)
     * @return WebhookResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public WebhookResultDto getWebhookResult(UUID webhookResultId) throws ApiException {
        ApiResponse<WebhookResultDto> localVarResp = getWebhookResultWithHttpInfo(webhookResultId);
        return localVarResp.getData();
    }

    /**
     * Get a webhook result for a webhook
     * 
     * @param webhookResultId Webhook Result ID (required)
     * @return ApiResponse&lt;WebhookResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WebhookResultDto> getWebhookResultWithHttpInfo(UUID webhookResultId) throws ApiException {
        okhttp3.Call localVarCall = getWebhookResultValidateBeforeCall(webhookResultId, null);
        Type localVarReturnType = new TypeToken<WebhookResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a webhook result for a webhook (asynchronously)
     * 
     * @param webhookResultId Webhook Result ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getWebhookResultAsync(UUID webhookResultId, final ApiCallback<WebhookResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getWebhookResultValidateBeforeCall(webhookResultId, _callback);
        Type localVarReturnType = new TypeToken<WebhookResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getWebhookResults
     * @param webhookId ID of webhook to get results for (required)
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param unseenOnly Filter for unseen exceptions only (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getWebhookResultsCall(UUID webhookId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, Boolean unseenOnly, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/webhooks/{webhookId}/results"
            .replaceAll("\\{" + "webhookId" + "\\}", localVarApiClient.escapeString(webhookId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (searchFilter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("searchFilter", searchFilter));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        if (unseenOnly != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unseenOnly", unseenOnly));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getWebhookResultsValidateBeforeCall(UUID webhookId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, Boolean unseenOnly, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'webhookId' is set
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId' when calling getWebhookResults(Async)");
        }
        

        okhttp3.Call localVarCall = getWebhookResultsCall(webhookId, page, size, sort, searchFilter, since, before, unseenOnly, _callback);
        return localVarCall;

    }

    /**
     * Get a webhook results for a webhook
     * 
     * @param webhookId ID of webhook to get results for (required)
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param unseenOnly Filter for unseen exceptions only (optional)
     * @return PageWebhookResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PageWebhookResult getWebhookResults(UUID webhookId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, Boolean unseenOnly) throws ApiException {
        ApiResponse<PageWebhookResult> localVarResp = getWebhookResultsWithHttpInfo(webhookId, page, size, sort, searchFilter, since, before, unseenOnly);
        return localVarResp.getData();
    }

    /**
     * Get a webhook results for a webhook
     * 
     * @param webhookId ID of webhook to get results for (required)
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param unseenOnly Filter for unseen exceptions only (optional)
     * @return ApiResponse&lt;PageWebhookResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageWebhookResult> getWebhookResultsWithHttpInfo(UUID webhookId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, Boolean unseenOnly) throws ApiException {
        okhttp3.Call localVarCall = getWebhookResultsValidateBeforeCall(webhookId, page, size, sort, searchFilter, since, before, unseenOnly, null);
        Type localVarReturnType = new TypeToken<PageWebhookResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a webhook results for a webhook (asynchronously)
     * 
     * @param webhookId ID of webhook to get results for (required)
     * @param page Optional page index in list pagination (optional, default to 0)
     * @param size Optional page size in list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param searchFilter Optional search filter (optional)
     * @param since Filter by created at after the given timestamp (optional)
     * @param before Filter by created at before the given timestamp (optional)
     * @param unseenOnly Filter for unseen exceptions only (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getWebhookResultsAsync(UUID webhookId, Integer page, Integer size, String sort, String searchFilter, OffsetDateTime since, OffsetDateTime before, Boolean unseenOnly, final ApiCallback<PageWebhookResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = getWebhookResultsValidateBeforeCall(webhookId, page, size, sort, searchFilter, since, before, unseenOnly, _callback);
        Type localVarReturnType = new TypeToken<PageWebhookResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getWebhookResultsUnseenErrorCount
     * @param inboxId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getWebhookResultsUnseenErrorCountCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/webhooks/results/unseen-count"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getWebhookResultsUnseenErrorCountValidateBeforeCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling getWebhookResultsUnseenErrorCount(Async)");
        }
        

        okhttp3.Call localVarCall = getWebhookResultsUnseenErrorCountCall(inboxId, _callback);
        return localVarCall;

    }

    /**
     * Get count of unseen webhook results with error status
     * 
     * @param inboxId  (required)
     * @return UnseenErrorCountDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public UnseenErrorCountDto getWebhookResultsUnseenErrorCount(UUID inboxId) throws ApiException {
        ApiResponse<UnseenErrorCountDto> localVarResp = getWebhookResultsUnseenErrorCountWithHttpInfo(inboxId);
        return localVarResp.getData();
    }

    /**
     * Get count of unseen webhook results with error status
     * 
     * @param inboxId  (required)
     * @return ApiResponse&lt;UnseenErrorCountDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UnseenErrorCountDto> getWebhookResultsUnseenErrorCountWithHttpInfo(UUID inboxId) throws ApiException {
        okhttp3.Call localVarCall = getWebhookResultsUnseenErrorCountValidateBeforeCall(inboxId, null);
        Type localVarReturnType = new TypeToken<UnseenErrorCountDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get count of unseen webhook results with error status (asynchronously)
     * 
     * @param inboxId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getWebhookResultsUnseenErrorCountAsync(UUID inboxId, final ApiCallback<UnseenErrorCountDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getWebhookResultsUnseenErrorCountValidateBeforeCall(inboxId, _callback);
        Type localVarReturnType = new TypeToken<UnseenErrorCountDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getWebhooks
     * @param inboxId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getWebhooksCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}/webhooks"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getWebhooksValidateBeforeCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling getWebhooks(Async)");
        }
        

        okhttp3.Call localVarCall = getWebhooksCall(inboxId, _callback);
        return localVarCall;

    }

    /**
     * Get all webhooks for an Inbox
     * 
     * @param inboxId  (required)
     * @return List&lt;WebhookDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public List<WebhookDto> getWebhooks(UUID inboxId) throws ApiException {
        ApiResponse<List<WebhookDto>> localVarResp = getWebhooksWithHttpInfo(inboxId);
        return localVarResp.getData();
    }

    /**
     * Get all webhooks for an Inbox
     * 
     * @param inboxId  (required)
     * @return ApiResponse&lt;List&lt;WebhookDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<WebhookDto>> getWebhooksWithHttpInfo(UUID inboxId) throws ApiException {
        okhttp3.Call localVarCall = getWebhooksValidateBeforeCall(inboxId, null);
        Type localVarReturnType = new TypeToken<List<WebhookDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get all webhooks for an Inbox (asynchronously)
     * 
     * @param inboxId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getWebhooksAsync(UUID inboxId, final ApiCallback<List<WebhookDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getWebhooksValidateBeforeCall(inboxId, _callback);
        Type localVarReturnType = new TypeToken<List<WebhookDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for redriveWebhookResult
     * @param webhookResultId Webhook Result ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call redriveWebhookResultCall(UUID webhookResultId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/webhooks/results/{webhookResultId}/redrive"
            .replaceAll("\\{" + "webhookResultId" + "\\}", localVarApiClient.escapeString(webhookResultId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call redriveWebhookResultValidateBeforeCall(UUID webhookResultId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'webhookResultId' is set
        if (webhookResultId == null) {
            throw new ApiException("Missing the required parameter 'webhookResultId' when calling redriveWebhookResult(Async)");
        }
        

        okhttp3.Call localVarCall = redriveWebhookResultCall(webhookResultId, _callback);
        return localVarCall;

    }

    /**
     * Get a webhook result and try to resend the original webhook payload
     * Allows you to resend a webhook payload that was already sent. Webhooks that fail are retried automatically for 24 hours and then put in a dead letter queue. You can retry results manually using this method.
     * @param webhookResultId Webhook Result ID (required)
     * @return WebhookRedriveResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public WebhookRedriveResult redriveWebhookResult(UUID webhookResultId) throws ApiException {
        ApiResponse<WebhookRedriveResult> localVarResp = redriveWebhookResultWithHttpInfo(webhookResultId);
        return localVarResp.getData();
    }

    /**
     * Get a webhook result and try to resend the original webhook payload
     * Allows you to resend a webhook payload that was already sent. Webhooks that fail are retried automatically for 24 hours and then put in a dead letter queue. You can retry results manually using this method.
     * @param webhookResultId Webhook Result ID (required)
     * @return ApiResponse&lt;WebhookRedriveResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WebhookRedriveResult> redriveWebhookResultWithHttpInfo(UUID webhookResultId) throws ApiException {
        okhttp3.Call localVarCall = redriveWebhookResultValidateBeforeCall(webhookResultId, null);
        Type localVarReturnType = new TypeToken<WebhookRedriveResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a webhook result and try to resend the original webhook payload (asynchronously)
     * Allows you to resend a webhook payload that was already sent. Webhooks that fail are retried automatically for 24 hours and then put in a dead letter queue. You can retry results manually using this method.
     * @param webhookResultId Webhook Result ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call redriveWebhookResultAsync(UUID webhookResultId, final ApiCallback<WebhookRedriveResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = redriveWebhookResultValidateBeforeCall(webhookResultId, _callback);
        Type localVarReturnType = new TypeToken<WebhookRedriveResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for sendTestData
     * @param webhookId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendTestDataCall(UUID webhookId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/webhooks/{webhookId}/test"
            .replaceAll("\\{" + "webhookId" + "\\}", localVarApiClient.escapeString(webhookId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call sendTestDataValidateBeforeCall(UUID webhookId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'webhookId' is set
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId' when calling sendTestData(Async)");
        }
        

        okhttp3.Call localVarCall = sendTestDataCall(webhookId, _callback);
        return localVarCall;

    }

    /**
     * Send webhook test data
     * 
     * @param webhookId  (required)
     * @return WebhookTestResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public WebhookTestResult sendTestData(UUID webhookId) throws ApiException {
        ApiResponse<WebhookTestResult> localVarResp = sendTestDataWithHttpInfo(webhookId);
        return localVarResp.getData();
    }

    /**
     * Send webhook test data
     * 
     * @param webhookId  (required)
     * @return ApiResponse&lt;WebhookTestResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WebhookTestResult> sendTestDataWithHttpInfo(UUID webhookId) throws ApiException {
        okhttp3.Call localVarCall = sendTestDataValidateBeforeCall(webhookId, null);
        Type localVarReturnType = new TypeToken<WebhookTestResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Send webhook test data (asynchronously)
     * 
     * @param webhookId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendTestDataAsync(UUID webhookId, final ApiCallback<WebhookTestResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = sendTestDataValidateBeforeCall(webhookId, _callback);
        Type localVarReturnType = new TypeToken<WebhookTestResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
