/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * Options for creating inbox rulesets. Inbox rulesets can be used to block, allow, filter, or forward emails when sending or receiving using the inbox.
 */
@ApiModel(description = "Options for creating inbox rulesets. Inbox rulesets can be used to block, allow, filter, or forward emails when sending or receiving using the inbox.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-03-07T02:51:59.203Z[GMT]")
public class CreateInboxRulesetOptions {
  /**
   * What type of emails actions to apply ruleset to. Either &#x60;SENDING_EMAILS&#x60; or &#x60;RECEIVING_EMAILS&#x60; will apply action and target to any sending or receiving of emails respectively.
   */
  @JsonAdapter(ScopeEnum.Adapter.class)
  public enum ScopeEnum {
    RECEIVING_EMAILS("RECEIVING_EMAILS"),
    
    SENDING_EMAILS("SENDING_EMAILS");

    private String value;

    ScopeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ScopeEnum fromValue(String value) {
      for (ScopeEnum b : ScopeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ScopeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ScopeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ScopeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ScopeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_SCOPE = "scope";
  @SerializedName(SERIALIZED_NAME_SCOPE)
  private ScopeEnum scope;

  /**
   * Action to be taken when the ruleset matches an email for the given scope. For example: &#x60;BLOCK&#x60; action with target &#x60;*&#x60; and scope &#x60;SENDING_EMAILS&#x60; blocks sending to all recipients. Note &#x60;ALLOW&#x60; takes precedent over &#x60;BLOCK&#x60;. &#x60;FILTER_REMOVE&#x60; is like block but will remove offending email addresses during a send or receive event instead of blocking the action.
   */
  @JsonAdapter(ActionEnum.Adapter.class)
  public enum ActionEnum {
    BLOCK("BLOCK"),
    
    ALLOW("ALLOW"),
    
    FILTER_REMOVE("FILTER_REMOVE");

    private String value;

    ActionEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ActionEnum fromValue(String value) {
      for (ActionEnum b : ActionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ActionEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ActionEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ActionEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ActionEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_ACTION = "action";
  @SerializedName(SERIALIZED_NAME_ACTION)
  private ActionEnum action;

  public static final String SERIALIZED_NAME_TARGET = "target";
  @SerializedName(SERIALIZED_NAME_TARGET)
  private String target;


  public CreateInboxRulesetOptions scope(ScopeEnum scope) {
    
    this.scope = scope;
    return this;
  }

   /**
   * What type of emails actions to apply ruleset to. Either &#x60;SENDING_EMAILS&#x60; or &#x60;RECEIVING_EMAILS&#x60; will apply action and target to any sending or receiving of emails respectively.
   * @return scope
  **/
  @ApiModelProperty(required = true, value = "What type of emails actions to apply ruleset to. Either `SENDING_EMAILS` or `RECEIVING_EMAILS` will apply action and target to any sending or receiving of emails respectively.")

  public ScopeEnum getScope() {
    return scope;
  }


  public void setScope(ScopeEnum scope) {
    this.scope = scope;
  }


  public CreateInboxRulesetOptions action(ActionEnum action) {
    
    this.action = action;
    return this;
  }

   /**
   * Action to be taken when the ruleset matches an email for the given scope. For example: &#x60;BLOCK&#x60; action with target &#x60;*&#x60; and scope &#x60;SENDING_EMAILS&#x60; blocks sending to all recipients. Note &#x60;ALLOW&#x60; takes precedent over &#x60;BLOCK&#x60;. &#x60;FILTER_REMOVE&#x60; is like block but will remove offending email addresses during a send or receive event instead of blocking the action.
   * @return action
  **/
  @ApiModelProperty(required = true, value = "Action to be taken when the ruleset matches an email for the given scope. For example: `BLOCK` action with target `*` and scope `SENDING_EMAILS` blocks sending to all recipients. Note `ALLOW` takes precedent over `BLOCK`. `FILTER_REMOVE` is like block but will remove offending email addresses during a send or receive event instead of blocking the action.")

  public ActionEnum getAction() {
    return action;
  }


  public void setAction(ActionEnum action) {
    this.action = action;
  }


  public CreateInboxRulesetOptions target(String target) {
    
    this.target = target;
    return this;
  }

   /**
   * Target to match emails with. Can be a wild-card type pattern or a valid email address. For instance &#x60;*@gmail.com&#x60; matches all gmail addresses while &#x60;test@gmail.com&#x60; matches one address exactly. The target is applied to every recipient field email address when &#x60;SENDING_EMAILS&#x60; is the scope and is applied to sender of email when &#x60;RECEIVING_EMAILS&#x60;.
   * @return target
  **/
  @ApiModelProperty(required = true, value = "Target to match emails with. Can be a wild-card type pattern or a valid email address. For instance `*@gmail.com` matches all gmail addresses while `test@gmail.com` matches one address exactly. The target is applied to every recipient field email address when `SENDING_EMAILS` is the scope and is applied to sender of email when `RECEIVING_EMAILS`.")

  public String getTarget() {
    return target;
  }


  public void setTarget(String target) {
    this.target = target;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateInboxRulesetOptions createInboxRulesetOptions = (CreateInboxRulesetOptions) o;
    return Objects.equals(this.scope, createInboxRulesetOptions.scope) &&
        Objects.equals(this.action, createInboxRulesetOptions.action) &&
        Objects.equals(this.target, createInboxRulesetOptions.target);
  }

  @Override
  public int hashCode() {
    return Objects.hash(scope, action, target);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateInboxRulesetOptions {\n");
    sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
    sb.append("    action: ").append(toIndentedString(action)).append("\n");
    sb.append("    target: ").append(toIndentedString(target)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

