/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Options for DNS query. 
 */
@ApiModel(description = "Options for DNS query. ")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-03-07T02:51:59.203Z[GMT]")
public class DNSLookupOptions {
  public static final String SERIALIZED_NAME_HOSTNAME = "hostname";
  @SerializedName(SERIALIZED_NAME_HOSTNAME)
  private String hostname;

  /**
   * Domain Name Server Record Types
   */
  @JsonAdapter(RecordTypesEnum.Adapter.class)
  public enum RecordTypesEnum {
    A("A"),
    
    NS("NS"),
    
    MD("MD"),
    
    MF("MF"),
    
    CNAME("CNAME"),
    
    SOA("SOA"),
    
    MB("MB"),
    
    MG("MG"),
    
    MR("MR"),
    
    NULL("NULL"),
    
    WKS("WKS"),
    
    PTR("PTR"),
    
    HINFO("HINFO"),
    
    MINFO("MINFO"),
    
    MX("MX"),
    
    TXT("TXT"),
    
    RP("RP"),
    
    AFSDB("AFSDB"),
    
    X25("X25"),
    
    ISDN("ISDN"),
    
    RT("RT"),
    
    NSAP("NSAP"),
    
    NSAP_PTR("NSAP_PTR"),
    
    SIG("SIG"),
    
    KEY("KEY"),
    
    PX("PX"),
    
    GPOS("GPOS"),
    
    AAAA("AAAA"),
    
    LOC("LOC"),
    
    NXT("NXT"),
    
    EID("EID"),
    
    NIMLOC("NIMLOC"),
    
    SRV("SRV"),
    
    ATMA("ATMA"),
    
    NAPTR("NAPTR"),
    
    KX("KX"),
    
    CERT("CERT"),
    
    A6("A6"),
    
    DNAME("DNAME"),
    
    SINK("SINK"),
    
    OPT("OPT"),
    
    APL("APL"),
    
    DS("DS"),
    
    SSHFP("SSHFP"),
    
    IPSECKEY("IPSECKEY"),
    
    RRSIG("RRSIG"),
    
    NSEC("NSEC"),
    
    DNSKEY("DNSKEY"),
    
    DHCID("DHCID"),
    
    NSEC3("NSEC3"),
    
    NSEC3PARAM("NSEC3PARAM"),
    
    TLSA("TLSA"),
    
    SMIMEA("SMIMEA"),
    
    HIP("HIP"),
    
    NINFO("NINFO"),
    
    RKEY("RKEY"),
    
    TALINK("TALINK"),
    
    CDS("CDS"),
    
    CDNSKEY("CDNSKEY"),
    
    OPENPGPKEY("OPENPGPKEY"),
    
    CSYNC("CSYNC"),
    
    ZONEMD("ZONEMD"),
    
    SVCB("SVCB"),
    
    HTTPS("HTTPS"),
    
    SPF("SPF"),
    
    UINFO("UINFO"),
    
    UID("UID"),
    
    GID("GID"),
    
    UNSPEC("UNSPEC"),
    
    NID("NID"),
    
    L32("L32"),
    
    L64("L64"),
    
    LP("LP"),
    
    EUI48("EUI48"),
    
    EUI64("EUI64"),
    
    TKEY("TKEY"),
    
    TSIG("TSIG"),
    
    IXFR("IXFR"),
    
    AXFR("AXFR"),
    
    MAILB("MAILB"),
    
    MAILA("MAILA"),
    
    ANY("ANY"),
    
    URI("URI"),
    
    CAA("CAA"),
    
    AVC("AVC"),
    
    DOA("DOA"),
    
    AMTRELAY("AMTRELAY"),
    
    TA("TA"),
    
    DLV("DLV");

    private String value;

    RecordTypesEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static RecordTypesEnum fromValue(String value) {
      for (RecordTypesEnum b : RecordTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<RecordTypesEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final RecordTypesEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public RecordTypesEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return RecordTypesEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_RECORD_TYPES = "recordTypes";
  @SerializedName(SERIALIZED_NAME_RECORD_TYPES)
  private List<RecordTypesEnum> recordTypes = new ArrayList<>();

  public static final String SERIALIZED_NAME_OMIT_FINAL_D_N_S_DOT = "omitFinalDNSDot";
  @SerializedName(SERIALIZED_NAME_OMIT_FINAL_D_N_S_DOT)
  private Boolean omitFinalDNSDot;


  public DNSLookupOptions hostname(String hostname) {
    
    this.hostname = hostname;
    return this;
  }

   /**
   * List of record types you wish to query such as MX, DNS, TXT, NS, A etc.
   * @return hostname
  **/
  @ApiModelProperty(required = true, value = "List of record types you wish to query such as MX, DNS, TXT, NS, A etc.")

  public String getHostname() {
    return hostname;
  }


  public void setHostname(String hostname) {
    this.hostname = hostname;
  }


  public DNSLookupOptions recordTypes(List<RecordTypesEnum> recordTypes) {
    
    this.recordTypes = recordTypes;
    return this;
  }

  public DNSLookupOptions addRecordTypesItem(RecordTypesEnum recordTypesItem) {
    this.recordTypes.add(recordTypesItem);
    return this;
  }

   /**
   * List of record types you wish to query such as MX, DNS, TXT, NS, A etc.
   * @return recordTypes
  **/
  @ApiModelProperty(required = true, value = "List of record types you wish to query such as MX, DNS, TXT, NS, A etc.")

  public List<RecordTypesEnum> getRecordTypes() {
    return recordTypes;
  }


  public void setRecordTypes(List<RecordTypesEnum> recordTypes) {
    this.recordTypes = recordTypes;
  }


  public DNSLookupOptions omitFinalDNSDot(Boolean omitFinalDNSDot) {
    
    this.omitFinalDNSDot = omitFinalDNSDot;
    return this;
  }

   /**
   * Optionally control whether to omit the final dot in full DNS name values.
   * @return omitFinalDNSDot
  **/
  @ApiModelProperty(required = true, value = "Optionally control whether to omit the final dot in full DNS name values.")

  public Boolean getOmitFinalDNSDot() {
    return omitFinalDNSDot;
  }


  public void setOmitFinalDNSDot(Boolean omitFinalDNSDot) {
    this.omitFinalDNSDot = omitFinalDNSDot;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DNSLookupOptions dnSLookupOptions = (DNSLookupOptions) o;
    return Objects.equals(this.hostname, dnSLookupOptions.hostname) &&
        Objects.equals(this.recordTypes, dnSLookupOptions.recordTypes) &&
        Objects.equals(this.omitFinalDNSDot, dnSLookupOptions.omitFinalDNSDot);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hostname, recordTypes, omitFinalDNSDot);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DNSLookupOptions {\n");
    sb.append("    hostname: ").append(toIndentedString(hostname)).append("\n");
    sb.append("    recordTypes: ").append(toIndentedString(recordTypes)).append("\n");
    sb.append("    omitFinalDNSDot: ").append(toIndentedString(omitFinalDNSDot)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

