/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mailslurp.models.DomainNameRecord;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * Domain plus verification records and status
 */
@ApiModel(description = "Domain plus verification records and status")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-03-07T02:51:59.203Z[GMT]")
public class DomainDto {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private UUID id;

  public static final String SERIALIZED_NAME_USER_ID = "userId";
  @SerializedName(SERIALIZED_NAME_USER_ID)
  private UUID userId;

  public static final String SERIALIZED_NAME_DOMAIN = "domain";
  @SerializedName(SERIALIZED_NAME_DOMAIN)
  private String domain;

  public static final String SERIALIZED_NAME_VERIFICATION_TOKEN = "verificationToken";
  @SerializedName(SERIALIZED_NAME_VERIFICATION_TOKEN)
  private String verificationToken;

  public static final String SERIALIZED_NAME_DKIM_TOKENS = "dkimTokens";
  @SerializedName(SERIALIZED_NAME_DKIM_TOKENS)
  private List<String> dkimTokens = new ArrayList<>();

  public static final String SERIALIZED_NAME_IS_VERIFIED = "isVerified";
  @SerializedName(SERIALIZED_NAME_IS_VERIFIED)
  private Boolean isVerified;

  public static final String SERIALIZED_NAME_DOMAIN_NAME_RECORDS = "domainNameRecords";
  @SerializedName(SERIALIZED_NAME_DOMAIN_NAME_RECORDS)
  private List<DomainNameRecord> domainNameRecords = new ArrayList<>();

  public static final String SERIALIZED_NAME_CATCH_ALL_INBOX_ID = "catchAllInboxId";
  @SerializedName(SERIALIZED_NAME_CATCH_ALL_INBOX_ID)
  private UUID catchAllInboxId;

  public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private OffsetDateTime createdAt;

  public static final String SERIALIZED_NAME_UPDATED_AT = "updatedAt";
  @SerializedName(SERIALIZED_NAME_UPDATED_AT)
  private OffsetDateTime updatedAt;

  /**
   * Type of domain. Dictates type of inbox that can be created with domain. HTTP means inboxes are processed using SES while SMTP inboxes use a custom SMTP mail server. SMTP does not support sending so use HTTP for sending emails.
   */
  @JsonAdapter(DomainTypeEnum.Adapter.class)
  public enum DomainTypeEnum {
    HTTP_INBOX("HTTP_INBOX"),
    
    SMTP_DOMAIN("SMTP_DOMAIN");

    private String value;

    DomainTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static DomainTypeEnum fromValue(String value) {
      for (DomainTypeEnum b : DomainTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<DomainTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DomainTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public DomainTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return DomainTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_DOMAIN_TYPE = "domainType";
  @SerializedName(SERIALIZED_NAME_DOMAIN_TYPE)
  private DomainTypeEnum domainType;


  public DomainDto id(UUID id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(required = true, value = "")

  public UUID getId() {
    return id;
  }


  public void setId(UUID id) {
    this.id = id;
  }


  public DomainDto userId(UUID userId) {
    
    this.userId = userId;
    return this;
  }

   /**
   * Get userId
   * @return userId
  **/
  @ApiModelProperty(required = true, value = "")

  public UUID getUserId() {
    return userId;
  }


  public void setUserId(UUID userId) {
    this.userId = userId;
  }


  public DomainDto domain(String domain) {
    
    this.domain = domain;
    return this;
  }

   /**
   * Custom domain name
   * @return domain
  **/
  @ApiModelProperty(required = true, value = "Custom domain name")

  public String getDomain() {
    return domain;
  }


  public void setDomain(String domain) {
    this.domain = domain;
  }


  public DomainDto verificationToken(String verificationToken) {
    
    this.verificationToken = verificationToken;
    return this;
  }

   /**
   * Verification tokens
   * @return verificationToken
  **/
  @ApiModelProperty(required = true, value = "Verification tokens")

  public String getVerificationToken() {
    return verificationToken;
  }


  public void setVerificationToken(String verificationToken) {
    this.verificationToken = verificationToken;
  }


  public DomainDto dkimTokens(List<String> dkimTokens) {
    
    this.dkimTokens = dkimTokens;
    return this;
  }

  public DomainDto addDkimTokensItem(String dkimTokensItem) {
    this.dkimTokens.add(dkimTokensItem);
    return this;
  }

   /**
   * Unique token DKIM tokens
   * @return dkimTokens
  **/
  @ApiModelProperty(required = true, value = "Unique token DKIM tokens")

  public List<String> getDkimTokens() {
    return dkimTokens;
  }


  public void setDkimTokens(List<String> dkimTokens) {
    this.dkimTokens = dkimTokens;
  }


  public DomainDto isVerified(Boolean isVerified) {
    
    this.isVerified = isVerified;
    return this;
  }

   /**
   * Whether domain has been verified or not. If the domain is not verified after 72 hours there is most likely an issue with the domains DNS records.
   * @return isVerified
  **/
  @ApiModelProperty(required = true, value = "Whether domain has been verified or not. If the domain is not verified after 72 hours there is most likely an issue with the domains DNS records.")

  public Boolean getIsVerified() {
    return isVerified;
  }


  public void setIsVerified(Boolean isVerified) {
    this.isVerified = isVerified;
  }


  public DomainDto domainNameRecords(List<DomainNameRecord> domainNameRecords) {
    
    this.domainNameRecords = domainNameRecords;
    return this;
  }

  public DomainDto addDomainNameRecordsItem(DomainNameRecord domainNameRecordsItem) {
    this.domainNameRecords.add(domainNameRecordsItem);
    return this;
  }

   /**
   * List of DNS domain name records (C, MX, TXT) etc that you must add to the DNS server associated with your domain provider.
   * @return domainNameRecords
  **/
  @ApiModelProperty(required = true, value = "List of DNS domain name records (C, MX, TXT) etc that you must add to the DNS server associated with your domain provider.")

  public List<DomainNameRecord> getDomainNameRecords() {
    return domainNameRecords;
  }


  public void setDomainNameRecords(List<DomainNameRecord> domainNameRecords) {
    this.domainNameRecords = domainNameRecords;
  }


  public DomainDto catchAllInboxId(UUID catchAllInboxId) {
    
    this.catchAllInboxId = catchAllInboxId;
    return this;
  }

   /**
   * The optional catch all inbox that will receive emails sent to the domain that cannot be matched.
   * @return catchAllInboxId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The optional catch all inbox that will receive emails sent to the domain that cannot be matched.")

  public UUID getCatchAllInboxId() {
    return catchAllInboxId;
  }


  public void setCatchAllInboxId(UUID catchAllInboxId) {
    this.catchAllInboxId = catchAllInboxId;
  }


  public DomainDto createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Get createdAt
   * @return createdAt
  **/
  @ApiModelProperty(required = true, value = "")

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public DomainDto updatedAt(OffsetDateTime updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @ApiModelProperty(required = true, value = "")

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }


  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }


  public DomainDto domainType(DomainTypeEnum domainType) {
    
    this.domainType = domainType;
    return this;
  }

   /**
   * Type of domain. Dictates type of inbox that can be created with domain. HTTP means inboxes are processed using SES while SMTP inboxes use a custom SMTP mail server. SMTP does not support sending so use HTTP for sending emails.
   * @return domainType
  **/
  @ApiModelProperty(required = true, value = "Type of domain. Dictates type of inbox that can be created with domain. HTTP means inboxes are processed using SES while SMTP inboxes use a custom SMTP mail server. SMTP does not support sending so use HTTP for sending emails.")

  public DomainTypeEnum getDomainType() {
    return domainType;
  }


  public void setDomainType(DomainTypeEnum domainType) {
    this.domainType = domainType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DomainDto domainDto = (DomainDto) o;
    return Objects.equals(this.id, domainDto.id) &&
        Objects.equals(this.userId, domainDto.userId) &&
        Objects.equals(this.domain, domainDto.domain) &&
        Objects.equals(this.verificationToken, domainDto.verificationToken) &&
        Objects.equals(this.dkimTokens, domainDto.dkimTokens) &&
        Objects.equals(this.isVerified, domainDto.isVerified) &&
        Objects.equals(this.domainNameRecords, domainDto.domainNameRecords) &&
        Objects.equals(this.catchAllInboxId, domainDto.catchAllInboxId) &&
        Objects.equals(this.createdAt, domainDto.createdAt) &&
        Objects.equals(this.updatedAt, domainDto.updatedAt) &&
        Objects.equals(this.domainType, domainDto.domainType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, userId, domain, verificationToken, dkimTokens, isVerified, domainNameRecords, catchAllInboxId, createdAt, updatedAt, domainType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DomainDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
    sb.append("    verificationToken: ").append(toIndentedString(verificationToken)).append("\n");
    sb.append("    dkimTokens: ").append(toIndentedString(dkimTokens)).append("\n");
    sb.append("    isVerified: ").append(toIndentedString(isVerified)).append("\n");
    sb.append("    domainNameRecords: ").append(toIndentedString(domainNameRecords)).append("\n");
    sb.append("    catchAllInboxId: ").append(toIndentedString(catchAllInboxId)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    domainType: ").append(toIndentedString(domainType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

