/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.UUID;

/**
 * Preview object for domain entity
 */
@ApiModel(description = "Preview object for domain entity")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-03-07T02:51:59.203Z[GMT]")
public class DomainPreview {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private UUID id;

  public static final String SERIALIZED_NAME_DOMAIN = "domain";
  @SerializedName(SERIALIZED_NAME_DOMAIN)
  private String domain;

  public static final String SERIALIZED_NAME_CATCH_ALL_INBOX_ID = "catchAllInboxId";
  @SerializedName(SERIALIZED_NAME_CATCH_ALL_INBOX_ID)
  private UUID catchAllInboxId;

  public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private OffsetDateTime createdAt;

  /**
   * Type of domain. Dictates type of inbox that can be created with domain. HTTP means inboxes are processed using SES while SMTP inboxes use a custom SMTP mail server. SMTP does not support sending so use HTTP for sending emails.
   */
  @JsonAdapter(DomainTypeEnum.Adapter.class)
  public enum DomainTypeEnum {
    HTTP_INBOX("HTTP_INBOX"),
    
    SMTP_DOMAIN("SMTP_DOMAIN");

    private String value;

    DomainTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static DomainTypeEnum fromValue(String value) {
      for (DomainTypeEnum b : DomainTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<DomainTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DomainTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public DomainTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return DomainTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_DOMAIN_TYPE = "domainType";
  @SerializedName(SERIALIZED_NAME_DOMAIN_TYPE)
  private DomainTypeEnum domainType;

  public static final String SERIALIZED_NAME_IS_VERIFIED = "isVerified";
  @SerializedName(SERIALIZED_NAME_IS_VERIFIED)
  private Boolean isVerified;


  public DomainPreview id(UUID id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(required = true, value = "")

  public UUID getId() {
    return id;
  }


  public void setId(UUID id) {
    this.id = id;
  }


  public DomainPreview domain(String domain) {
    
    this.domain = domain;
    return this;
  }

   /**
   * Get domain
   * @return domain
  **/
  @ApiModelProperty(required = true, value = "")

  public String getDomain() {
    return domain;
  }


  public void setDomain(String domain) {
    this.domain = domain;
  }


  public DomainPreview catchAllInboxId(UUID catchAllInboxId) {
    
    this.catchAllInboxId = catchAllInboxId;
    return this;
  }

   /**
   * Get catchAllInboxId
   * @return catchAllInboxId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public UUID getCatchAllInboxId() {
    return catchAllInboxId;
  }


  public void setCatchAllInboxId(UUID catchAllInboxId) {
    this.catchAllInboxId = catchAllInboxId;
  }


  public DomainPreview createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Get createdAt
   * @return createdAt
  **/
  @ApiModelProperty(required = true, value = "")

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public DomainPreview domainType(DomainTypeEnum domainType) {
    
    this.domainType = domainType;
    return this;
  }

   /**
   * Type of domain. Dictates type of inbox that can be created with domain. HTTP means inboxes are processed using SES while SMTP inboxes use a custom SMTP mail server. SMTP does not support sending so use HTTP for sending emails.
   * @return domainType
  **/
  @ApiModelProperty(required = true, value = "Type of domain. Dictates type of inbox that can be created with domain. HTTP means inboxes are processed using SES while SMTP inboxes use a custom SMTP mail server. SMTP does not support sending so use HTTP for sending emails.")

  public DomainTypeEnum getDomainType() {
    return domainType;
  }


  public void setDomainType(DomainTypeEnum domainType) {
    this.domainType = domainType;
  }


  public DomainPreview isVerified(Boolean isVerified) {
    
    this.isVerified = isVerified;
    return this;
  }

   /**
   * Get isVerified
   * @return isVerified
  **/
  @ApiModelProperty(required = true, value = "")

  public Boolean getIsVerified() {
    return isVerified;
  }


  public void setIsVerified(Boolean isVerified) {
    this.isVerified = isVerified;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DomainPreview domainPreview = (DomainPreview) o;
    return Objects.equals(this.id, domainPreview.id) &&
        Objects.equals(this.domain, domainPreview.domain) &&
        Objects.equals(this.catchAllInboxId, domainPreview.catchAllInboxId) &&
        Objects.equals(this.createdAt, domainPreview.createdAt) &&
        Objects.equals(this.domainType, domainPreview.domainType) &&
        Objects.equals(this.isVerified, domainPreview.isVerified);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, domain, catchAllInboxId, createdAt, domainType, isVerified);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DomainPreview {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
    sb.append("    catchAllInboxId: ").append(toIndentedString(catchAllInboxId)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    domainType: ").append(toIndentedString(domainType)).append("\n");
    sb.append("    isVerified: ").append(toIndentedString(isVerified)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

