/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * Content of attachment
 */
@ApiModel(description = "Content of attachment")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-03-07T02:51:59.203Z[GMT]")
public class DownloadAttachmentDto {
  public static final String SERIALIZED_NAME_BASE64_FILE_CONTENTS = "base64FileContents";
  @SerializedName(SERIALIZED_NAME_BASE64_FILE_CONTENTS)
  private String base64FileContents;

  public static final String SERIALIZED_NAME_CONTENT_TYPE = "contentType";
  @SerializedName(SERIALIZED_NAME_CONTENT_TYPE)
  private String contentType;

  public static final String SERIALIZED_NAME_SIZE_BYTES = "sizeBytes";
  @SerializedName(SERIALIZED_NAME_SIZE_BYTES)
  private Long sizeBytes;


  public DownloadAttachmentDto base64FileContents(String base64FileContents) {
    
    this.base64FileContents = base64FileContents;
    return this;
  }

   /**
   * Base64 encoded string of attachment bytes. Decode the base64 encoded string to get the raw contents. If the file has a content type such as &#x60;text/html&#x60; you can read the contents directly by converting it to string using &#x60;utf-8&#x60; encoding.
   * @return base64FileContents
  **/
  @ApiModelProperty(required = true, value = "Base64 encoded string of attachment bytes. Decode the base64 encoded string to get the raw contents. If the file has a content type such as `text/html` you can read the contents directly by converting it to string using `utf-8` encoding.")

  public String getBase64FileContents() {
    return base64FileContents;
  }


  public void setBase64FileContents(String base64FileContents) {
    this.base64FileContents = base64FileContents;
  }


  public DownloadAttachmentDto contentType(String contentType) {
    
    this.contentType = contentType;
    return this;
  }

   /**
   * Content type of attachment. Examples are &#x60;image/png&#x60;, &#x60;application/msword&#x60;, &#x60;text/csv&#x60; etc.
   * @return contentType
  **/
  @ApiModelProperty(required = true, value = "Content type of attachment. Examples are `image/png`, `application/msword`, `text/csv` etc.")

  public String getContentType() {
    return contentType;
  }


  public void setContentType(String contentType) {
    this.contentType = contentType;
  }


  public DownloadAttachmentDto sizeBytes(Long sizeBytes) {
    
    this.sizeBytes = sizeBytes;
    return this;
  }

   /**
   * Size in bytes of attachment content
   * @return sizeBytes
  **/
  @ApiModelProperty(required = true, value = "Size in bytes of attachment content")

  public Long getSizeBytes() {
    return sizeBytes;
  }


  public void setSizeBytes(Long sizeBytes) {
    this.sizeBytes = sizeBytes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DownloadAttachmentDto downloadAttachmentDto = (DownloadAttachmentDto) o;
    return Objects.equals(this.base64FileContents, downloadAttachmentDto.base64FileContents) &&
        Objects.equals(this.contentType, downloadAttachmentDto.contentType) &&
        Objects.equals(this.sizeBytes, downloadAttachmentDto.sizeBytes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(base64FileContents, contentType, sizeBytes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DownloadAttachmentDto {\n");
    sb.append("    base64FileContents: ").append(toIndentedString(base64FileContents)).append("\n");
    sb.append("    contentType: ").append(toIndentedString(contentType)).append("\n");
    sb.append("    sizeBytes: ").append(toIndentedString(sizeBytes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

