/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mailslurp.models.EmailAnalysis;
import com.mailslurp.models.EmailRecipients;
import com.mailslurp.models.Sender;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * Email entity (also known as EmailDto). When an SMTP email message is received by MailSlurp it is parsed. The body and attachments are written to disk and the fields such as to, from, subject etc are stored in a database. The &#x60;body&#x60; contains the email content. If you want the original SMTP message see the &#x60;getRawEmail&#x60; endpoints. The attachments can be fetched using the AttachmentController
 */
@ApiModel(description = "Email entity (also known as EmailDto). When an SMTP email message is received by MailSlurp it is parsed. The body and attachments are written to disk and the fields such as to, from, subject etc are stored in a database. The `body` contains the email content. If you want the original SMTP message see the `getRawEmail` endpoints. The attachments can be fetched using the AttachmentController")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-03-07T02:51:59.203Z[GMT]")
public class Email {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private UUID id;

  public static final String SERIALIZED_NAME_USER_ID = "userId";
  @SerializedName(SERIALIZED_NAME_USER_ID)
  private UUID userId;

  public static final String SERIALIZED_NAME_INBOX_ID = "inboxId";
  @SerializedName(SERIALIZED_NAME_INBOX_ID)
  private UUID inboxId;

  public static final String SERIALIZED_NAME_TO = "to";
  @SerializedName(SERIALIZED_NAME_TO)
  private List<String> to = new ArrayList<>();

  public static final String SERIALIZED_NAME_FROM = "from";
  @SerializedName(SERIALIZED_NAME_FROM)
  private String from;

  public static final String SERIALIZED_NAME_SENDER = "sender";
  @SerializedName(SERIALIZED_NAME_SENDER)
  private Sender sender;

  public static final String SERIALIZED_NAME_RECIPIENTS = "recipients";
  @SerializedName(SERIALIZED_NAME_RECIPIENTS)
  private EmailRecipients recipients;

  public static final String SERIALIZED_NAME_REPLY_TO = "replyTo";
  @SerializedName(SERIALIZED_NAME_REPLY_TO)
  private String replyTo;

  public static final String SERIALIZED_NAME_CC = "cc";
  @SerializedName(SERIALIZED_NAME_CC)
  private List<String> cc = null;

  public static final String SERIALIZED_NAME_BCC = "bcc";
  @SerializedName(SERIALIZED_NAME_BCC)
  private List<String> bcc = null;

  public static final String SERIALIZED_NAME_HEADERS = "headers";
  @SerializedName(SERIALIZED_NAME_HEADERS)
  private Map<String, String> headers = null;

  public static final String SERIALIZED_NAME_ATTACHMENTS = "attachments";
  @SerializedName(SERIALIZED_NAME_ATTACHMENTS)
  private List<String> attachments = null;

  public static final String SERIALIZED_NAME_SUBJECT = "subject";
  @SerializedName(SERIALIZED_NAME_SUBJECT)
  private String subject;

  public static final String SERIALIZED_NAME_BODY = "body";
  @SerializedName(SERIALIZED_NAME_BODY)
  private String body;

  public static final String SERIALIZED_NAME_BODY_EXCERPT = "bodyExcerpt";
  @SerializedName(SERIALIZED_NAME_BODY_EXCERPT)
  private String bodyExcerpt;

  public static final String SERIALIZED_NAME_BODY_M_D5_HASH = "bodyMD5Hash";
  @SerializedName(SERIALIZED_NAME_BODY_M_D5_HASH)
  private String bodyMD5Hash;

  public static final String SERIALIZED_NAME_IS_H_T_M_L = "isHTML";
  @SerializedName(SERIALIZED_NAME_IS_H_T_M_L)
  private Boolean isHTML;

  public static final String SERIALIZED_NAME_CHARSET = "charset";
  @SerializedName(SERIALIZED_NAME_CHARSET)
  private String charset;

  public static final String SERIALIZED_NAME_ANALYSIS = "analysis";
  @SerializedName(SERIALIZED_NAME_ANALYSIS)
  private EmailAnalysis analysis;

  public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private OffsetDateTime createdAt;

  public static final String SERIALIZED_NAME_UPDATED_AT = "updatedAt";
  @SerializedName(SERIALIZED_NAME_UPDATED_AT)
  private OffsetDateTime updatedAt;

  public static final String SERIALIZED_NAME_READ = "read";
  @SerializedName(SERIALIZED_NAME_READ)
  private Boolean read;

  public static final String SERIALIZED_NAME_TEAM_ACCESS = "teamAccess";
  @SerializedName(SERIALIZED_NAME_TEAM_ACCESS)
  private Boolean teamAccess;


  public Email id(UUID id) {
    
    this.id = id;
    return this;
  }

   /**
   * ID of the email entity
   * @return id
  **/
  @ApiModelProperty(required = true, value = "ID of the email entity")

  public UUID getId() {
    return id;
  }


  public void setId(UUID id) {
    this.id = id;
  }


  public Email userId(UUID userId) {
    
    this.userId = userId;
    return this;
  }

   /**
   * ID of user that email belongs to
   * @return userId
  **/
  @ApiModelProperty(required = true, value = "ID of user that email belongs to")

  public UUID getUserId() {
    return userId;
  }


  public void setUserId(UUID userId) {
    this.userId = userId;
  }


  public Email inboxId(UUID inboxId) {
    
    this.inboxId = inboxId;
    return this;
  }

   /**
   * ID of the inbox that received the email
   * @return inboxId
  **/
  @ApiModelProperty(required = true, value = "ID of the inbox that received the email")

  public UUID getInboxId() {
    return inboxId;
  }


  public void setInboxId(UUID inboxId) {
    this.inboxId = inboxId;
  }


  public Email to(List<String> to) {
    
    this.to = to;
    return this;
  }

  public Email addToItem(String toItem) {
    this.to.add(toItem);
    return this;
  }

   /**
   * List of &#x60;To&#x60; recipient email addresses that the email was addressed to. See recipients object for names.
   * @return to
  **/
  @ApiModelProperty(required = true, value = "List of `To` recipient email addresses that the email was addressed to. See recipients object for names.")

  public List<String> getTo() {
    return to;
  }


  public void setTo(List<String> to) {
    this.to = to;
  }


  public Email from(String from) {
    
    this.from = from;
    return this;
  }

   /**
   * Who the email was sent from. An email address - see fromName for the sender name.
   * @return from
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Who the email was sent from. An email address - see fromName for the sender name.")

  public String getFrom() {
    return from;
  }


  public void setFrom(String from) {
    this.from = from;
  }


  public Email sender(Sender sender) {
    
    this.sender = sender;
    return this;
  }

   /**
   * Get sender
   * @return sender
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Sender getSender() {
    return sender;
  }


  public void setSender(Sender sender) {
    this.sender = sender;
  }


  public Email recipients(EmailRecipients recipients) {
    
    this.recipients = recipients;
    return this;
  }

   /**
   * Get recipients
   * @return recipients
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public EmailRecipients getRecipients() {
    return recipients;
  }


  public void setRecipients(EmailRecipients recipients) {
    this.recipients = recipients;
  }


  public Email replyTo(String replyTo) {
    
    this.replyTo = replyTo;
    return this;
  }

   /**
   * The &#x60;replyTo&#x60; field on the received email message
   * @return replyTo
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The `replyTo` field on the received email message")

  public String getReplyTo() {
    return replyTo;
  }


  public void setReplyTo(String replyTo) {
    this.replyTo = replyTo;
  }


  public Email cc(List<String> cc) {
    
    this.cc = cc;
    return this;
  }

  public Email addCcItem(String ccItem) {
    if (this.cc == null) {
      this.cc = new ArrayList<>();
    }
    this.cc.add(ccItem);
    return this;
  }

   /**
   * List of &#x60;CC&#x60; recipients email addresses that the email was addressed to. See recipients object for names.
   * @return cc
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "List of `CC` recipients email addresses that the email was addressed to. See recipients object for names.")

  public List<String> getCc() {
    return cc;
  }


  public void setCc(List<String> cc) {
    this.cc = cc;
  }


  public Email bcc(List<String> bcc) {
    
    this.bcc = bcc;
    return this;
  }

  public Email addBccItem(String bccItem) {
    if (this.bcc == null) {
      this.bcc = new ArrayList<>();
    }
    this.bcc.add(bccItem);
    return this;
  }

   /**
   * List of &#x60;BCC&#x60; recipients email addresses that the email was addressed to. See recipients object for names.
   * @return bcc
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "List of `BCC` recipients email addresses that the email was addressed to. See recipients object for names.")

  public List<String> getBcc() {
    return bcc;
  }


  public void setBcc(List<String> bcc) {
    this.bcc = bcc;
  }


  public Email headers(Map<String, String> headers) {
    
    this.headers = headers;
    return this;
  }

  public Email putHeadersItem(String key, String headersItem) {
    if (this.headers == null) {
      this.headers = new HashMap<>();
    }
    this.headers.put(key, headersItem);
    return this;
  }

   /**
   * Collection of SMTP headers attached to email
   * @return headers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Collection of SMTP headers attached to email")

  public Map<String, String> getHeaders() {
    return headers;
  }


  public void setHeaders(Map<String, String> headers) {
    this.headers = headers;
  }


  public Email attachments(List<String> attachments) {
    
    this.attachments = attachments;
    return this;
  }

  public Email addAttachmentsItem(String attachmentsItem) {
    if (this.attachments == null) {
      this.attachments = new ArrayList<>();
    }
    this.attachments.add(attachmentsItem);
    return this;
  }

   /**
   * List of IDs of attachments found in the email. Use these IDs with the Inbox and Email Controllers to download attachments and attachment meta data such as filesize, name, extension.
   * @return attachments
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "List of IDs of attachments found in the email. Use these IDs with the Inbox and Email Controllers to download attachments and attachment meta data such as filesize, name, extension.")

  public List<String> getAttachments() {
    return attachments;
  }


  public void setAttachments(List<String> attachments) {
    this.attachments = attachments;
  }


  public Email subject(String subject) {
    
    this.subject = subject;
    return this;
  }

   /**
   * The subject line of the email message as specified by SMTP subject header
   * @return subject
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The subject line of the email message as specified by SMTP subject header")

  public String getSubject() {
    return subject;
  }


  public void setSubject(String subject) {
    this.subject = subject;
  }


  public Email body(String body) {
    
    this.body = body;
    return this;
  }

   /**
   * The body of the email message as text parsed from the SMTP message body (does not include attachments). Fetch the raw content to access the SMTP message and use the attachments property to access attachments. The body is stored separately to the email entity so the body is not returned in paginated results only in full single email or wait requests.
   * @return body
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The body of the email message as text parsed from the SMTP message body (does not include attachments). Fetch the raw content to access the SMTP message and use the attachments property to access attachments. The body is stored separately to the email entity so the body is not returned in paginated results only in full single email or wait requests.")

  public String getBody() {
    return body;
  }


  public void setBody(String body) {
    this.body = body;
  }


  public Email bodyExcerpt(String bodyExcerpt) {
    
    this.bodyExcerpt = bodyExcerpt;
    return this;
  }

   /**
   * An excerpt of the body of the email message for quick preview .
   * @return bodyExcerpt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "An excerpt of the body of the email message for quick preview .")

  public String getBodyExcerpt() {
    return bodyExcerpt;
  }


  public void setBodyExcerpt(String bodyExcerpt) {
    this.bodyExcerpt = bodyExcerpt;
  }


  public Email bodyMD5Hash(String bodyMD5Hash) {
    
    this.bodyMD5Hash = bodyMD5Hash;
    return this;
  }

   /**
   * A hash signature of the email message using MD5. Useful for comparing emails without fetching full body.
   * @return bodyMD5Hash
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A hash signature of the email message using MD5. Useful for comparing emails without fetching full body.")

  public String getBodyMD5Hash() {
    return bodyMD5Hash;
  }


  public void setBodyMD5Hash(String bodyMD5Hash) {
    this.bodyMD5Hash = bodyMD5Hash;
  }


  public Email isHTML(Boolean isHTML) {
    
    this.isHTML = isHTML;
    return this;
  }

   /**
   * Is the email body content type HTML?
   * @return isHTML
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Is the email body content type HTML?")

  public Boolean getIsHTML() {
    return isHTML;
  }


  public void setIsHTML(Boolean isHTML) {
    this.isHTML = isHTML;
  }


  public Email charset(String charset) {
    
    this.charset = charset;
    return this;
  }

   /**
   * Detected character set of the email body such as UTF-8
   * @return charset
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Detected character set of the email body such as UTF-8")

  public String getCharset() {
    return charset;
  }


  public void setCharset(String charset) {
    this.charset = charset;
  }


  public Email analysis(EmailAnalysis analysis) {
    
    this.analysis = analysis;
    return this;
  }

   /**
   * Get analysis
   * @return analysis
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public EmailAnalysis getAnalysis() {
    return analysis;
  }


  public void setAnalysis(EmailAnalysis analysis) {
    this.analysis = analysis;
  }


  public Email createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * When was the email received by MailSlurp
   * @return createdAt
  **/
  @ApiModelProperty(required = true, value = "When was the email received by MailSlurp")

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public Email updatedAt(OffsetDateTime updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * When was the email last updated
   * @return updatedAt
  **/
  @ApiModelProperty(required = true, value = "When was the email last updated")

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }


  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }


  public Email read(Boolean read) {
    
    this.read = read;
    return this;
  }

   /**
   * Read flag. Has the email ever been viewed in the dashboard or fetched via the API with a hydrated body? If so the email is marked as read. Paginated results do not affect read status. Read status is different to email opened event as it depends on your own account accessing the email. Email opened is determined by tracking pixels sent to other uses if enable during sending. You can listened for both email read and email opened events using webhooks.
   * @return read
  **/
  @ApiModelProperty(required = true, value = "Read flag. Has the email ever been viewed in the dashboard or fetched via the API with a hydrated body? If so the email is marked as read. Paginated results do not affect read status. Read status is different to email opened event as it depends on your own account accessing the email. Email opened is determined by tracking pixels sent to other uses if enable during sending. You can listened for both email read and email opened events using webhooks.")

  public Boolean getRead() {
    return read;
  }


  public void setRead(Boolean read) {
    this.read = read;
  }


  public Email teamAccess(Boolean teamAccess) {
    
    this.teamAccess = teamAccess;
    return this;
  }

   /**
   * Can the email be accessed by organization team members
   * @return teamAccess
  **/
  @ApiModelProperty(required = true, value = "Can the email be accessed by organization team members")

  public Boolean getTeamAccess() {
    return teamAccess;
  }


  public void setTeamAccess(Boolean teamAccess) {
    this.teamAccess = teamAccess;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Email email = (Email) o;
    return Objects.equals(this.id, email.id) &&
        Objects.equals(this.userId, email.userId) &&
        Objects.equals(this.inboxId, email.inboxId) &&
        Objects.equals(this.to, email.to) &&
        Objects.equals(this.from, email.from) &&
        Objects.equals(this.sender, email.sender) &&
        Objects.equals(this.recipients, email.recipients) &&
        Objects.equals(this.replyTo, email.replyTo) &&
        Objects.equals(this.cc, email.cc) &&
        Objects.equals(this.bcc, email.bcc) &&
        Objects.equals(this.headers, email.headers) &&
        Objects.equals(this.attachments, email.attachments) &&
        Objects.equals(this.subject, email.subject) &&
        Objects.equals(this.body, email.body) &&
        Objects.equals(this.bodyExcerpt, email.bodyExcerpt) &&
        Objects.equals(this.bodyMD5Hash, email.bodyMD5Hash) &&
        Objects.equals(this.isHTML, email.isHTML) &&
        Objects.equals(this.charset, email.charset) &&
        Objects.equals(this.analysis, email.analysis) &&
        Objects.equals(this.createdAt, email.createdAt) &&
        Objects.equals(this.updatedAt, email.updatedAt) &&
        Objects.equals(this.read, email.read) &&
        Objects.equals(this.teamAccess, email.teamAccess);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, userId, inboxId, to, from, sender, recipients, replyTo, cc, bcc, headers, attachments, subject, body, bodyExcerpt, bodyMD5Hash, isHTML, charset, analysis, createdAt, updatedAt, read, teamAccess);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Email {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    inboxId: ").append(toIndentedString(inboxId)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    sender: ").append(toIndentedString(sender)).append("\n");
    sb.append("    recipients: ").append(toIndentedString(recipients)).append("\n");
    sb.append("    replyTo: ").append(toIndentedString(replyTo)).append("\n");
    sb.append("    cc: ").append(toIndentedString(cc)).append("\n");
    sb.append("    bcc: ").append(toIndentedString(bcc)).append("\n");
    sb.append("    headers: ").append(toIndentedString(headers)).append("\n");
    sb.append("    attachments: ").append(toIndentedString(attachments)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("    bodyExcerpt: ").append(toIndentedString(bodyExcerpt)).append("\n");
    sb.append("    bodyMD5Hash: ").append(toIndentedString(bodyMD5Hash)).append("\n");
    sb.append("    isHTML: ").append(toIndentedString(isHTML)).append("\n");
    sb.append("    charset: ").append(toIndentedString(charset)).append("\n");
    sb.append("    analysis: ").append(toIndentedString(analysis)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    read: ").append(toIndentedString(read)).append("\n");
    sb.append("    teamAccess: ").append(toIndentedString(teamAccess)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

