/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Options for forwarding an email
 */
@ApiModel(description = "Options for forwarding an email")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-03-07T02:51:59.203Z[GMT]")
public class ForwardEmailOptions {
  public static final String SERIALIZED_NAME_TO = "to";
  @SerializedName(SERIALIZED_NAME_TO)
  private List<String> to = new ArrayList<>();

  public static final String SERIALIZED_NAME_SUBJECT = "subject";
  @SerializedName(SERIALIZED_NAME_SUBJECT)
  private String subject;

  public static final String SERIALIZED_NAME_CC = "cc";
  @SerializedName(SERIALIZED_NAME_CC)
  private List<String> cc = null;

  public static final String SERIALIZED_NAME_BCC = "bcc";
  @SerializedName(SERIALIZED_NAME_BCC)
  private List<String> bcc = null;

  public static final String SERIALIZED_NAME_FROM = "from";
  @SerializedName(SERIALIZED_NAME_FROM)
  private String from;

  public static final String SERIALIZED_NAME_USE_INBOX_NAME = "useInboxName";
  @SerializedName(SERIALIZED_NAME_USE_INBOX_NAME)
  private Boolean useInboxName;


  public ForwardEmailOptions to(List<String> to) {
    
    this.to = to;
    return this;
  }

  public ForwardEmailOptions addToItem(String toItem) {
    this.to.add(toItem);
    return this;
  }

   /**
   * To recipients for forwarded email
   * @return to
  **/
  @ApiModelProperty(required = true, value = "To recipients for forwarded email")

  public List<String> getTo() {
    return to;
  }


  public void setTo(List<String> to) {
    this.to = to;
  }


  public ForwardEmailOptions subject(String subject) {
    
    this.subject = subject;
    return this;
  }

   /**
   * Subject for forwarded email
   * @return subject
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Subject for forwarded email")

  public String getSubject() {
    return subject;
  }


  public void setSubject(String subject) {
    this.subject = subject;
  }


  public ForwardEmailOptions cc(List<String> cc) {
    
    this.cc = cc;
    return this;
  }

  public ForwardEmailOptions addCcItem(String ccItem) {
    if (this.cc == null) {
      this.cc = new ArrayList<>();
    }
    this.cc.add(ccItem);
    return this;
  }

   /**
   * Optional cc recipients
   * @return cc
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optional cc recipients")

  public List<String> getCc() {
    return cc;
  }


  public void setCc(List<String> cc) {
    this.cc = cc;
  }


  public ForwardEmailOptions bcc(List<String> bcc) {
    
    this.bcc = bcc;
    return this;
  }

  public ForwardEmailOptions addBccItem(String bccItem) {
    if (this.bcc == null) {
      this.bcc = new ArrayList<>();
    }
    this.bcc.add(bccItem);
    return this;
  }

   /**
   * Optional bcc recipients
   * @return bcc
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optional bcc recipients")

  public List<String> getBcc() {
    return bcc;
  }


  public void setBcc(List<String> bcc) {
    this.bcc = bcc;
  }


  public ForwardEmailOptions from(String from) {
    
    this.from = from;
    return this;
  }

   /**
   * Optional from override
   * @return from
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optional from override")

  public String getFrom() {
    return from;
  }


  public void setFrom(String from) {
    this.from = from;
  }


  public ForwardEmailOptions useInboxName(Boolean useInboxName) {
    
    this.useInboxName = useInboxName;
    return this;
  }

   /**
   * Optionally use inbox name as display name for sender email address
   * @return useInboxName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optionally use inbox name as display name for sender email address")

  public Boolean getUseInboxName() {
    return useInboxName;
  }


  public void setUseInboxName(Boolean useInboxName) {
    this.useInboxName = useInboxName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ForwardEmailOptions forwardEmailOptions = (ForwardEmailOptions) o;
    return Objects.equals(this.to, forwardEmailOptions.to) &&
        Objects.equals(this.subject, forwardEmailOptions.subject) &&
        Objects.equals(this.cc, forwardEmailOptions.cc) &&
        Objects.equals(this.bcc, forwardEmailOptions.bcc) &&
        Objects.equals(this.from, forwardEmailOptions.from) &&
        Objects.equals(this.useInboxName, forwardEmailOptions.useInboxName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(to, subject, cc, bcc, from, useInboxName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ForwardEmailOptions {\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    cc: ").append(toIndentedString(cc)).append("\n");
    sb.append("    bcc: ").append(toIndentedString(bcc)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    useInboxName: ").append(toIndentedString(useInboxName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

