/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * ImapFlagOperationOptions
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-03-07T02:51:59.203Z[GMT]")
public class ImapFlagOperationOptions {
  /**
   * Gets or Sets flagOperation
   */
  @JsonAdapter(FlagOperationEnum.Adapter.class)
  public enum FlagOperationEnum {
    SET_FLAGS("SET_FLAGS"),
    
    ADD_FLAGS("ADD_FLAGS"),
    
    REMOVE_FLAGS("REMOVE_FLAGS");

    private String value;

    FlagOperationEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static FlagOperationEnum fromValue(String value) {
      for (FlagOperationEnum b : FlagOperationEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<FlagOperationEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final FlagOperationEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public FlagOperationEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return FlagOperationEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_FLAG_OPERATION = "flagOperation";
  @SerializedName(SERIALIZED_NAME_FLAG_OPERATION)
  private FlagOperationEnum flagOperation;

  public static final String SERIALIZED_NAME_FLAGS = "flags";
  @SerializedName(SERIALIZED_NAME_FLAGS)
  private List<String> flags = new ArrayList<>();


  public ImapFlagOperationOptions flagOperation(FlagOperationEnum flagOperation) {
    
    this.flagOperation = flagOperation;
    return this;
  }

   /**
   * Get flagOperation
   * @return flagOperation
  **/
  @ApiModelProperty(required = true, value = "")

  public FlagOperationEnum getFlagOperation() {
    return flagOperation;
  }


  public void setFlagOperation(FlagOperationEnum flagOperation) {
    this.flagOperation = flagOperation;
  }


  public ImapFlagOperationOptions flags(List<String> flags) {
    
    this.flags = flags;
    return this;
  }

  public ImapFlagOperationOptions addFlagsItem(String flagsItem) {
    this.flags.add(flagsItem);
    return this;
  }

   /**
   * Get flags
   * @return flags
  **/
  @ApiModelProperty(required = true, value = "")

  public List<String> getFlags() {
    return flags;
  }


  public void setFlags(List<String> flags) {
    this.flags = flags;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ImapFlagOperationOptions imapFlagOperationOptions = (ImapFlagOperationOptions) o;
    return Objects.equals(this.flagOperation, imapFlagOperationOptions.flagOperation) &&
        Objects.equals(this.flags, imapFlagOperationOptions.flags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(flagOperation, flags);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ImapFlagOperationOptions {\n");
    sb.append("    flagOperation: ").append(toIndentedString(flagOperation)).append("\n");
    sb.append("    flags: ").append(toIndentedString(flags)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

