/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.UUID;

/**
 * Representation a user&#39;s account
 */
@ApiModel(description = "Representation a user's account")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-03-07T02:51:59.203Z[GMT]")
public class UserDto {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private UUID id;

  public static final String SERIALIZED_NAME_API_KEY = "apiKey";
  @SerializedName(SERIALIZED_NAME_API_KEY)
  private String apiKey;

  public static final String SERIALIZED_NAME_EMAIL_ADDRESS = "emailAddress";
  @SerializedName(SERIALIZED_NAME_EMAIL_ADDRESS)
  private String emailAddress;

  public static final String SERIALIZED_NAME_EMAIL_ADDRESS_MD5 = "emailAddressMd5";
  @SerializedName(SERIALIZED_NAME_EMAIL_ADDRESS_MD5)
  private String emailAddressMd5;

  public static final String SERIALIZED_NAME_CREATED = "created";
  @SerializedName(SERIALIZED_NAME_CREATED)
  private OffsetDateTime created;

  /**
   * Gets or Sets userType
   */
  @JsonAdapter(UserTypeEnum.Adapter.class)
  public enum UserTypeEnum {
    SOLO("SOLO"),
    
    CHILD_SOLO("CHILD_SOLO"),
    
    CHILD_TEAM("CHILD_TEAM");

    private String value;

    UserTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static UserTypeEnum fromValue(String value) {
      for (UserTypeEnum b : UserTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<UserTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final UserTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public UserTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return UserTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_USER_TYPE = "userType";
  @SerializedName(SERIALIZED_NAME_USER_TYPE)
  private UserTypeEnum userType;

  public static final String SERIALIZED_NAME_ORGANIZATION = "organization";
  @SerializedName(SERIALIZED_NAME_ORGANIZATION)
  private UUID organization;

  /**
   * Has user accepted an organization invite
   */
  @JsonAdapter(VerifiedEnum.Adapter.class)
  public enum VerifiedEnum {
    VERIFIED("VERIFIED"),
    
    PENDING("PENDING");

    private String value;

    VerifiedEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static VerifiedEnum fromValue(String value) {
      for (VerifiedEnum b : VerifiedEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<VerifiedEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final VerifiedEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public VerifiedEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return VerifiedEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_VERIFIED = "verified";
  @SerializedName(SERIALIZED_NAME_VERIFIED)
  private VerifiedEnum verified;

  public static final String SERIALIZED_NAME_HAS_PASSWORD = "hasPassword";
  @SerializedName(SERIALIZED_NAME_HAS_PASSWORD)
  private Boolean hasPassword;

  public static final String SERIALIZED_NAME_IS_FROZEN = "isFrozen";
  @SerializedName(SERIALIZED_NAME_IS_FROZEN)
  private Boolean isFrozen;

  public static final String SERIALIZED_NAME_ADD_NEW_CONTACTS = "addNewContacts";
  @SerializedName(SERIALIZED_NAME_ADD_NEW_CONTACTS)
  private Boolean addNewContacts;

  public static final String SERIALIZED_NAME_SSO_PROVIDER = "ssoProvider";
  @SerializedName(SERIALIZED_NAME_SSO_PROVIDER)
  private String ssoProvider;

  public static final String SERIALIZED_NAME_CUSTOMER_ID = "customerId";
  @SerializedName(SERIALIZED_NAME_CUSTOMER_ID)
  private String customerId;

  public static final String SERIALIZED_NAME_HAS_ONBOARDED = "hasOnboarded";
  @SerializedName(SERIALIZED_NAME_HAS_ONBOARDED)
  private Boolean hasOnboarded;

  public static final String SERIALIZED_NAME_IMAP_USERNAME = "imapUsername";
  @SerializedName(SERIALIZED_NAME_IMAP_USERNAME)
  private String imapUsername;

  public static final String SERIALIZED_NAME_IMAP_PASSWORD = "imapPassword";
  @SerializedName(SERIALIZED_NAME_IMAP_PASSWORD)
  private String imapPassword;

  public static final String SERIALIZED_NAME_SMTP_USERNAME = "smtpUsername";
  @SerializedName(SERIALIZED_NAME_SMTP_USERNAME)
  private String smtpUsername;

  public static final String SERIALIZED_NAME_SMTP_PASSWORD = "smtpPassword";
  @SerializedName(SERIALIZED_NAME_SMTP_PASSWORD)
  private String smtpPassword;


  public UserDto id(UUID id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(required = true, value = "")

  public UUID getId() {
    return id;
  }


  public void setId(UUID id) {
    this.id = id;
  }


  public UserDto apiKey(String apiKey) {
    
    this.apiKey = apiKey;
    return this;
  }

   /**
   * Get apiKey
   * @return apiKey
  **/
  @ApiModelProperty(required = true, value = "")

  public String getApiKey() {
    return apiKey;
  }


  public void setApiKey(String apiKey) {
    this.apiKey = apiKey;
  }


  public UserDto emailAddress(String emailAddress) {
    
    this.emailAddress = emailAddress;
    return this;
  }

   /**
   * Get emailAddress
   * @return emailAddress
  **/
  @ApiModelProperty(required = true, value = "")

  public String getEmailAddress() {
    return emailAddress;
  }


  public void setEmailAddress(String emailAddress) {
    this.emailAddress = emailAddress;
  }


  public UserDto emailAddressMd5(String emailAddressMd5) {
    
    this.emailAddressMd5 = emailAddressMd5;
    return this;
  }

   /**
   * Get emailAddressMd5
   * @return emailAddressMd5
  **/
  @ApiModelProperty(required = true, value = "")

  public String getEmailAddressMd5() {
    return emailAddressMd5;
  }


  public void setEmailAddressMd5(String emailAddressMd5) {
    this.emailAddressMd5 = emailAddressMd5;
  }


  public UserDto created(OffsetDateTime created) {
    
    this.created = created;
    return this;
  }

   /**
   * Get created
   * @return created
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public OffsetDateTime getCreated() {
    return created;
  }


  public void setCreated(OffsetDateTime created) {
    this.created = created;
  }


  public UserDto userType(UserTypeEnum userType) {
    
    this.userType = userType;
    return this;
  }

   /**
   * Get userType
   * @return userType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public UserTypeEnum getUserType() {
    return userType;
  }


  public void setUserType(UserTypeEnum userType) {
    this.userType = userType;
  }


  public UserDto organization(UUID organization) {
    
    this.organization = organization;
    return this;
  }

   /**
   * Does user belong to an organization
   * @return organization
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Does user belong to an organization")

  public UUID getOrganization() {
    return organization;
  }


  public void setOrganization(UUID organization) {
    this.organization = organization;
  }


  public UserDto verified(VerifiedEnum verified) {
    
    this.verified = verified;
    return this;
  }

   /**
   * Has user accepted an organization invite
   * @return verified
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Has user accepted an organization invite")

  public VerifiedEnum getVerified() {
    return verified;
  }


  public void setVerified(VerifiedEnum verified) {
    this.verified = verified;
  }


  public UserDto hasPassword(Boolean hasPassword) {
    
    this.hasPassword = hasPassword;
    return this;
  }

   /**
   * Get hasPassword
   * @return hasPassword
  **/
  @ApiModelProperty(required = true, value = "")

  public Boolean getHasPassword() {
    return hasPassword;
  }


  public void setHasPassword(Boolean hasPassword) {
    this.hasPassword = hasPassword;
  }


  public UserDto isFrozen(Boolean isFrozen) {
    
    this.isFrozen = isFrozen;
    return this;
  }

   /**
   * Get isFrozen
   * @return isFrozen
  **/
  @ApiModelProperty(required = true, value = "")

  public Boolean getIsFrozen() {
    return isFrozen;
  }


  public void setIsFrozen(Boolean isFrozen) {
    this.isFrozen = isFrozen;
  }


  public UserDto addNewContacts(Boolean addNewContacts) {
    
    this.addNewContacts = addNewContacts;
    return this;
  }

   /**
   * Get addNewContacts
   * @return addNewContacts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Boolean getAddNewContacts() {
    return addNewContacts;
  }


  public void setAddNewContacts(Boolean addNewContacts) {
    this.addNewContacts = addNewContacts;
  }


  public UserDto ssoProvider(String ssoProvider) {
    
    this.ssoProvider = ssoProvider;
    return this;
  }

   /**
   * Get ssoProvider
   * @return ssoProvider
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getSsoProvider() {
    return ssoProvider;
  }


  public void setSsoProvider(String ssoProvider) {
    this.ssoProvider = ssoProvider;
  }


  public UserDto customerId(String customerId) {
    
    this.customerId = customerId;
    return this;
  }

   /**
   * Get customerId
   * @return customerId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getCustomerId() {
    return customerId;
  }


  public void setCustomerId(String customerId) {
    this.customerId = customerId;
  }


  public UserDto hasOnboarded(Boolean hasOnboarded) {
    
    this.hasOnboarded = hasOnboarded;
    return this;
  }

   /**
   * Get hasOnboarded
   * @return hasOnboarded
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Boolean getHasOnboarded() {
    return hasOnboarded;
  }


  public void setHasOnboarded(Boolean hasOnboarded) {
    this.hasOnboarded = hasOnboarded;
  }


  public UserDto imapUsername(String imapUsername) {
    
    this.imapUsername = imapUsername;
    return this;
  }

   /**
   * Get imapUsername
   * @return imapUsername
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getImapUsername() {
    return imapUsername;
  }


  public void setImapUsername(String imapUsername) {
    this.imapUsername = imapUsername;
  }


  public UserDto imapPassword(String imapPassword) {
    
    this.imapPassword = imapPassword;
    return this;
  }

   /**
   * Get imapPassword
   * @return imapPassword
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getImapPassword() {
    return imapPassword;
  }


  public void setImapPassword(String imapPassword) {
    this.imapPassword = imapPassword;
  }


  public UserDto smtpUsername(String smtpUsername) {
    
    this.smtpUsername = smtpUsername;
    return this;
  }

   /**
   * Get smtpUsername
   * @return smtpUsername
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getSmtpUsername() {
    return smtpUsername;
  }


  public void setSmtpUsername(String smtpUsername) {
    this.smtpUsername = smtpUsername;
  }


  public UserDto smtpPassword(String smtpPassword) {
    
    this.smtpPassword = smtpPassword;
    return this;
  }

   /**
   * Get smtpPassword
   * @return smtpPassword
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getSmtpPassword() {
    return smtpPassword;
  }


  public void setSmtpPassword(String smtpPassword) {
    this.smtpPassword = smtpPassword;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserDto userDto = (UserDto) o;
    return Objects.equals(this.id, userDto.id) &&
        Objects.equals(this.apiKey, userDto.apiKey) &&
        Objects.equals(this.emailAddress, userDto.emailAddress) &&
        Objects.equals(this.emailAddressMd5, userDto.emailAddressMd5) &&
        Objects.equals(this.created, userDto.created) &&
        Objects.equals(this.userType, userDto.userType) &&
        Objects.equals(this.organization, userDto.organization) &&
        Objects.equals(this.verified, userDto.verified) &&
        Objects.equals(this.hasPassword, userDto.hasPassword) &&
        Objects.equals(this.isFrozen, userDto.isFrozen) &&
        Objects.equals(this.addNewContacts, userDto.addNewContacts) &&
        Objects.equals(this.ssoProvider, userDto.ssoProvider) &&
        Objects.equals(this.customerId, userDto.customerId) &&
        Objects.equals(this.hasOnboarded, userDto.hasOnboarded) &&
        Objects.equals(this.imapUsername, userDto.imapUsername) &&
        Objects.equals(this.imapPassword, userDto.imapPassword) &&
        Objects.equals(this.smtpUsername, userDto.smtpUsername) &&
        Objects.equals(this.smtpPassword, userDto.smtpPassword);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, apiKey, emailAddress, emailAddressMd5, created, userType, organization, verified, hasPassword, isFrozen, addNewContacts, ssoProvider, customerId, hasOnboarded, imapUsername, imapPassword, smtpUsername, smtpPassword);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    apiKey: ").append(toIndentedString(apiKey)).append("\n");
    sb.append("    emailAddress: ").append(toIndentedString(emailAddress)).append("\n");
    sb.append("    emailAddressMd5: ").append(toIndentedString(emailAddressMd5)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    userType: ").append(toIndentedString(userType)).append("\n");
    sb.append("    organization: ").append(toIndentedString(organization)).append("\n");
    sb.append("    verified: ").append(toIndentedString(verified)).append("\n");
    sb.append("    hasPassword: ").append(toIndentedString(hasPassword)).append("\n");
    sb.append("    isFrozen: ").append(toIndentedString(isFrozen)).append("\n");
    sb.append("    addNewContacts: ").append(toIndentedString(addNewContacts)).append("\n");
    sb.append("    ssoProvider: ").append(toIndentedString(ssoProvider)).append("\n");
    sb.append("    customerId: ").append(toIndentedString(customerId)).append("\n");
    sb.append("    hasOnboarded: ").append(toIndentedString(hasOnboarded)).append("\n");
    sb.append("    imapUsername: ").append(toIndentedString(imapUsername)).append("\n");
    sb.append("    imapPassword: ").append(toIndentedString(imapPassword)).append("\n");
    sb.append("    smtpUsername: ").append(toIndentedString(smtpUsername)).append("\n");
    sb.append("    smtpPassword: ").append(toIndentedString(smtpPassword)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

