/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mailslurp.models.AttachmentMetaData;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * NEW_EMAIL webhook payload. Sent to your webhook url endpoint via HTTP POST when an email is received by the inbox that your webhook is attached to. Use the email ID to fetch the full email body or attachments.
 */
@ApiModel(description = "NEW_EMAIL webhook payload. Sent to your webhook url endpoint via HTTP POST when an email is received by the inbox that your webhook is attached to. Use the email ID to fetch the full email body or attachments.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-03-07T02:51:59.203Z[GMT]")
public class WebhookNewEmailPayload {
  public static final String SERIALIZED_NAME_MESSAGE_ID = "messageId";
  @SerializedName(SERIALIZED_NAME_MESSAGE_ID)
  private String messageId;

  public static final String SERIALIZED_NAME_WEBHOOK_ID = "webhookId";
  @SerializedName(SERIALIZED_NAME_WEBHOOK_ID)
  private UUID webhookId;

  /**
   * Name of the event type webhook is being triggered for.
   */
  @JsonAdapter(EventNameEnum.Adapter.class)
  public enum EventNameEnum {
    EMAIL_RECEIVED("EMAIL_RECEIVED"),
    
    NEW_EMAIL("NEW_EMAIL"),
    
    NEW_CONTACT("NEW_CONTACT"),
    
    NEW_ATTACHMENT("NEW_ATTACHMENT"),
    
    EMAIL_OPENED("EMAIL_OPENED"),
    
    EMAIL_READ("EMAIL_READ");

    private String value;

    EventNameEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static EventNameEnum fromValue(String value) {
      for (EventNameEnum b : EventNameEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<EventNameEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final EventNameEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public EventNameEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return EventNameEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_EVENT_NAME = "eventName";
  @SerializedName(SERIALIZED_NAME_EVENT_NAME)
  private EventNameEnum eventName;

  public static final String SERIALIZED_NAME_WEBHOOK_NAME = "webhookName";
  @SerializedName(SERIALIZED_NAME_WEBHOOK_NAME)
  private String webhookName;

  public static final String SERIALIZED_NAME_INBOX_ID = "inboxId";
  @SerializedName(SERIALIZED_NAME_INBOX_ID)
  private UUID inboxId;

  public static final String SERIALIZED_NAME_EMAIL_ID = "emailId";
  @SerializedName(SERIALIZED_NAME_EMAIL_ID)
  private UUID emailId;

  public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private OffsetDateTime createdAt;

  public static final String SERIALIZED_NAME_TO = "to";
  @SerializedName(SERIALIZED_NAME_TO)
  private List<String> to = new ArrayList<>();

  public static final String SERIALIZED_NAME_FROM = "from";
  @SerializedName(SERIALIZED_NAME_FROM)
  private String from;

  public static final String SERIALIZED_NAME_CC = "cc";
  @SerializedName(SERIALIZED_NAME_CC)
  private List<String> cc = new ArrayList<>();

  public static final String SERIALIZED_NAME_BCC = "bcc";
  @SerializedName(SERIALIZED_NAME_BCC)
  private List<String> bcc = new ArrayList<>();

  public static final String SERIALIZED_NAME_SUBJECT = "subject";
  @SerializedName(SERIALIZED_NAME_SUBJECT)
  private String subject;

  public static final String SERIALIZED_NAME_ATTACHMENT_META_DATAS = "attachmentMetaDatas";
  @SerializedName(SERIALIZED_NAME_ATTACHMENT_META_DATAS)
  private List<AttachmentMetaData> attachmentMetaDatas = new ArrayList<>();


  public WebhookNewEmailPayload messageId(String messageId) {
    
    this.messageId = messageId;
    return this;
  }

   /**
   * Idempotent message ID. Store this ID locally or in a database to prevent message duplication.
   * @return messageId
  **/
  @ApiModelProperty(required = true, value = "Idempotent message ID. Store this ID locally or in a database to prevent message duplication.")

  public String getMessageId() {
    return messageId;
  }


  public void setMessageId(String messageId) {
    this.messageId = messageId;
  }


  public WebhookNewEmailPayload webhookId(UUID webhookId) {
    
    this.webhookId = webhookId;
    return this;
  }

   /**
   * ID of webhook entity being triggered
   * @return webhookId
  **/
  @ApiModelProperty(required = true, value = "ID of webhook entity being triggered")

  public UUID getWebhookId() {
    return webhookId;
  }


  public void setWebhookId(UUID webhookId) {
    this.webhookId = webhookId;
  }


  public WebhookNewEmailPayload eventName(EventNameEnum eventName) {
    
    this.eventName = eventName;
    return this;
  }

   /**
   * Name of the event type webhook is being triggered for.
   * @return eventName
  **/
  @ApiModelProperty(required = true, value = "Name of the event type webhook is being triggered for.")

  public EventNameEnum getEventName() {
    return eventName;
  }


  public void setEventName(EventNameEnum eventName) {
    this.eventName = eventName;
  }


  public WebhookNewEmailPayload webhookName(String webhookName) {
    
    this.webhookName = webhookName;
    return this;
  }

   /**
   * Name of the webhook being triggered
   * @return webhookName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Name of the webhook being triggered")

  public String getWebhookName() {
    return webhookName;
  }


  public void setWebhookName(String webhookName) {
    this.webhookName = webhookName;
  }


  public WebhookNewEmailPayload inboxId(UUID inboxId) {
    
    this.inboxId = inboxId;
    return this;
  }

   /**
   * Id of the inbox that received an email
   * @return inboxId
  **/
  @ApiModelProperty(required = true, value = "Id of the inbox that received an email")

  public UUID getInboxId() {
    return inboxId;
  }


  public void setInboxId(UUID inboxId) {
    this.inboxId = inboxId;
  }


  public WebhookNewEmailPayload emailId(UUID emailId) {
    
    this.emailId = emailId;
    return this;
  }

   /**
   * ID of the email that was received. Use this ID for fetching the email with the &#x60;EmailController&#x60;.
   * @return emailId
  **/
  @ApiModelProperty(required = true, value = "ID of the email that was received. Use this ID for fetching the email with the `EmailController`.")

  public UUID getEmailId() {
    return emailId;
  }


  public void setEmailId(UUID emailId) {
    this.emailId = emailId;
  }


  public WebhookNewEmailPayload createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Date time of event creation
   * @return createdAt
  **/
  @ApiModelProperty(required = true, value = "Date time of event creation")

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public WebhookNewEmailPayload to(List<String> to) {
    
    this.to = to;
    return this;
  }

  public WebhookNewEmailPayload addToItem(String toItem) {
    this.to.add(toItem);
    return this;
  }

   /**
   * List of &#x60;To&#x60; recipient email addresses that the email was addressed to. See recipients object for names.
   * @return to
  **/
  @ApiModelProperty(required = true, value = "List of `To` recipient email addresses that the email was addressed to. See recipients object for names.")

  public List<String> getTo() {
    return to;
  }


  public void setTo(List<String> to) {
    this.to = to;
  }


  public WebhookNewEmailPayload from(String from) {
    
    this.from = from;
    return this;
  }

   /**
   * Who the email was sent from. An email address - see fromName for the sender name.
   * @return from
  **/
  @ApiModelProperty(required = true, value = "Who the email was sent from. An email address - see fromName for the sender name.")

  public String getFrom() {
    return from;
  }


  public void setFrom(String from) {
    this.from = from;
  }


  public WebhookNewEmailPayload cc(List<String> cc) {
    
    this.cc = cc;
    return this;
  }

  public WebhookNewEmailPayload addCcItem(String ccItem) {
    this.cc.add(ccItem);
    return this;
  }

   /**
   * List of &#x60;CC&#x60; recipients email addresses that the email was addressed to. See recipients object for names.
   * @return cc
  **/
  @ApiModelProperty(required = true, value = "List of `CC` recipients email addresses that the email was addressed to. See recipients object for names.")

  public List<String> getCc() {
    return cc;
  }


  public void setCc(List<String> cc) {
    this.cc = cc;
  }


  public WebhookNewEmailPayload bcc(List<String> bcc) {
    
    this.bcc = bcc;
    return this;
  }

  public WebhookNewEmailPayload addBccItem(String bccItem) {
    this.bcc.add(bccItem);
    return this;
  }

   /**
   * List of &#x60;BCC&#x60; recipients email addresses that the email was addressed to. See recipients object for names.
   * @return bcc
  **/
  @ApiModelProperty(required = true, value = "List of `BCC` recipients email addresses that the email was addressed to. See recipients object for names.")

  public List<String> getBcc() {
    return bcc;
  }


  public void setBcc(List<String> bcc) {
    this.bcc = bcc;
  }


  public WebhookNewEmailPayload subject(String subject) {
    
    this.subject = subject;
    return this;
  }

   /**
   * The subject line of the email message as specified by SMTP subject header
   * @return subject
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The subject line of the email message as specified by SMTP subject header")

  public String getSubject() {
    return subject;
  }


  public void setSubject(String subject) {
    this.subject = subject;
  }


  public WebhookNewEmailPayload attachmentMetaDatas(List<AttachmentMetaData> attachmentMetaDatas) {
    
    this.attachmentMetaDatas = attachmentMetaDatas;
    return this;
  }

  public WebhookNewEmailPayload addAttachmentMetaDatasItem(AttachmentMetaData attachmentMetaDatasItem) {
    this.attachmentMetaDatas.add(attachmentMetaDatasItem);
    return this;
  }

   /**
   * List of attachment meta data objects if attachments present
   * @return attachmentMetaDatas
  **/
  @ApiModelProperty(required = true, value = "List of attachment meta data objects if attachments present")

  public List<AttachmentMetaData> getAttachmentMetaDatas() {
    return attachmentMetaDatas;
  }


  public void setAttachmentMetaDatas(List<AttachmentMetaData> attachmentMetaDatas) {
    this.attachmentMetaDatas = attachmentMetaDatas;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WebhookNewEmailPayload webhookNewEmailPayload = (WebhookNewEmailPayload) o;
    return Objects.equals(this.messageId, webhookNewEmailPayload.messageId) &&
        Objects.equals(this.webhookId, webhookNewEmailPayload.webhookId) &&
        Objects.equals(this.eventName, webhookNewEmailPayload.eventName) &&
        Objects.equals(this.webhookName, webhookNewEmailPayload.webhookName) &&
        Objects.equals(this.inboxId, webhookNewEmailPayload.inboxId) &&
        Objects.equals(this.emailId, webhookNewEmailPayload.emailId) &&
        Objects.equals(this.createdAt, webhookNewEmailPayload.createdAt) &&
        Objects.equals(this.to, webhookNewEmailPayload.to) &&
        Objects.equals(this.from, webhookNewEmailPayload.from) &&
        Objects.equals(this.cc, webhookNewEmailPayload.cc) &&
        Objects.equals(this.bcc, webhookNewEmailPayload.bcc) &&
        Objects.equals(this.subject, webhookNewEmailPayload.subject) &&
        Objects.equals(this.attachmentMetaDatas, webhookNewEmailPayload.attachmentMetaDatas);
  }

  @Override
  public int hashCode() {
    return Objects.hash(messageId, webhookId, eventName, webhookName, inboxId, emailId, createdAt, to, from, cc, bcc, subject, attachmentMetaDatas);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WebhookNewEmailPayload {\n");
    sb.append("    messageId: ").append(toIndentedString(messageId)).append("\n");
    sb.append("    webhookId: ").append(toIndentedString(webhookId)).append("\n");
    sb.append("    eventName: ").append(toIndentedString(eventName)).append("\n");
    sb.append("    webhookName: ").append(toIndentedString(webhookName)).append("\n");
    sb.append("    inboxId: ").append(toIndentedString(inboxId)).append("\n");
    sb.append("    emailId: ").append(toIndentedString(emailId)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    cc: ").append(toIndentedString(cc)).append("\n");
    sb.append("    bcc: ").append(toIndentedString(bcc)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    attachmentMetaDatas: ").append(toIndentedString(attachmentMetaDatas)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

