/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * Contact: contact@mailslurp.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.UUID;

/**
 * WebhookResultDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-03-07T02:51:59.203Z[GMT]")
public class WebhookResultDto {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private UUID id;

  public static final String SERIALIZED_NAME_USER_ID = "userId";
  @SerializedName(SERIALIZED_NAME_USER_ID)
  private UUID userId;

  public static final String SERIALIZED_NAME_INBOX_ID = "inboxId";
  @SerializedName(SERIALIZED_NAME_INBOX_ID)
  private UUID inboxId;

  public static final String SERIALIZED_NAME_WEBHOOK_ID = "webhookId";
  @SerializedName(SERIALIZED_NAME_WEBHOOK_ID)
  private UUID webhookId;

  public static final String SERIALIZED_NAME_WEBHOOK_URL = "webhookUrl";
  @SerializedName(SERIALIZED_NAME_WEBHOOK_URL)
  private String webhookUrl;

  public static final String SERIALIZED_NAME_MESSAGE_ID = "messageId";
  @SerializedName(SERIALIZED_NAME_MESSAGE_ID)
  private String messageId;

  public static final String SERIALIZED_NAME_REDRIVE_ID = "redriveId";
  @SerializedName(SERIALIZED_NAME_REDRIVE_ID)
  private UUID redriveId;

  /**
   * Gets or Sets httpMethod
   */
  @JsonAdapter(HttpMethodEnum.Adapter.class)
  public enum HttpMethodEnum {
    GET("GET"),
    
    HEAD("HEAD"),
    
    POST("POST"),
    
    PUT("PUT"),
    
    PATCH("PATCH"),
    
    DELETE("DELETE"),
    
    OPTIONS("OPTIONS"),
    
    TRACE("TRACE");

    private String value;

    HttpMethodEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static HttpMethodEnum fromValue(String value) {
      for (HttpMethodEnum b : HttpMethodEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<HttpMethodEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final HttpMethodEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public HttpMethodEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return HttpMethodEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_HTTP_METHOD = "httpMethod";
  @SerializedName(SERIALIZED_NAME_HTTP_METHOD)
  private HttpMethodEnum httpMethod;

  /**
   * Gets or Sets webhookEvent
   */
  @JsonAdapter(WebhookEventEnum.Adapter.class)
  public enum WebhookEventEnum {
    EMAIL_RECEIVED("EMAIL_RECEIVED"),
    
    NEW_EMAIL("NEW_EMAIL"),
    
    NEW_CONTACT("NEW_CONTACT"),
    
    NEW_ATTACHMENT("NEW_ATTACHMENT"),
    
    EMAIL_OPENED("EMAIL_OPENED"),
    
    EMAIL_READ("EMAIL_READ");

    private String value;

    WebhookEventEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static WebhookEventEnum fromValue(String value) {
      for (WebhookEventEnum b : WebhookEventEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<WebhookEventEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final WebhookEventEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public WebhookEventEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return WebhookEventEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_WEBHOOK_EVENT = "webhookEvent";
  @SerializedName(SERIALIZED_NAME_WEBHOOK_EVENT)
  private WebhookEventEnum webhookEvent;

  public static final String SERIALIZED_NAME_RESPONSE_STATUS = "responseStatus";
  @SerializedName(SERIALIZED_NAME_RESPONSE_STATUS)
  private Integer responseStatus;

  public static final String SERIALIZED_NAME_RESPONSE_TIME_MILLIS = "responseTimeMillis";
  @SerializedName(SERIALIZED_NAME_RESPONSE_TIME_MILLIS)
  private Long responseTimeMillis;

  public static final String SERIALIZED_NAME_RESPONSE_BODY_EXTRACT = "responseBodyExtract";
  @SerializedName(SERIALIZED_NAME_RESPONSE_BODY_EXTRACT)
  private String responseBodyExtract;

  /**
   * Gets or Sets resultType
   */
  @JsonAdapter(ResultTypeEnum.Adapter.class)
  public enum ResultTypeEnum {
    BAD_RESPONSE("BAD_RESPONSE"),
    
    EXCEPTION("EXCEPTION"),
    
    SUCCESS("SUCCESS");

    private String value;

    ResultTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ResultTypeEnum fromValue(String value) {
      for (ResultTypeEnum b : ResultTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ResultTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ResultTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ResultTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ResultTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_RESULT_TYPE = "resultType";
  @SerializedName(SERIALIZED_NAME_RESULT_TYPE)
  private ResultTypeEnum resultType;

  public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private OffsetDateTime createdAt;

  public static final String SERIALIZED_NAME_UPDATED_AT = "updatedAt";
  @SerializedName(SERIALIZED_NAME_UPDATED_AT)
  private OffsetDateTime updatedAt;

  public static final String SERIALIZED_NAME_SEEN = "seen";
  @SerializedName(SERIALIZED_NAME_SEEN)
  private Boolean seen;


  public WebhookResultDto id(UUID id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public UUID getId() {
    return id;
  }


  public void setId(UUID id) {
    this.id = id;
  }


  public WebhookResultDto userId(UUID userId) {
    
    this.userId = userId;
    return this;
  }

   /**
   * Get userId
   * @return userId
  **/
  @ApiModelProperty(required = true, value = "")

  public UUID getUserId() {
    return userId;
  }


  public void setUserId(UUID userId) {
    this.userId = userId;
  }


  public WebhookResultDto inboxId(UUID inboxId) {
    
    this.inboxId = inboxId;
    return this;
  }

   /**
   * Get inboxId
   * @return inboxId
  **/
  @ApiModelProperty(required = true, value = "")

  public UUID getInboxId() {
    return inboxId;
  }


  public void setInboxId(UUID inboxId) {
    this.inboxId = inboxId;
  }


  public WebhookResultDto webhookId(UUID webhookId) {
    
    this.webhookId = webhookId;
    return this;
  }

   /**
   * Get webhookId
   * @return webhookId
  **/
  @ApiModelProperty(required = true, value = "")

  public UUID getWebhookId() {
    return webhookId;
  }


  public void setWebhookId(UUID webhookId) {
    this.webhookId = webhookId;
  }


  public WebhookResultDto webhookUrl(String webhookUrl) {
    
    this.webhookUrl = webhookUrl;
    return this;
  }

   /**
   * Get webhookUrl
   * @return webhookUrl
  **/
  @ApiModelProperty(required = true, value = "")

  public String getWebhookUrl() {
    return webhookUrl;
  }


  public void setWebhookUrl(String webhookUrl) {
    this.webhookUrl = webhookUrl;
  }


  public WebhookResultDto messageId(String messageId) {
    
    this.messageId = messageId;
    return this;
  }

   /**
   * Get messageId
   * @return messageId
  **/
  @ApiModelProperty(required = true, value = "")

  public String getMessageId() {
    return messageId;
  }


  public void setMessageId(String messageId) {
    this.messageId = messageId;
  }


  public WebhookResultDto redriveId(UUID redriveId) {
    
    this.redriveId = redriveId;
    return this;
  }

   /**
   * Get redriveId
   * @return redriveId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public UUID getRedriveId() {
    return redriveId;
  }


  public void setRedriveId(UUID redriveId) {
    this.redriveId = redriveId;
  }


  public WebhookResultDto httpMethod(HttpMethodEnum httpMethod) {
    
    this.httpMethod = httpMethod;
    return this;
  }

   /**
   * Get httpMethod
   * @return httpMethod
  **/
  @ApiModelProperty(required = true, value = "")

  public HttpMethodEnum getHttpMethod() {
    return httpMethod;
  }


  public void setHttpMethod(HttpMethodEnum httpMethod) {
    this.httpMethod = httpMethod;
  }


  public WebhookResultDto webhookEvent(WebhookEventEnum webhookEvent) {
    
    this.webhookEvent = webhookEvent;
    return this;
  }

   /**
   * Get webhookEvent
   * @return webhookEvent
  **/
  @ApiModelProperty(required = true, value = "")

  public WebhookEventEnum getWebhookEvent() {
    return webhookEvent;
  }


  public void setWebhookEvent(WebhookEventEnum webhookEvent) {
    this.webhookEvent = webhookEvent;
  }


  public WebhookResultDto responseStatus(Integer responseStatus) {
    
    this.responseStatus = responseStatus;
    return this;
  }

   /**
   * Get responseStatus
   * @return responseStatus
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Integer getResponseStatus() {
    return responseStatus;
  }


  public void setResponseStatus(Integer responseStatus) {
    this.responseStatus = responseStatus;
  }


  public WebhookResultDto responseTimeMillis(Long responseTimeMillis) {
    
    this.responseTimeMillis = responseTimeMillis;
    return this;
  }

   /**
   * Get responseTimeMillis
   * @return responseTimeMillis
  **/
  @ApiModelProperty(required = true, value = "")

  public Long getResponseTimeMillis() {
    return responseTimeMillis;
  }


  public void setResponseTimeMillis(Long responseTimeMillis) {
    this.responseTimeMillis = responseTimeMillis;
  }


  public WebhookResultDto responseBodyExtract(String responseBodyExtract) {
    
    this.responseBodyExtract = responseBodyExtract;
    return this;
  }

   /**
   * Get responseBodyExtract
   * @return responseBodyExtract
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getResponseBodyExtract() {
    return responseBodyExtract;
  }


  public void setResponseBodyExtract(String responseBodyExtract) {
    this.responseBodyExtract = responseBodyExtract;
  }


  public WebhookResultDto resultType(ResultTypeEnum resultType) {
    
    this.resultType = resultType;
    return this;
  }

   /**
   * Get resultType
   * @return resultType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public ResultTypeEnum getResultType() {
    return resultType;
  }


  public void setResultType(ResultTypeEnum resultType) {
    this.resultType = resultType;
  }


  public WebhookResultDto createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Get createdAt
   * @return createdAt
  **/
  @ApiModelProperty(required = true, value = "")

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public WebhookResultDto updatedAt(OffsetDateTime updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @ApiModelProperty(required = true, value = "")

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }


  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }


  public WebhookResultDto seen(Boolean seen) {
    
    this.seen = seen;
    return this;
  }

   /**
   * Get seen
   * @return seen
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Boolean getSeen() {
    return seen;
  }


  public void setSeen(Boolean seen) {
    this.seen = seen;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WebhookResultDto webhookResultDto = (WebhookResultDto) o;
    return Objects.equals(this.id, webhookResultDto.id) &&
        Objects.equals(this.userId, webhookResultDto.userId) &&
        Objects.equals(this.inboxId, webhookResultDto.inboxId) &&
        Objects.equals(this.webhookId, webhookResultDto.webhookId) &&
        Objects.equals(this.webhookUrl, webhookResultDto.webhookUrl) &&
        Objects.equals(this.messageId, webhookResultDto.messageId) &&
        Objects.equals(this.redriveId, webhookResultDto.redriveId) &&
        Objects.equals(this.httpMethod, webhookResultDto.httpMethod) &&
        Objects.equals(this.webhookEvent, webhookResultDto.webhookEvent) &&
        Objects.equals(this.responseStatus, webhookResultDto.responseStatus) &&
        Objects.equals(this.responseTimeMillis, webhookResultDto.responseTimeMillis) &&
        Objects.equals(this.responseBodyExtract, webhookResultDto.responseBodyExtract) &&
        Objects.equals(this.resultType, webhookResultDto.resultType) &&
        Objects.equals(this.createdAt, webhookResultDto.createdAt) &&
        Objects.equals(this.updatedAt, webhookResultDto.updatedAt) &&
        Objects.equals(this.seen, webhookResultDto.seen);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, userId, inboxId, webhookId, webhookUrl, messageId, redriveId, httpMethod, webhookEvent, responseStatus, responseTimeMillis, responseBodyExtract, resultType, createdAt, updatedAt, seen);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WebhookResultDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    inboxId: ").append(toIndentedString(inboxId)).append("\n");
    sb.append("    webhookId: ").append(toIndentedString(webhookId)).append("\n");
    sb.append("    webhookUrl: ").append(toIndentedString(webhookUrl)).append("\n");
    sb.append("    messageId: ").append(toIndentedString(messageId)).append("\n");
    sb.append("    redriveId: ").append(toIndentedString(redriveId)).append("\n");
    sb.append("    httpMethod: ").append(toIndentedString(httpMethod)).append("\n");
    sb.append("    webhookEvent: ").append(toIndentedString(webhookEvent)).append("\n");
    sb.append("    responseStatus: ").append(toIndentedString(responseStatus)).append("\n");
    sb.append("    responseTimeMillis: ").append(toIndentedString(responseTimeMillis)).append("\n");
    sb.append("    responseBodyExtract: ").append(toIndentedString(responseBodyExtract)).append("\n");
    sb.append("    resultType: ").append(toIndentedString(resultType)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    seen: ").append(toIndentedString(seen)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

