/**
* MailSlurp API
* MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.   ## Resources - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
*
* The version of the OpenAPI document: 6.5.2
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
package com.mailslurp.models


import com.squareup.moshi.Json

/**
 * Email alias representation
 * @param id 
 * @param userId 
 * @param createdAt 
 * @param emailAddress The alias's email address for receiving email
 * @param inboxId Inbox that is associated with the alias
 * @param isVerified Has the alias been verified. You must verify an alias if the masked email address has not yet been verified by your account
 * @param maskedEmailAddress The underlying email address that is hidden and will received forwarded email
 * @param name 
 * @param updatedAt 
 * @param useThreads If alias will generate response threads or not when email are received by it
 */

data class AliasDto (
    @Json(name = "id")
    val id: java.util.UUID,
    @Json(name = "userId")
    val userId: java.util.UUID,
    @Json(name = "createdAt")
    val createdAt: java.time.OffsetDateTime? = null,
    /* The alias's email address for receiving email */
    @Json(name = "emailAddress")
    val emailAddress: kotlin.String? = null,
    /* Inbox that is associated with the alias */
    @Json(name = "inboxId")
    val inboxId: java.util.UUID? = null,
    /* Has the alias been verified. You must verify an alias if the masked email address has not yet been verified by your account */
    @Json(name = "isVerified")
    val isVerified: kotlin.Boolean? = null,
    /* The underlying email address that is hidden and will received forwarded email */
    @Json(name = "maskedEmailAddress")
    val maskedEmailAddress: kotlin.String? = null,
    @Json(name = "name")
    val name: kotlin.String? = null,
    @Json(name = "updatedAt")
    val updatedAt: java.time.OffsetDateTime? = null,
    /* If alias will generate response threads or not when email are received by it */
    @Json(name = "useThreads")
    val useThreads: kotlin.Boolean? = null
)

