/**
* MailSlurp API
* MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.   ## Resources - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
*
* The version of the OpenAPI document: 6.5.2
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
package com.mailslurp.models


import com.squareup.moshi.Json

/**
 * Sent email details
 * @param sentAt 
 * @param attachments Array of IDs of attachments that were sent with this email
 * @param bcc 
 * @param body 
 * @param bodyMD5Hash MD5 Hash
 * @param cc 
 * @param charset 
 * @param from 
 * @param id ID of sent email
 * @param inboxId Inbox ID email was sent from
 * @param isHTML 
 * @param replyTo 
 * @param subject 
 * @param to Recipients email was sent to
 * @param userId User ID
 */

data class SentEmailDto (
    @Json(name = "sentAt")
    val sentAt: java.time.OffsetDateTime,
    /* Array of IDs of attachments that were sent with this email */
    @Json(name = "attachments")
    val attachments: kotlin.collections.List<kotlin.String>? = null,
    @Json(name = "bcc")
    val bcc: kotlin.collections.List<kotlin.String>? = null,
    @Json(name = "body")
    val body: kotlin.String? = null,
    /* MD5 Hash */
    @Json(name = "bodyMD5Hash")
    val bodyMD5Hash: kotlin.String? = null,
    @Json(name = "cc")
    val cc: kotlin.collections.List<kotlin.String>? = null,
    @Json(name = "charset")
    val charset: kotlin.String? = null,
    @Json(name = "from")
    val from: kotlin.String? = null,
    /* ID of sent email */
    @Json(name = "id")
    val id: java.util.UUID? = null,
    /* Inbox ID email was sent from */
    @Json(name = "inboxId")
    val inboxId: java.util.UUID? = null,
    @Json(name = "isHTML")
    val isHTML: kotlin.Boolean? = null,
    @Json(name = "replyTo")
    val replyTo: kotlin.String? = null,
    @Json(name = "subject")
    val subject: kotlin.String? = null,
    /* Recipients email was sent to */
    @Json(name = "to")
    val to: kotlin.collections.List<kotlin.String>? = null,
    /* User ID */
    @Json(name = "userId")
    val userId: java.util.UUID? = null
)

