/**
* MailSlurp API
* MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.   ## Resources - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
*
* The version of the OpenAPI document: 6.5.2
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
package com.mailslurp.models


import com.squareup.moshi.Json

/**
 * Options for uploading files for attachments. When sending emails with the API that require attachments first upload each attachment. Then use the returned attachment ID in your `SendEmailOptions` when sending an email. This way you can use attachments multiple times once they have been uploaded.
 * @param base64Contents Base64 encoded string of file contents. Typically this means reading the bytes or string content of a file and then converting that to a base64 encoded string.
 * @param contentType Optional contentType for file. For instance `application/pdf`
 * @param filename Optional filename to save upload with. Will be the name that is shown in email clients
 */

data class UploadAttachmentOptions (
    /* Base64 encoded string of file contents. Typically this means reading the bytes or string content of a file and then converting that to a base64 encoded string. */
    @Json(name = "base64Contents")
    val base64Contents: kotlin.String? = null,
    /* Optional contentType for file. For instance `application/pdf` */
    @Json(name = "contentType")
    val contentType: kotlin.String? = null,
    /* Optional filename to save upload with. Will be the name that is shown in email clients */
    @Json(name = "filename")
    val filename: kotlin.String? = null
)

