/**
* MailSlurp API
* MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.   ## Resources - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
*
* The version of the OpenAPI document: 6.5.2
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
package com.mailslurp.models

import com.mailslurp.models.MatchOption

import com.squareup.moshi.Json

/**
 * Conditions that a `waitForXEmails` endpoint operates on. The methods wait until given conditions are met or a timeout is reached. If the conditions are met without needing to wait the results will be returned immediately.
 * @param count Number of results that should match conditions. Either exactly or at least this amount based on the `countType`. If count condition is not met and the timeout has not been reached the `waitFor` method will retry the operation.
 * @param countType How should the found count be compared to the expected count.
 * @param inboxId ID of inbox to search within and apply conditions to. Essentially filtering the emails found to give a count.
 * @param matches Conditions that should be matched for an email to qualify for results. Each condition will be applied in order to each email within an inbox to filter a result list of matching emails you are waiting for.
 * @param sortDirection Direction to sort matching emails by created time
 * @param timeout Max time in milliseconds to retry the `waitFor` operation until conditions are met.
 * @param unreadOnly Apply conditions only to **unread** emails. All emails begin with `read=false`. An email is marked `read=true` when an `EmailDto` representation of it has been returned to the user at least once. For example you have called `getEmail` or `waitForLatestEmail` etc., or you have viewed the email in the dashboard. 
 */

data class WaitForConditions (
    /* Number of results that should match conditions. Either exactly or at least this amount based on the `countType`. If count condition is not met and the timeout has not been reached the `waitFor` method will retry the operation. */
    @Json(name = "count")
    val count: kotlin.Int? = null,
    /* How should the found count be compared to the expected count. */
    @Json(name = "countType")
    val countType: WaitForConditions.CountType? = null,
    /* ID of inbox to search within and apply conditions to. Essentially filtering the emails found to give a count. */
    @Json(name = "inboxId")
    val inboxId: java.util.UUID? = null,
    /* Conditions that should be matched for an email to qualify for results. Each condition will be applied in order to each email within an inbox to filter a result list of matching emails you are waiting for. */
    @Json(name = "matches")
    val matches: kotlin.collections.List<MatchOption>? = null,
    /* Direction to sort matching emails by created time */
    @Json(name = "sortDirection")
    val sortDirection: WaitForConditions.SortDirection? = null,
    /* Max time in milliseconds to retry the `waitFor` operation until conditions are met. */
    @Json(name = "timeout")
    val timeout: kotlin.Long? = null,
    /* Apply conditions only to **unread** emails. All emails begin with `read=false`. An email is marked `read=true` when an `EmailDto` representation of it has been returned to the user at least once. For example you have called `getEmail` or `waitForLatestEmail` etc., or you have viewed the email in the dashboard.  */
    @Json(name = "unreadOnly")
    val unreadOnly: kotlin.Boolean? = null
) {

    /**
     * How should the found count be compared to the expected count.
     * Values: eXACTLY,aTLEAST
     */
    enum class CountType(val value: kotlin.String) {
        @Json(name = "EXACTLY") eXACTLY("EXACTLY"),
        @Json(name = "ATLEAST") aTLEAST("ATLEAST");
    }
    /**
     * Direction to sort matching emails by created time
     * Values: aSC,dESC
     */
    enum class SortDirection(val value: kotlin.String) {
        @Json(name = "ASC") aSC("ASC"),
        @Json(name = "DESC") dESC("DESC");
    }
}

