/**
* MailSlurp API
* MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.   ## Resources - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
*
* The version of the OpenAPI document: 6.5.2
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
package com.mailslurp.models


import com.squareup.moshi.Json

/**
 * Representation of a webhook for an inbox. The URL specified will be using by MailSlurp whenever an email is received by the attached inbox. A webhook entity should have a URL that points to your server. Your server should accept HTTP/S POST requests and return a success 200. MailSlurp will retry your webhooks if they fail. See https://api.mailslurp.com/schemas/webhook-payload for the payload schema.
 * @param updatedAt 
 * @param basicAuth Does webhook expect basic authentication? If true it means you created this webhook with a username and password. MailSlurp will use these in the URL to authenticate itself.
 * @param createdAt When the webhook was created
 * @param id ID of the Webhook
 * @param inboxId The inbox that the Webhook will be triggered by
 * @param method HTTP method that your server endpoint must listen for
 * @param name Name of the webhook
 * @param payloadJsonSchema JSON Schema for the payload that will be sent to your URL via the HTTP method described.
 * @param url URL of your server that the webhook will be sent to. The schema of the JSON that is sent is described by the payloadJsonSchema.
 */

data class WebhookDto (
    @Json(name = "updatedAt")
    val updatedAt: java.time.OffsetDateTime,
    /* Does webhook expect basic authentication? If true it means you created this webhook with a username and password. MailSlurp will use these in the URL to authenticate itself. */
    @Json(name = "basicAuth")
    val basicAuth: kotlin.Boolean? = null,
    /* When the webhook was created */
    @Json(name = "createdAt")
    val createdAt: java.time.OffsetDateTime? = null,
    /* ID of the Webhook */
    @Json(name = "id")
    val id: java.util.UUID? = null,
    /* The inbox that the Webhook will be triggered by */
    @Json(name = "inboxId")
    val inboxId: java.util.UUID? = null,
    /* HTTP method that your server endpoint must listen for */
    @Json(name = "method")
    val method: WebhookDto.Method? = null,
    /* Name of the webhook */
    @Json(name = "name")
    val name: kotlin.String? = null,
    /* JSON Schema for the payload that will be sent to your URL via the HTTP method described. */
    @Json(name = "payloadJsonSchema")
    val payloadJsonSchema: kotlin.String? = null,
    /* URL of your server that the webhook will be sent to. The schema of the JSON that is sent is described by the payloadJsonSchema. */
    @Json(name = "url")
    val url: kotlin.String? = null
) {

    /**
     * HTTP method that your server endpoint must listen for
     * Values: gET,hEAD,pOST,pUT,pATCH,dELETE,oPTIONS,tRACE
     */
    enum class Method(val value: kotlin.String) {
        @Json(name = "GET") gET("GET"),
        @Json(name = "HEAD") hEAD("HEAD"),
        @Json(name = "POST") pOST("POST"),
        @Json(name = "PUT") pUT("PUT"),
        @Json(name = "PATCH") pATCH("PATCH"),
        @Json(name = "DELETE") dELETE("DELETE"),
        @Json(name = "OPTIONS") oPTIONS("OPTIONS"),
        @Json(name = "TRACE") tRACE("TRACE");
    }
}

