/**
* MailSlurp API
* MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
*
* The version of the OpenAPI document: 6.5.2
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
package com.mailslurp.models

import com.mailslurp.models.DomainNameRecord

import com.squareup.moshi.Json

/**
 * Domain plus verification records and status
 * @param createdAt 
 * @param id 
 * @param updatedAt 
 * @param userId 
 * @param catchAllInboxId The optional catch all inbox that will receive emails sent to the domain that cannot be matched.
 * @param dkimTokens Unique token DKIM tokens
 * @param domain Custom domain name
 * @param domainNameRecords List of DNS domain name records (C, MX, TXT) etc that you must add to the DNS server associated with your domain provider.
 * @param domainType The type of domain. SMTP or HTTP domains differ in what inboxes can be used with them.
 * @param isVerified Whether domain has been verified or not. If the domain is not verified after 72 hours there is most likely an issue with the domains DNS records.
 * @param verificationToken Verification tokens
 */

data class DomainDto (
    @Json(name = "createdAt")
    val createdAt: java.time.OffsetDateTime,
    @Json(name = "id")
    val id: java.util.UUID,
    @Json(name = "updatedAt")
    val updatedAt: java.time.OffsetDateTime,
    @Json(name = "userId")
    val userId: java.util.UUID,
    /* The optional catch all inbox that will receive emails sent to the domain that cannot be matched. */
    @Json(name = "catchAllInboxId")
    val catchAllInboxId: java.util.UUID? = null,
    /* Unique token DKIM tokens */
    @Json(name = "dkimTokens")
    val dkimTokens: kotlin.collections.List<kotlin.String>? = null,
    /* Custom domain name */
    @Json(name = "domain")
    val domain: kotlin.String? = null,
    /* List of DNS domain name records (C, MX, TXT) etc that you must add to the DNS server associated with your domain provider. */
    @Json(name = "domainNameRecords")
    val domainNameRecords: kotlin.collections.List<DomainNameRecord>? = null,
    /* The type of domain. SMTP or HTTP domains differ in what inboxes can be used with them. */
    @Json(name = "domainType")
    val domainType: DomainDto.DomainType? = null,
    /* Whether domain has been verified or not. If the domain is not verified after 72 hours there is most likely an issue with the domains DNS records. */
    @Json(name = "isVerified")
    val isVerified: kotlin.Boolean? = null,
    /* Verification tokens */
    @Json(name = "verificationToken")
    val verificationToken: kotlin.String? = null
) {

    /**
     * The type of domain. SMTP or HTTP domains differ in what inboxes can be used with them.
     * Values: hTTPINBOX,sMTPDOMAIN
     */
    enum class DomainType(val value: kotlin.String) {
        @Json(name = "HTTP_INBOX") hTTPINBOX("HTTP_INBOX"),
        @Json(name = "SMTP_DOMAIN") sMTPDOMAIN("SMTP_DOMAIN");
    }
}

