/**
* MailSlurp API
* MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
*
* The version of the OpenAPI document: 6.5.2
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
package com.mailslurp.models


import com.squareup.moshi.Json

/**
 * Options for replying to an alias email using the alias inbox
 * @param attachments List of uploaded attachments to send with the reply. Optional.
 * @param body Body of the reply email you want to send
 * @param charset The charset that your message should be sent with. Optional. Default is UTF-8
 * @param isHTML Is the reply HTML
 * @param sendStrategy When to send the email. Typically immediately
 * @param template Template ID to use instead of body. Will use template variable map to fill defined variable slots.
 * @param templateVariables Template variables if using a template
 * @param useInboxName Optionally use inbox name as display name for sender email address
 */

data class ReplyToAliasEmailOptions (
    /* List of uploaded attachments to send with the reply. Optional. */
    @Json(name = "attachments")
    val attachments: kotlin.collections.List<kotlin.String>? = null,
    /* Body of the reply email you want to send */
    @Json(name = "body")
    val body: kotlin.String? = null,
    /* The charset that your message should be sent with. Optional. Default is UTF-8 */
    @Json(name = "charset")
    val charset: kotlin.String? = null,
    /* Is the reply HTML */
    @Json(name = "isHTML")
    val isHTML: kotlin.Boolean? = null,
    /* When to send the email. Typically immediately */
    @Json(name = "sendStrategy")
    val sendStrategy: ReplyToAliasEmailOptions.SendStrategy? = null,
    /* Template ID to use instead of body. Will use template variable map to fill defined variable slots. */
    @Json(name = "template")
    val template: java.util.UUID? = null,
    /* Template variables if using a template */
    @Json(name = "templateVariables")
    val templateVariables: kotlin.Any? = null,
    /* Optionally use inbox name as display name for sender email address */
    @Json(name = "useInboxName")
    val useInboxName: kotlin.Boolean? = null
) {

    /**
     * When to send the email. Typically immediately
     * Values: sINGLEMESSAGE
     */
    enum class SendStrategy(val value: kotlin.String) {
        @Json(name = "SINGLE_MESSAGE") sINGLEMESSAGE("SINGLE_MESSAGE");
    }
}

