/**
* MailSlurp API
* MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
*
* The version of the OpenAPI document: 6.5.2
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
package com.mailslurp.models

import com.mailslurp.models.AttachmentMetaData

import com.squareup.moshi.Json

/**
 * NEW_EMAIL webhook payload. Sent to your webhook url endpoint via HTTP POST when an email is received by the inbox that your webhook is attached to. Use the email ID to fetch the full email body or attachments.
 * @param attachmentMetaDatas List of attachment meta data objects if attachments present
 * @param bcc List of `BCC` recipients email was addressed to
 * @param cc List of `CC` recipients email was addressed to
 * @param createdAt Date time of event creation
 * @param emailId ID of the email that was received. Use this ID for fetching the email with the `EmailController`.
 * @param eventName Name of the event type webhook is being triggered for.
 * @param from Who the email was sent from
 * @param inboxId Id of the inbox that received an email
 * @param messageId Idempotent message ID. Store this ID locally or in a database to prevent message duplication.
 * @param subject The subject line of the email message
 * @param to List of `To` recipients that email was addressed to
 * @param webhookId ID of webhook entity being triggered
 * @param webhookName Name of the webhook being triggered
 */

data class WebhookNewEmailPayload (
    /* List of attachment meta data objects if attachments present */
    @Json(name = "attachmentMetaDatas")
    val attachmentMetaDatas: kotlin.collections.List<AttachmentMetaData>? = null,
    /* List of `BCC` recipients email was addressed to */
    @Json(name = "bcc")
    val bcc: kotlin.collections.List<kotlin.String>? = null,
    /* List of `CC` recipients email was addressed to */
    @Json(name = "cc")
    val cc: kotlin.collections.List<kotlin.String>? = null,
    /* Date time of event creation */
    @Json(name = "createdAt")
    val createdAt: java.time.OffsetDateTime? = null,
    /* ID of the email that was received. Use this ID for fetching the email with the `EmailController`. */
    @Json(name = "emailId")
    val emailId: java.util.UUID? = null,
    /* Name of the event type webhook is being triggered for. */
    @Json(name = "eventName")
    val eventName: WebhookNewEmailPayload.EventName? = null,
    /* Who the email was sent from */
    @Json(name = "from")
    val from: kotlin.String? = null,
    /* Id of the inbox that received an email */
    @Json(name = "inboxId")
    val inboxId: java.util.UUID? = null,
    /* Idempotent message ID. Store this ID locally or in a database to prevent message duplication. */
    @Json(name = "messageId")
    val messageId: kotlin.String? = null,
    /* The subject line of the email message */
    @Json(name = "subject")
    val subject: kotlin.String? = null,
    /* List of `To` recipients that email was addressed to */
    @Json(name = "to")
    val to: kotlin.collections.List<kotlin.String>? = null,
    /* ID of webhook entity being triggered */
    @Json(name = "webhookId")
    val webhookId: java.util.UUID? = null,
    /* Name of the webhook being triggered */
    @Json(name = "webhookName")
    val webhookName: kotlin.String? = null
) {

    /**
     * Name of the event type webhook is being triggered for.
     * Values: eMAILRECEIVED,nEWEMAIL,nEWCONTACT,nEWATTACHMENT
     */
    enum class EventName(val value: kotlin.String) {
        @Json(name = "EMAIL_RECEIVED") eMAILRECEIVED("EMAIL_RECEIVED"),
        @Json(name = "NEW_EMAIL") nEWEMAIL("NEW_EMAIL"),
        @Json(name = "NEW_CONTACT") nEWCONTACT("NEW_CONTACT"),
        @Json(name = "NEW_ATTACHMENT") nEWATTACHMENT("NEW_ATTACHMENT");
    }
}

