/**
* MailSlurp API
* MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
*
* The version of the OpenAPI document: 6.5.2
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
package com.mailslurp.apis

import com.mailslurp.models.Inbox
import com.mailslurp.models.SimpleSendEmailOptions

import com.mailslurp.infrastructure.ApiClient
import com.mailslurp.infrastructure.ClientException
import com.mailslurp.infrastructure.ClientError
import com.mailslurp.infrastructure.ServerException
import com.mailslurp.infrastructure.ServerError
import com.mailslurp.infrastructure.MultiValueMap
import com.mailslurp.infrastructure.RequestConfig
import com.mailslurp.infrastructure.RequestMethod
import com.mailslurp.infrastructure.ResponseType
import com.mailslurp.infrastructure.Success
import com.mailslurp.infrastructure.toMultiValue

class CommonActionsControllerApi(private val xApiKey: kotlin.String, basePath: kotlin.String = defaultBasePath) : ApiClient(basePath) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty("com.mailslurp.baseUrl", "https://api.mailslurp.com")
        }
    }

    /**
    * Create new random inbox
    * Returns an Inbox with an &#x60;id&#x60; and an &#x60;emailAddress&#x60;
    * @param allowTeamAccess allowTeamAccess (optional)
    * @param description description (optional)
    * @param emailAddress emailAddress (optional)
    * @param expiresAt expiresAt (optional)
    * @param expiresIn expiresIn (optional)
    * @param favourite favourite (optional)
    * @param inboxType inboxType (optional)
    * @param name name (optional)
    * @param tags tags (optional)
    * @param useDomainPool useDomainPool (optional)
    * @return Inbox
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun createNewEmailAddress(allowTeamAccess: kotlin.Boolean?, description: kotlin.String?, emailAddress: kotlin.String?, expiresAt: java.time.OffsetDateTime?, expiresIn: kotlin.Long?, favourite: kotlin.Boolean?, inboxType: kotlin.String?, name: kotlin.String?, tags: kotlin.collections.List<kotlin.String>?, useDomainPool: kotlin.Boolean?) : Inbox {
        val localVariableConfig = createNewEmailAddressRequestConfig(allowTeamAccess = allowTeamAccess, description = description, emailAddress = emailAddress, expiresAt = expiresAt, expiresIn = expiresIn, favourite = favourite, inboxType = inboxType, name = name, tags = tags, useDomainPool = useDomainPool)

        val localVarResponse = request<Inbox>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as Inbox
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation createNewEmailAddress
    *
    * @param allowTeamAccess allowTeamAccess (optional)
    * @param description description (optional)
    * @param emailAddress emailAddress (optional)
    * @param expiresAt expiresAt (optional)
    * @param expiresIn expiresIn (optional)
    * @param favourite favourite (optional)
    * @param inboxType inboxType (optional)
    * @param name name (optional)
    * @param tags tags (optional)
    * @param useDomainPool useDomainPool (optional)
    * @return RequestConfig
    */
    fun createNewEmailAddressRequestConfig(allowTeamAccess: kotlin.Boolean?, description: kotlin.String?, emailAddress: kotlin.String?, expiresAt: java.time.OffsetDateTime?, expiresIn: kotlin.Long?, favourite: kotlin.Boolean?, inboxType: kotlin.String?, name: kotlin.String?, tags: kotlin.collections.List<kotlin.String>?, useDomainPool: kotlin.Boolean?) : RequestConfig {
        val localVariableBody: kotlin.Any? = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                if (allowTeamAccess != null) {
                    put("allowTeamAccess", listOf(allowTeamAccess.toString()))
                }
                if (description != null) {
                    put("description", listOf(description.toString()))
                }
                if (emailAddress != null) {
                    put("emailAddress", listOf(emailAddress.toString()))
                }
                if (expiresAt != null) {
                    put("expiresAt", listOf(parseDateToQueryString(expiresAt)))
                }
                if (expiresIn != null) {
                    put("expiresIn", listOf(expiresIn.toString()))
                }
                if (favourite != null) {
                    put("favourite", listOf(favourite.toString()))
                }
                if (inboxType != null) {
                    put("inboxType", listOf(inboxType.toString()))
                }
                if (name != null) {
                    put("name", listOf(name.toString()))
                }
                if (tags != null) {
                    put("tags", toMultiValue(tags.toList(), "multi"))
                }
                if (useDomainPool != null) {
                    put("useDomainPool", listOf(useDomainPool.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.POST,
            path = "/createInbox",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * Create new random inbox
    * Returns an Inbox with an &#x60;id&#x60; and an &#x60;emailAddress&#x60;
    * @param allowTeamAccess allowTeamAccess (optional)
    * @param description description (optional)
    * @param emailAddress emailAddress (optional)
    * @param expiresAt expiresAt (optional)
    * @param expiresIn expiresIn (optional)
    * @param favourite favourite (optional)
    * @param inboxType inboxType (optional)
    * @param name name (optional)
    * @param tags tags (optional)
    * @param useDomainPool useDomainPool (optional)
    * @return Inbox
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun createNewEmailAddress1(allowTeamAccess: kotlin.Boolean?, description: kotlin.String?, emailAddress: kotlin.String?, expiresAt: java.time.OffsetDateTime?, expiresIn: kotlin.Long?, favourite: kotlin.Boolean?, inboxType: kotlin.String?, name: kotlin.String?, tags: kotlin.collections.List<kotlin.String>?, useDomainPool: kotlin.Boolean?) : Inbox {
        val localVariableConfig = createNewEmailAddress1RequestConfig(allowTeamAccess = allowTeamAccess, description = description, emailAddress = emailAddress, expiresAt = expiresAt, expiresIn = expiresIn, favourite = favourite, inboxType = inboxType, name = name, tags = tags, useDomainPool = useDomainPool)

        val localVarResponse = request<Inbox>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as Inbox
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation createNewEmailAddress1
    *
    * @param allowTeamAccess allowTeamAccess (optional)
    * @param description description (optional)
    * @param emailAddress emailAddress (optional)
    * @param expiresAt expiresAt (optional)
    * @param expiresIn expiresIn (optional)
    * @param favourite favourite (optional)
    * @param inboxType inboxType (optional)
    * @param name name (optional)
    * @param tags tags (optional)
    * @param useDomainPool useDomainPool (optional)
    * @return RequestConfig
    */
    fun createNewEmailAddress1RequestConfig(allowTeamAccess: kotlin.Boolean?, description: kotlin.String?, emailAddress: kotlin.String?, expiresAt: java.time.OffsetDateTime?, expiresIn: kotlin.Long?, favourite: kotlin.Boolean?, inboxType: kotlin.String?, name: kotlin.String?, tags: kotlin.collections.List<kotlin.String>?, useDomainPool: kotlin.Boolean?) : RequestConfig {
        val localVariableBody: kotlin.Any? = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                if (allowTeamAccess != null) {
                    put("allowTeamAccess", listOf(allowTeamAccess.toString()))
                }
                if (description != null) {
                    put("description", listOf(description.toString()))
                }
                if (emailAddress != null) {
                    put("emailAddress", listOf(emailAddress.toString()))
                }
                if (expiresAt != null) {
                    put("expiresAt", listOf(parseDateToQueryString(expiresAt)))
                }
                if (expiresIn != null) {
                    put("expiresIn", listOf(expiresIn.toString()))
                }
                if (favourite != null) {
                    put("favourite", listOf(favourite.toString()))
                }
                if (inboxType != null) {
                    put("inboxType", listOf(inboxType.toString()))
                }
                if (name != null) {
                    put("name", listOf(name.toString()))
                }
                if (tags != null) {
                    put("tags", toMultiValue(tags.toList(), "multi"))
                }
                if (useDomainPool != null) {
                    put("useDomainPool", listOf(useDomainPool.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.POST,
            path = "/newEmailAddress",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * Delete all emails in an inbox
    * Deletes all emails
    * @param inboxId inboxId 
    * @return void
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun emptyInbox(inboxId: java.util.UUID) : Unit {
        val localVariableConfig = emptyInboxRequestConfig(inboxId = inboxId)

        val localVarResponse = request<Any?>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> Unit
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation emptyInbox
    *
    * @param inboxId inboxId 
    * @return RequestConfig
    */
    fun emptyInboxRequestConfig(inboxId: java.util.UUID) : RequestConfig {
        val localVariableBody: kotlin.Any? = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                put("inboxId", listOf(inboxId.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.DELETE,
            path = "/emptyInbox",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * Send an email
    * If no senderId or inboxId provided a random email address will be used to send from.
    * @param emailOptions emailOptions 
    * @return void
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun sendEmailSimple(emailOptions: SimpleSendEmailOptions) : Unit {
        val localVariableConfig = sendEmailSimpleRequestConfig(emailOptions = emailOptions)

        val localVarResponse = request<Any?>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> Unit
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation sendEmailSimple
    *
    * @param emailOptions emailOptions 
    * @return RequestConfig
    */
    fun sendEmailSimpleRequestConfig(emailOptions: SimpleSendEmailOptions) : RequestConfig {
        val localVariableBody: kotlin.Any? = emailOptions
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.POST,
            path = "/sendEmail",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

}
