/**
* MailSlurp API
* MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
*
* The version of the OpenAPI document: 6.5.2
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
package com.mailslurp.apis

import com.mailslurp.models.CreateInboxDto
import com.mailslurp.models.CreateInboxRulesetOptions
import com.mailslurp.models.EmailPreview
import com.mailslurp.models.FlushExpiredInboxesResult
import com.mailslurp.models.Inbox
import com.mailslurp.models.InboxExistsDto
import com.mailslurp.models.InboxRulesetDto
import com.mailslurp.models.PageEmailPreview
import com.mailslurp.models.PageInboxProjection
import com.mailslurp.models.PageInboxRulesetDto
import com.mailslurp.models.PageOrganizationInboxProjection
import com.mailslurp.models.PageSentEmailProjection
import com.mailslurp.models.PageTrackingPixelProjection
import com.mailslurp.models.SendEmailOptions
import com.mailslurp.models.SentEmailDto
import com.mailslurp.models.SetInboxFavouritedOptions
import com.mailslurp.models.UpdateInboxOptions

import com.mailslurp.infrastructure.ApiClient
import com.mailslurp.infrastructure.ClientException
import com.mailslurp.infrastructure.ClientError
import com.mailslurp.infrastructure.ServerException
import com.mailslurp.infrastructure.ServerError
import com.mailslurp.infrastructure.MultiValueMap
import com.mailslurp.infrastructure.RequestConfig
import com.mailslurp.infrastructure.RequestMethod
import com.mailslurp.infrastructure.ResponseType
import com.mailslurp.infrastructure.Success
import com.mailslurp.infrastructure.toMultiValue

class InboxControllerApi(private val xApiKey: kotlin.String, basePath: kotlin.String = defaultBasePath) : ApiClient(basePath) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty("com.mailslurp.baseUrl", "https://api.mailslurp.com")
        }
    }

    /**
    * Create an inbox email address. An inbox has a real email address and can send and receive emails. Inboxes can be either &#x60;SMTP&#x60; or &#x60;HTTP&#x60; inboxes.
    * Create a new inbox and with a randomized email address to send and receive from. Pass emailAddress parameter if you wish to use a specific email address. Creating an inbox is required before sending or receiving emails. If writing tests it is recommended that you create a new inbox during each test method so that it is unique and empty. 
    * @param allowTeamAccess DEPRECATED (team access is always true). Grant team access to this inbox and the emails that belong to it for team members of your organization. (optional)
    * @param description Optional description of the inbox for labelling purposes. Is shown in the dashboard and can be used with (optional)
    * @param emailAddress A custom email address to use with the inbox. Defaults to null. When null MailSlurp will assign a random email address to the inbox such as &#x60;123@mailslurp.com&#x60;. If you use the &#x60;useDomainPool&#x60; option when the email address is null it will generate an email address with a more varied domain ending such as &#x60;123@mailslurp.info&#x60; or &#x60;123@mailslurp.biz&#x60;. When a custom email address is provided the address is split into a domain and the domain is queried against your user. If you have created the domain in the MailSlurp dashboard and verified it you can use any email address that ends with the domain. Note domain types must match the inbox type - so &#x60;SMTP&#x60; inboxes will only work with &#x60;SMTP&#x60; type domains. Avoid &#x60;SMTP&#x60; inboxes if you need to send emails as they can only receive. Send an email to this address and the inbox will receive and store it for you. To retrieve the email use the Inbox and Email Controller endpoints with the inbox ID. (optional)
    * @param expiresAt Optional inbox expiration date. If null then this inbox is permanent and the emails in it won&#39;t be deleted. If an expiration date is provided or is required by your plan the inbox will be closed when the expiration time is reached. Expired inboxes still contain their emails but can no longer send or receive emails. An ExpiredInboxRecord is created when an inbox and the email address and inbox ID are recorded. The expiresAt property is a timestamp string in ISO DateTime Format yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSXXX. (optional)
    * @param expiresIn Number of milliseconds that inbox should exist for (optional)
    * @param favourite Is the inbox a favorite. Marking an inbox as a favorite is typically done in the dashboard for quick access or filtering (optional)
    * @param inboxType HTTP (default) or SMTP inbox type. HTTP inboxes are default and best solution for most cases. SMTP inboxes are more reliable for public inbound email consumption (but do not support sending emails). When using custom domains the domain type must match the inbox type. HTTP inboxes are processed by AWS SES while SMTP inboxes use a custom mail server running at &#x60;mx.mailslurp.com&#x60;. (optional)
    * @param name Optional name of the inbox. Displayed in the dashboard for easier search and used as the sender name when sending emails. (optional)
    * @param tags Tags that inbox has been tagged with. Tags can be added to inboxes to group different inboxes within an account. You can also search for inboxes by tag in the dashboard UI. (optional)
    * @param useDomainPool Use the MailSlurp domain name pool with this inbox when creating the email address. Defaults to null. If enabled the inbox will be an email address with a domain randomly chosen from a list of the MailSlurp domains. This is useful when the default &#x60;@mailslurp.com&#x60; email addresses used with inboxes are blocked or considered spam by a provider or receiving service. When domain pool is enabled an email address will be generated ending in &#x60;@mailslurp.{world,info,xyz,...}&#x60; . This means a TLD is randomly selecting from a list of &#x60;.biz&#x60;, &#x60;.info&#x60;, &#x60;.xyz&#x60; etc to add variance to the generated email addresses. When null or false MailSlurp uses the default behavior of &#x60;@mailslurp.com&#x60; or custom email address provided by the emailAddress field. Note this feature is only available for &#x60;HTTP&#x60; inbox types. (optional)
    * @return Inbox
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun createInbox(allowTeamAccess: kotlin.Boolean?, description: kotlin.String?, emailAddress: kotlin.String?, expiresAt: java.time.OffsetDateTime?, expiresIn: kotlin.Long?, favourite: kotlin.Boolean?, inboxType: kotlin.String?, name: kotlin.String?, tags: kotlin.collections.List<kotlin.String>?, useDomainPool: kotlin.Boolean?) : Inbox {
        val localVariableConfig = createInboxRequestConfig(allowTeamAccess = allowTeamAccess, description = description, emailAddress = emailAddress, expiresAt = expiresAt, expiresIn = expiresIn, favourite = favourite, inboxType = inboxType, name = name, tags = tags, useDomainPool = useDomainPool)

        val localVarResponse = request<Inbox>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as Inbox
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation createInbox
    *
    * @param allowTeamAccess DEPRECATED (team access is always true). Grant team access to this inbox and the emails that belong to it for team members of your organization. (optional)
    * @param description Optional description of the inbox for labelling purposes. Is shown in the dashboard and can be used with (optional)
    * @param emailAddress A custom email address to use with the inbox. Defaults to null. When null MailSlurp will assign a random email address to the inbox such as &#x60;123@mailslurp.com&#x60;. If you use the &#x60;useDomainPool&#x60; option when the email address is null it will generate an email address with a more varied domain ending such as &#x60;123@mailslurp.info&#x60; or &#x60;123@mailslurp.biz&#x60;. When a custom email address is provided the address is split into a domain and the domain is queried against your user. If you have created the domain in the MailSlurp dashboard and verified it you can use any email address that ends with the domain. Note domain types must match the inbox type - so &#x60;SMTP&#x60; inboxes will only work with &#x60;SMTP&#x60; type domains. Avoid &#x60;SMTP&#x60; inboxes if you need to send emails as they can only receive. Send an email to this address and the inbox will receive and store it for you. To retrieve the email use the Inbox and Email Controller endpoints with the inbox ID. (optional)
    * @param expiresAt Optional inbox expiration date. If null then this inbox is permanent and the emails in it won&#39;t be deleted. If an expiration date is provided or is required by your plan the inbox will be closed when the expiration time is reached. Expired inboxes still contain their emails but can no longer send or receive emails. An ExpiredInboxRecord is created when an inbox and the email address and inbox ID are recorded. The expiresAt property is a timestamp string in ISO DateTime Format yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSXXX. (optional)
    * @param expiresIn Number of milliseconds that inbox should exist for (optional)
    * @param favourite Is the inbox a favorite. Marking an inbox as a favorite is typically done in the dashboard for quick access or filtering (optional)
    * @param inboxType HTTP (default) or SMTP inbox type. HTTP inboxes are default and best solution for most cases. SMTP inboxes are more reliable for public inbound email consumption (but do not support sending emails). When using custom domains the domain type must match the inbox type. HTTP inboxes are processed by AWS SES while SMTP inboxes use a custom mail server running at &#x60;mx.mailslurp.com&#x60;. (optional)
    * @param name Optional name of the inbox. Displayed in the dashboard for easier search and used as the sender name when sending emails. (optional)
    * @param tags Tags that inbox has been tagged with. Tags can be added to inboxes to group different inboxes within an account. You can also search for inboxes by tag in the dashboard UI. (optional)
    * @param useDomainPool Use the MailSlurp domain name pool with this inbox when creating the email address. Defaults to null. If enabled the inbox will be an email address with a domain randomly chosen from a list of the MailSlurp domains. This is useful when the default &#x60;@mailslurp.com&#x60; email addresses used with inboxes are blocked or considered spam by a provider or receiving service. When domain pool is enabled an email address will be generated ending in &#x60;@mailslurp.{world,info,xyz,...}&#x60; . This means a TLD is randomly selecting from a list of &#x60;.biz&#x60;, &#x60;.info&#x60;, &#x60;.xyz&#x60; etc to add variance to the generated email addresses. When null or false MailSlurp uses the default behavior of &#x60;@mailslurp.com&#x60; or custom email address provided by the emailAddress field. Note this feature is only available for &#x60;HTTP&#x60; inbox types. (optional)
    * @return RequestConfig
    */
    fun createInboxRequestConfig(allowTeamAccess: kotlin.Boolean?, description: kotlin.String?, emailAddress: kotlin.String?, expiresAt: java.time.OffsetDateTime?, expiresIn: kotlin.Long?, favourite: kotlin.Boolean?, inboxType: kotlin.String?, name: kotlin.String?, tags: kotlin.collections.List<kotlin.String>?, useDomainPool: kotlin.Boolean?) : RequestConfig {
        val localVariableBody: kotlin.Any? = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                if (allowTeamAccess != null) {
                    put("allowTeamAccess", listOf(allowTeamAccess.toString()))
                }
                if (description != null) {
                    put("description", listOf(description.toString()))
                }
                if (emailAddress != null) {
                    put("emailAddress", listOf(emailAddress.toString()))
                }
                if (expiresAt != null) {
                    put("expiresAt", listOf(parseDateToQueryString(expiresAt)))
                }
                if (expiresIn != null) {
                    put("expiresIn", listOf(expiresIn.toString()))
                }
                if (favourite != null) {
                    put("favourite", listOf(favourite.toString()))
                }
                if (inboxType != null) {
                    put("inboxType", listOf(inboxType.toString()))
                }
                if (name != null) {
                    put("name", listOf(name.toString()))
                }
                if (tags != null) {
                    put("tags", toMultiValue(tags.toList(), "multi"))
                }
                if (useDomainPool != null) {
                    put("useDomainPool", listOf(useDomainPool.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.POST,
            path = "/inboxes",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * Create an inbox ruleset
    * Create a new inbox rule for forwarding, blocking, and allowing emails when sending and receiving
    * @param inboxId inboxId 
    * @param createInboxRulesetOptions createInboxRulesetOptions 
    * @return InboxRulesetDto
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun createInboxRuleset(inboxId: java.util.UUID, createInboxRulesetOptions: CreateInboxRulesetOptions) : InboxRulesetDto {
        val localVariableConfig = createInboxRulesetRequestConfig(inboxId = inboxId, createInboxRulesetOptions = createInboxRulesetOptions)

        val localVarResponse = request<InboxRulesetDto>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as InboxRulesetDto
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation createInboxRuleset
    *
    * @param inboxId inboxId 
    * @param createInboxRulesetOptions createInboxRulesetOptions 
    * @return RequestConfig
    */
    fun createInboxRulesetRequestConfig(inboxId: java.util.UUID, createInboxRulesetOptions: CreateInboxRulesetOptions) : RequestConfig {
        val localVariableBody: kotlin.Any? = createInboxRulesetOptions
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.POST,
            path = "/inboxes/{inboxId}/rulesets".replace("{"+"inboxId"+"}", "$inboxId"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * Create an inbox with default options. Uses MailSlurp domain pool address and is private.
    * 
    * @return Inbox
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun createInboxWithDefaults() : Inbox {
        val localVariableConfig = createInboxWithDefaultsRequestConfig()

        val localVarResponse = request<Inbox>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as Inbox
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation createInboxWithDefaults
    *
    * @return RequestConfig
    */
    fun createInboxWithDefaultsRequestConfig() : RequestConfig {
        val localVariableBody: kotlin.Any? = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.POST,
            path = "/inboxes/withDefaults",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * Create an inbox with options. Extended options for inbox creation.
    * Additional endpoint that allows inbox creation with request body options. Can be more flexible that other methods for some clients.
    * @param createInboxDto createInboxDto 
    * @return Inbox
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun createInboxWithOptions(createInboxDto: CreateInboxDto) : Inbox {
        val localVariableConfig = createInboxWithOptionsRequestConfig(createInboxDto = createInboxDto)

        val localVarResponse = request<Inbox>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as Inbox
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation createInboxWithOptions
    *
    * @param createInboxDto createInboxDto 
    * @return RequestConfig
    */
    fun createInboxWithOptionsRequestConfig(createInboxDto: CreateInboxDto) : RequestConfig {
        val localVariableBody: kotlin.Any? = createInboxDto
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.POST,
            path = "/inboxes/withOptions",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * Delete all inboxes
    * Permanently delete all inboxes and associated email addresses. This will also delete all emails within the inboxes. Be careful as inboxes cannot be recovered once deleted. Note: deleting inboxes will not impact your usage limits. Monthly inbox creation limits are based on how many inboxes were created in the last 30 days, not how many inboxes you currently have.
    * @return void
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun deleteAllInboxes() : Unit {
        val localVariableConfig = deleteAllInboxesRequestConfig()

        val localVarResponse = request<Any?>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> Unit
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation deleteAllInboxes
    *
    * @return RequestConfig
    */
    fun deleteAllInboxesRequestConfig() : RequestConfig {
        val localVariableBody: kotlin.Any? = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.DELETE,
            path = "/inboxes",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * Delete inbox
    * Permanently delete an inbox and associated email address as well as all emails within the given inbox. This action cannot be undone. Note: deleting an inbox will not affect your account usage. Monthly inbox usage is based on how many inboxes you create within 30 days, not how many exist at time of request.
    * @param inboxId inboxId 
    * @return void
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun deleteInbox(inboxId: java.util.UUID) : Unit {
        val localVariableConfig = deleteInboxRequestConfig(inboxId = inboxId)

        val localVarResponse = request<Any?>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> Unit
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation deleteInbox
    *
    * @param inboxId inboxId 
    * @return RequestConfig
    */
    fun deleteInboxRequestConfig(inboxId: java.util.UUID) : RequestConfig {
        val localVariableBody: kotlin.Any? = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.DELETE,
            path = "/inboxes/{inboxId}".replace("{"+"inboxId"+"}", "$inboxId"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * Does inbox exist
    * Check if inboxes exist by email address. Useful if you are sending emails to mailslurp addresses
    * @param emailAddress Email address 
    * @return InboxExistsDto
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun doesInboxExist(emailAddress: kotlin.String) : InboxExistsDto {
        val localVariableConfig = doesInboxExistRequestConfig(emailAddress = emailAddress)

        val localVarResponse = request<InboxExistsDto>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as InboxExistsDto
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation doesInboxExist
    *
    * @param emailAddress Email address 
    * @return RequestConfig
    */
    fun doesInboxExistRequestConfig(emailAddress: kotlin.String) : RequestConfig {
        val localVariableBody: kotlin.Any? = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                put("emailAddress", listOf(emailAddress.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.GET,
            path = "/inboxes/exists",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * Remove expired inboxes
    * Remove any expired inboxes for your account (instead of waiting for scheduled removal on server)
    * @param before Optional expired at before flag to flush expired inboxes that have expired before the given time (optional)
    * @return FlushExpiredInboxesResult
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun flushExpired(before: java.time.OffsetDateTime?) : FlushExpiredInboxesResult {
        val localVariableConfig = flushExpiredRequestConfig(before = before)

        val localVarResponse = request<FlushExpiredInboxesResult>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as FlushExpiredInboxesResult
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation flushExpired
    *
    * @param before Optional expired at before flag to flush expired inboxes that have expired before the given time (optional)
    * @return RequestConfig
    */
    fun flushExpiredRequestConfig(before: java.time.OffsetDateTime?) : RequestConfig {
        val localVariableBody: kotlin.Any? = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                if (before != null) {
                    put("before", listOf(parseDateToQueryString(before)))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.DELETE,
            path = "/inboxes/expired",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * List All Inboxes Paginated
    * List inboxes in paginated form. The results are available on the &#x60;content&#x60; property of the returned object. This method allows for page index (zero based), page size (how many results to return), and a sort direction (based on createdAt time). You Can also filter by whether an inbox is favorited or use email address pattern. This method is the recommended way to query inboxes. The alternative &#x60;getInboxes&#x60; method returns a full list of inboxes but is limited to 100 results.
    * @param before Optional filter by created before given date time (optional)
    * @param favourite Optionally filter results for favourites only (optional, default to false)
    * @param page Optional page index in list pagination (optional, default to 0)
    * @param search Optionally filter by search words partial matching ID, tags, name, and email address (optional)
    * @param since Optional filter by created after given date time (optional)
    * @param size Optional page size in list pagination (optional, default to 20)
    * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
    * @param tag Optionally filter by tags. Will return inboxes that include given tags (optional)
    * @param teamAccess DEPRECATED. Optionally filter by team access. (optional, default to false)
    * @return PageInboxProjection
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun getAllInboxes(before: java.time.OffsetDateTime?, favourite: kotlin.Boolean?, page: kotlin.Int?, search: kotlin.String?, since: java.time.OffsetDateTime?, size: kotlin.Int?, sort: kotlin.String?, tag: kotlin.String?, teamAccess: kotlin.Boolean?) : PageInboxProjection {
        val localVariableConfig = getAllInboxesRequestConfig(before = before, favourite = favourite, page = page, search = search, since = since, size = size, sort = sort, tag = tag, teamAccess = teamAccess)

        val localVarResponse = request<PageInboxProjection>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as PageInboxProjection
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation getAllInboxes
    *
    * @param before Optional filter by created before given date time (optional)
    * @param favourite Optionally filter results for favourites only (optional, default to false)
    * @param page Optional page index in list pagination (optional, default to 0)
    * @param search Optionally filter by search words partial matching ID, tags, name, and email address (optional)
    * @param since Optional filter by created after given date time (optional)
    * @param size Optional page size in list pagination (optional, default to 20)
    * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
    * @param tag Optionally filter by tags. Will return inboxes that include given tags (optional)
    * @param teamAccess DEPRECATED. Optionally filter by team access. (optional, default to false)
    * @return RequestConfig
    */
    fun getAllInboxesRequestConfig(before: java.time.OffsetDateTime?, favourite: kotlin.Boolean?, page: kotlin.Int?, search: kotlin.String?, since: java.time.OffsetDateTime?, size: kotlin.Int?, sort: kotlin.String?, tag: kotlin.String?, teamAccess: kotlin.Boolean?) : RequestConfig {
        val localVariableBody: kotlin.Any? = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                if (before != null) {
                    put("before", listOf(parseDateToQueryString(before)))
                }
                if (favourite != null) {
                    put("favourite", listOf(favourite.toString()))
                }
                if (page != null) {
                    put("page", listOf(page.toString()))
                }
                if (search != null) {
                    put("search", listOf(search.toString()))
                }
                if (since != null) {
                    put("since", listOf(parseDateToQueryString(since)))
                }
                if (size != null) {
                    put("size", listOf(size.toString()))
                }
                if (sort != null) {
                    put("sort", listOf(sort.toString()))
                }
                if (tag != null) {
                    put("tag", listOf(tag.toString()))
                }
                if (teamAccess != null) {
                    put("teamAccess", listOf(teamAccess.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.GET,
            path = "/inboxes/paginated",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * Get emails in an Inbox. This method is not idempotent as it allows retries and waits if you want certain conditions to be met before returning. For simple listing and sorting of known emails use the email controller instead.
    * List emails that an inbox has received. Only emails that are sent to the inbox&#39;s email address will appear in the inbox. It may take several seconds for any email you send to an inbox&#39;s email address to appear in the inbox. To make this endpoint wait for a minimum number of emails use the &#x60;minCount&#x60; parameter. The server will retry the inbox database until the &#x60;minCount&#x60; is satisfied or the &#x60;retryTimeout&#x60; is reached
    * @param inboxId Id of inbox that emails belongs to 
    * @param before Exclude emails received after this ISO 8601 date time (optional)
    * @param delayTimeout delayTimeout (optional)
    * @param limit Limit the result set, ordered by received date time sort direction. Maximum 100. For more listing options see the email controller (optional)
    * @param minCount Minimum acceptable email count. Will cause request to hang (and retry) until minCount is satisfied or retryTimeout is reached. (optional)
    * @param retryTimeout Maximum milliseconds to spend retrying inbox database until minCount emails are returned (optional)
    * @param since Exclude emails received before this ISO 8601 date time (optional)
    * @param size Alias for limit. Assessed first before assessing any passed limit. (optional)
    * @param sort Sort the results by received date and direction ASC or DESC (optional)
    * @param unreadOnly unreadOnly (optional)
    * @return kotlin.collections.List<EmailPreview>
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun getEmails(inboxId: java.util.UUID, before: java.time.OffsetDateTime?, delayTimeout: kotlin.Long?, limit: kotlin.Int?, minCount: kotlin.Long?, retryTimeout: kotlin.Long?, since: java.time.OffsetDateTime?, size: kotlin.Int?, sort: kotlin.String?, unreadOnly: kotlin.Boolean?) : kotlin.collections.List<EmailPreview> {
        val localVariableConfig = getEmailsRequestConfig(inboxId = inboxId, before = before, delayTimeout = delayTimeout, limit = limit, minCount = minCount, retryTimeout = retryTimeout, since = since, size = size, sort = sort, unreadOnly = unreadOnly)

        val localVarResponse = request<kotlin.collections.List<EmailPreview>>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.collections.List<EmailPreview>
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation getEmails
    *
    * @param inboxId Id of inbox that emails belongs to 
    * @param before Exclude emails received after this ISO 8601 date time (optional)
    * @param delayTimeout delayTimeout (optional)
    * @param limit Limit the result set, ordered by received date time sort direction. Maximum 100. For more listing options see the email controller (optional)
    * @param minCount Minimum acceptable email count. Will cause request to hang (and retry) until minCount is satisfied or retryTimeout is reached. (optional)
    * @param retryTimeout Maximum milliseconds to spend retrying inbox database until minCount emails are returned (optional)
    * @param since Exclude emails received before this ISO 8601 date time (optional)
    * @param size Alias for limit. Assessed first before assessing any passed limit. (optional)
    * @param sort Sort the results by received date and direction ASC or DESC (optional)
    * @param unreadOnly unreadOnly (optional)
    * @return RequestConfig
    */
    fun getEmailsRequestConfig(inboxId: java.util.UUID, before: java.time.OffsetDateTime?, delayTimeout: kotlin.Long?, limit: kotlin.Int?, minCount: kotlin.Long?, retryTimeout: kotlin.Long?, since: java.time.OffsetDateTime?, size: kotlin.Int?, sort: kotlin.String?, unreadOnly: kotlin.Boolean?) : RequestConfig {
        val localVariableBody: kotlin.Any? = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                if (before != null) {
                    put("before", listOf(parseDateToQueryString(before)))
                }
                if (delayTimeout != null) {
                    put("delayTimeout", listOf(delayTimeout.toString()))
                }
                if (limit != null) {
                    put("limit", listOf(limit.toString()))
                }
                if (minCount != null) {
                    put("minCount", listOf(minCount.toString()))
                }
                if (retryTimeout != null) {
                    put("retryTimeout", listOf(retryTimeout.toString()))
                }
                if (since != null) {
                    put("since", listOf(parseDateToQueryString(since)))
                }
                if (size != null) {
                    put("size", listOf(size.toString()))
                }
                if (sort != null) {
                    put("sort", listOf(sort.toString()))
                }
                if (unreadOnly != null) {
                    put("unreadOnly", listOf(unreadOnly.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.GET,
            path = "/inboxes/{inboxId}/emails".replace("{"+"inboxId"+"}", "$inboxId"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * Get Inbox. Returns properties of an inbox.
    * Returns an inbox&#39;s properties, including its email address and ID.
    * @param inboxId inboxId 
    * @return Inbox
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun getInbox(inboxId: java.util.UUID) : Inbox {
        val localVariableConfig = getInboxRequestConfig(inboxId = inboxId)

        val localVarResponse = request<Inbox>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as Inbox
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation getInbox
    *
    * @param inboxId inboxId 
    * @return RequestConfig
    */
    fun getInboxRequestConfig(inboxId: java.util.UUID) : RequestConfig {
        val localVariableBody: kotlin.Any? = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.GET,
            path = "/inboxes/{inboxId}".replace("{"+"inboxId"+"}", "$inboxId"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * Get inbox emails paginated
    * Get a paginated list of emails in an inbox. Does not hold connections open.
    * @param inboxId Id of inbox that emails belongs to 
    * @param before Optional filter by received before given date time (optional)
    * @param page Optional page index in inbox emails list pagination (optional, default to 0)
    * @param since Optional filter by received after given date time (optional)
    * @param size Optional page size in inbox emails list pagination (optional, default to 20)
    * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
    * @return PageEmailPreview
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun getInboxEmailsPaginated(inboxId: java.util.UUID, before: java.time.OffsetDateTime?, page: kotlin.Int?, since: java.time.OffsetDateTime?, size: kotlin.Int?, sort: kotlin.String?) : PageEmailPreview {
        val localVariableConfig = getInboxEmailsPaginatedRequestConfig(inboxId = inboxId, before = before, page = page, since = since, size = size, sort = sort)

        val localVarResponse = request<PageEmailPreview>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as PageEmailPreview
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation getInboxEmailsPaginated
    *
    * @param inboxId Id of inbox that emails belongs to 
    * @param before Optional filter by received before given date time (optional)
    * @param page Optional page index in inbox emails list pagination (optional, default to 0)
    * @param since Optional filter by received after given date time (optional)
    * @param size Optional page size in inbox emails list pagination (optional, default to 20)
    * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
    * @return RequestConfig
    */
    fun getInboxEmailsPaginatedRequestConfig(inboxId: java.util.UUID, before: java.time.OffsetDateTime?, page: kotlin.Int?, since: java.time.OffsetDateTime?, size: kotlin.Int?, sort: kotlin.String?) : RequestConfig {
        val localVariableBody: kotlin.Any? = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                if (before != null) {
                    put("before", listOf(parseDateToQueryString(before)))
                }
                if (page != null) {
                    put("page", listOf(page.toString()))
                }
                if (since != null) {
                    put("since", listOf(parseDateToQueryString(since)))
                }
                if (size != null) {
                    put("size", listOf(size.toString()))
                }
                if (sort != null) {
                    put("sort", listOf(sort.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.GET,
            path = "/inboxes/{inboxId}/emails/paginated".replace("{"+"inboxId"+"}", "$inboxId"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * Get Inbox Sent Emails
    * Returns an inbox&#39;s sent email receipts. Call individual sent email endpoints for more details. Note for privacy reasons the full body of sent emails is never stored. An MD5 hash hex is available for comparison instead.
    * @param inboxId inboxId 
    * @param before Optional filter by sent before given date time (optional)
    * @param page Optional page index in inbox sent email list pagination (optional, default to 0)
    * @param searchFilter Optional sent email search (optional)
    * @param since Optional filter by sent after given date time (optional)
    * @param size Optional page size in inbox sent email list pagination (optional, default to 20)
    * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
    * @return PageSentEmailProjection
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun getInboxSentEmails(inboxId: java.util.UUID, before: java.time.OffsetDateTime?, page: kotlin.Int?, searchFilter: kotlin.String?, since: java.time.OffsetDateTime?, size: kotlin.Int?, sort: kotlin.String?) : PageSentEmailProjection {
        val localVariableConfig = getInboxSentEmailsRequestConfig(inboxId = inboxId, before = before, page = page, searchFilter = searchFilter, since = since, size = size, sort = sort)

        val localVarResponse = request<PageSentEmailProjection>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as PageSentEmailProjection
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation getInboxSentEmails
    *
    * @param inboxId inboxId 
    * @param before Optional filter by sent before given date time (optional)
    * @param page Optional page index in inbox sent email list pagination (optional, default to 0)
    * @param searchFilter Optional sent email search (optional)
    * @param since Optional filter by sent after given date time (optional)
    * @param size Optional page size in inbox sent email list pagination (optional, default to 20)
    * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
    * @return RequestConfig
    */
    fun getInboxSentEmailsRequestConfig(inboxId: java.util.UUID, before: java.time.OffsetDateTime?, page: kotlin.Int?, searchFilter: kotlin.String?, since: java.time.OffsetDateTime?, size: kotlin.Int?, sort: kotlin.String?) : RequestConfig {
        val localVariableBody: kotlin.Any? = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                if (before != null) {
                    put("before", listOf(parseDateToQueryString(before)))
                }
                if (page != null) {
                    put("page", listOf(page.toString()))
                }
                if (searchFilter != null) {
                    put("searchFilter", listOf(searchFilter.toString()))
                }
                if (since != null) {
                    put("since", listOf(parseDateToQueryString(since)))
                }
                if (size != null) {
                    put("size", listOf(size.toString()))
                }
                if (sort != null) {
                    put("sort", listOf(sort.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.GET,
            path = "/inboxes/{inboxId}/sent".replace("{"+"inboxId"+"}", "$inboxId"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * Get inbox tags
    * Get all inbox tags
    * @return kotlin.collections.List<kotlin.String>
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun getInboxTags() : kotlin.collections.List<kotlin.String> {
        val localVariableConfig = getInboxTagsRequestConfig()

        val localVarResponse = request<kotlin.collections.List<kotlin.String>>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.collections.List<kotlin.String>
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation getInboxTags
    *
    * @return RequestConfig
    */
    fun getInboxTagsRequestConfig() : RequestConfig {
        val localVariableBody: kotlin.Any? = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.GET,
            path = "/inboxes/tags",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * List Inboxes and email addresses
    * List the inboxes you have created. Note use of the more advanced &#x60;getAllEmails&#x60; is recommended and allows paginated access using a limit and sort parameter.
    * @param before Optional filter by created before given date time (optional)
    * @param since Optional filter by created after given date time (optional)
    * @param size Optional result size limit. Note an automatic limit of 100 results is applied. See the paginated &#x60;getAllEmails&#x60; for larger queries. (optional, default to 100)
    * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
    * @return kotlin.collections.List<Inbox>
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun getInboxes(before: java.time.OffsetDateTime?, since: java.time.OffsetDateTime?, size: kotlin.Int?, sort: kotlin.String?) : kotlin.collections.List<Inbox> {
        val localVariableConfig = getInboxesRequestConfig(before = before, since = since, size = size, sort = sort)

        val localVarResponse = request<kotlin.collections.List<Inbox>>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.collections.List<Inbox>
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation getInboxes
    *
    * @param before Optional filter by created before given date time (optional)
    * @param since Optional filter by created after given date time (optional)
    * @param size Optional result size limit. Note an automatic limit of 100 results is applied. See the paginated &#x60;getAllEmails&#x60; for larger queries. (optional, default to 100)
    * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
    * @return RequestConfig
    */
    fun getInboxesRequestConfig(before: java.time.OffsetDateTime?, since: java.time.OffsetDateTime?, size: kotlin.Int?, sort: kotlin.String?) : RequestConfig {
        val localVariableBody: kotlin.Any? = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                if (before != null) {
                    put("before", listOf(parseDateToQueryString(before)))
                }
                if (since != null) {
                    put("since", listOf(parseDateToQueryString(since)))
                }
                if (size != null) {
                    put("size", listOf(size.toString()))
                }
                if (sort != null) {
                    put("sort", listOf(sort.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.GET,
            path = "/inboxes",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * List Organization Inboxes Paginated
    * List organization inboxes in paginated form. These are inboxes created with &#x60;allowTeamAccess&#x60; flag enabled. Organization inboxes are &#x60;readOnly&#x60; for non-admin users. The results are available on the &#x60;content&#x60; property of the returned object. This method allows for page index (zero based), page size (how many results to return), and a sort direction (based on createdAt time). 
    * @param before Optional filter by created before given date time (optional)
    * @param page Optional page index in list pagination (optional, default to 0)
    * @param searchFilter Optional search filter (optional)
    * @param since Optional filter by created after given date time (optional)
    * @param size Optional page size in list pagination (optional, default to 20)
    * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
    * @return PageOrganizationInboxProjection
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun getOrganizationInboxes(before: java.time.OffsetDateTime?, page: kotlin.Int?, searchFilter: kotlin.String?, since: java.time.OffsetDateTime?, size: kotlin.Int?, sort: kotlin.String?) : PageOrganizationInboxProjection {
        val localVariableConfig = getOrganizationInboxesRequestConfig(before = before, page = page, searchFilter = searchFilter, since = since, size = size, sort = sort)

        val localVarResponse = request<PageOrganizationInboxProjection>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as PageOrganizationInboxProjection
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation getOrganizationInboxes
    *
    * @param before Optional filter by created before given date time (optional)
    * @param page Optional page index in list pagination (optional, default to 0)
    * @param searchFilter Optional search filter (optional)
    * @param since Optional filter by created after given date time (optional)
    * @param size Optional page size in list pagination (optional, default to 20)
    * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
    * @return RequestConfig
    */
    fun getOrganizationInboxesRequestConfig(before: java.time.OffsetDateTime?, page: kotlin.Int?, searchFilter: kotlin.String?, since: java.time.OffsetDateTime?, size: kotlin.Int?, sort: kotlin.String?) : RequestConfig {
        val localVariableBody: kotlin.Any? = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                if (before != null) {
                    put("before", listOf(parseDateToQueryString(before)))
                }
                if (page != null) {
                    put("page", listOf(page.toString()))
                }
                if (searchFilter != null) {
                    put("searchFilter", listOf(searchFilter.toString()))
                }
                if (since != null) {
                    put("since", listOf(parseDateToQueryString(since)))
                }
                if (size != null) {
                    put("size", listOf(size.toString()))
                }
                if (sort != null) {
                    put("sort", listOf(sort.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.GET,
            path = "/inboxes/organization",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * List inbox rulesets
    * List all rulesets attached to an inbox
    * @param inboxId inboxId 
    * @param before Optional filter by created before given date time (optional)
    * @param page Optional page index in inbox ruleset list pagination (optional, default to 0)
    * @param searchFilter Optional search filter (optional)
    * @param since Optional filter by created after given date time (optional)
    * @param size Optional page size in inbox ruleset list pagination (optional, default to 20)
    * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
    * @return PageInboxRulesetDto
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun listInboxRulesets(inboxId: java.util.UUID, before: java.time.OffsetDateTime?, page: kotlin.Int?, searchFilter: kotlin.String?, since: java.time.OffsetDateTime?, size: kotlin.Int?, sort: kotlin.String?) : PageInboxRulesetDto {
        val localVariableConfig = listInboxRulesetsRequestConfig(inboxId = inboxId, before = before, page = page, searchFilter = searchFilter, since = since, size = size, sort = sort)

        val localVarResponse = request<PageInboxRulesetDto>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as PageInboxRulesetDto
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation listInboxRulesets
    *
    * @param inboxId inboxId 
    * @param before Optional filter by created before given date time (optional)
    * @param page Optional page index in inbox ruleset list pagination (optional, default to 0)
    * @param searchFilter Optional search filter (optional)
    * @param since Optional filter by created after given date time (optional)
    * @param size Optional page size in inbox ruleset list pagination (optional, default to 20)
    * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
    * @return RequestConfig
    */
    fun listInboxRulesetsRequestConfig(inboxId: java.util.UUID, before: java.time.OffsetDateTime?, page: kotlin.Int?, searchFilter: kotlin.String?, since: java.time.OffsetDateTime?, size: kotlin.Int?, sort: kotlin.String?) : RequestConfig {
        val localVariableBody: kotlin.Any? = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                if (before != null) {
                    put("before", listOf(parseDateToQueryString(before)))
                }
                if (page != null) {
                    put("page", listOf(page.toString()))
                }
                if (searchFilter != null) {
                    put("searchFilter", listOf(searchFilter.toString()))
                }
                if (since != null) {
                    put("since", listOf(parseDateToQueryString(since)))
                }
                if (size != null) {
                    put("size", listOf(size.toString()))
                }
                if (sort != null) {
                    put("sort", listOf(sort.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.GET,
            path = "/inboxes/{inboxId}/rulesets".replace("{"+"inboxId"+"}", "$inboxId"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * List inbox tracking pixels
    * List all tracking pixels sent from an inbox
    * @param inboxId inboxId 
    * @param before Optional filter by created before given date time (optional)
    * @param page Optional page index in inbox tracking pixel list pagination (optional, default to 0)
    * @param searchFilter Optional search filter (optional)
    * @param since Optional filter by created after given date time (optional)
    * @param size Optional page size in inbox tracking pixel list pagination (optional, default to 20)
    * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
    * @return PageTrackingPixelProjection
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun listInboxTrackingPixels(inboxId: java.util.UUID, before: java.time.OffsetDateTime?, page: kotlin.Int?, searchFilter: kotlin.String?, since: java.time.OffsetDateTime?, size: kotlin.Int?, sort: kotlin.String?) : PageTrackingPixelProjection {
        val localVariableConfig = listInboxTrackingPixelsRequestConfig(inboxId = inboxId, before = before, page = page, searchFilter = searchFilter, since = since, size = size, sort = sort)

        val localVarResponse = request<PageTrackingPixelProjection>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as PageTrackingPixelProjection
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation listInboxTrackingPixels
    *
    * @param inboxId inboxId 
    * @param before Optional filter by created before given date time (optional)
    * @param page Optional page index in inbox tracking pixel list pagination (optional, default to 0)
    * @param searchFilter Optional search filter (optional)
    * @param since Optional filter by created after given date time (optional)
    * @param size Optional page size in inbox tracking pixel list pagination (optional, default to 20)
    * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
    * @return RequestConfig
    */
    fun listInboxTrackingPixelsRequestConfig(inboxId: java.util.UUID, before: java.time.OffsetDateTime?, page: kotlin.Int?, searchFilter: kotlin.String?, since: java.time.OffsetDateTime?, size: kotlin.Int?, sort: kotlin.String?) : RequestConfig {
        val localVariableBody: kotlin.Any? = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                if (before != null) {
                    put("before", listOf(parseDateToQueryString(before)))
                }
                if (page != null) {
                    put("page", listOf(page.toString()))
                }
                if (searchFilter != null) {
                    put("searchFilter", listOf(searchFilter.toString()))
                }
                if (since != null) {
                    put("since", listOf(parseDateToQueryString(since)))
                }
                if (size != null) {
                    put("size", listOf(size.toString()))
                }
                if (sort != null) {
                    put("sort", listOf(sort.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.GET,
            path = "/inboxes/{inboxId}/tracking-pixels".replace("{"+"inboxId"+"}", "$inboxId"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * Send Email
    * Send an email from an inbox&#39;s email address.  The request body should contain the &#x60;SendEmailOptions&#x60; that include recipients, attachments, body etc. See &#x60;SendEmailOptions&#x60; for all available properties. Note the &#x60;inboxId&#x60; refers to the inbox&#39;s id not the inbox&#39;s email address. See https://www.mailslurp.com/guides/ for more information on how to send emails. This method does not return a sent email entity due to legacy reasons. To send and get a sent email as returned response use the sister method &#x60;sendEmailAndConfirm&#x60;.
    * @param inboxId ID of the inbox you want to send the email from 
    * @param sendEmailOptions Options for the email (optional)
    * @return void
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun sendEmail(inboxId: java.util.UUID, sendEmailOptions: SendEmailOptions?) : Unit {
        val localVariableConfig = sendEmailRequestConfig(inboxId = inboxId, sendEmailOptions = sendEmailOptions)

        val localVarResponse = request<Any?>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> Unit
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation sendEmail
    *
    * @param inboxId ID of the inbox you want to send the email from 
    * @param sendEmailOptions Options for the email (optional)
    * @return RequestConfig
    */
    fun sendEmailRequestConfig(inboxId: java.util.UUID, sendEmailOptions: SendEmailOptions?) : RequestConfig {
        val localVariableBody: kotlin.Any? = sendEmailOptions
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.POST,
            path = "/inboxes/{inboxId}".replace("{"+"inboxId"+"}", "$inboxId"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * Send email and return sent confirmation
    * Sister method for standard &#x60;sendEmail&#x60; method with the benefit of returning a &#x60;SentEmail&#x60; entity confirming the successful sending of the email with a link to the sent object created for it.
    * @param inboxId ID of the inbox you want to send the email from 
    * @param sendEmailOptions Options for the email (optional)
    * @return SentEmailDto
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun sendEmailAndConfirm(inboxId: java.util.UUID, sendEmailOptions: SendEmailOptions?) : SentEmailDto {
        val localVariableConfig = sendEmailAndConfirmRequestConfig(inboxId = inboxId, sendEmailOptions = sendEmailOptions)

        val localVarResponse = request<SentEmailDto>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as SentEmailDto
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation sendEmailAndConfirm
    *
    * @param inboxId ID of the inbox you want to send the email from 
    * @param sendEmailOptions Options for the email (optional)
    * @return RequestConfig
    */
    fun sendEmailAndConfirmRequestConfig(inboxId: java.util.UUID, sendEmailOptions: SendEmailOptions?) : RequestConfig {
        val localVariableBody: kotlin.Any? = sendEmailOptions
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.POST,
            path = "/inboxes/{inboxId}/confirm".replace("{"+"inboxId"+"}", "$inboxId"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * Send a test email to inbox
    * Send an inbox a test email to test email receiving is working
    * @param inboxId inboxId 
    * @return void
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun sendTestEmail(inboxId: java.util.UUID) : Unit {
        val localVariableConfig = sendTestEmailRequestConfig(inboxId = inboxId)

        val localVarResponse = request<Any?>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> Unit
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation sendTestEmail
    *
    * @param inboxId inboxId 
    * @return RequestConfig
    */
    fun sendTestEmailRequestConfig(inboxId: java.util.UUID) : RequestConfig {
        val localVariableBody: kotlin.Any? = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.POST,
            path = "/inboxes/{inboxId}/send-test-email".replace("{"+"inboxId"+"}", "$inboxId"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * Set inbox favourited state
    * Set and return new favourite state for an inbox
    * @param inboxId inboxId 
    * @param setInboxFavouritedOptions setInboxFavouritedOptions 
    * @return Inbox
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun setInboxFavourited(inboxId: java.util.UUID, setInboxFavouritedOptions: SetInboxFavouritedOptions) : Inbox {
        val localVariableConfig = setInboxFavouritedRequestConfig(inboxId = inboxId, setInboxFavouritedOptions = setInboxFavouritedOptions)

        val localVarResponse = request<Inbox>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as Inbox
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation setInboxFavourited
    *
    * @param inboxId inboxId 
    * @param setInboxFavouritedOptions setInboxFavouritedOptions 
    * @return RequestConfig
    */
    fun setInboxFavouritedRequestConfig(inboxId: java.util.UUID, setInboxFavouritedOptions: SetInboxFavouritedOptions) : RequestConfig {
        val localVariableBody: kotlin.Any? = setInboxFavouritedOptions
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.PUT,
            path = "/inboxes/{inboxId}/favourite".replace("{"+"inboxId"+"}", "$inboxId"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

    /**
    * Update Inbox. Change name and description. Email address is not editable.
    * Update editable fields on an inbox
    * @param inboxId inboxId 
    * @param updateInboxOptions updateInboxOptions 
    * @return Inbox
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun updateInbox(inboxId: java.util.UUID, updateInboxOptions: UpdateInboxOptions) : Inbox {
        val localVariableConfig = updateInboxRequestConfig(inboxId = inboxId, updateInboxOptions = updateInboxOptions)

        val localVarResponse = request<Inbox>(
            localVariableConfig
        )

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as Inbox
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation updateInbox
    *
    * @param inboxId inboxId 
    * @param updateInboxOptions updateInboxOptions 
    * @return RequestConfig
    */
    fun updateInboxRequestConfig(inboxId: java.util.UUID, updateInboxOptions: UpdateInboxOptions) : RequestConfig {
        val localVariableBody: kotlin.Any? = updateInboxOptions
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf("x-api-key" to xApiKey)
        
        val localVariableConfig = RequestConfig(
            method = RequestMethod.PATCH,
            path = "/inboxes/{inboxId}".replace("{"+"inboxId"+"}", "$inboxId"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )

        return localVariableConfig
    }

}
