/**
* MailSlurp API
* MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
*
* The version of the OpenAPI document: 6.5.2
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
package com.mailslurp.models


import com.squareup.moshi.Json

/**
 * Options for creating an inbox forwarder
 * @param field Field to match against to trigger inbox forwarding for inbound email
 * @param forwardToRecipients Email addresses to forward an email to if it matches the field and match criteria of the forwarder
 * @param match String or wildcard style match for field specified when evaluating forwarding rules
 */

data class CreateInboxForwarderOptions (
    /* Field to match against to trigger inbox forwarding for inbound email */
    @Json(name = "field")
    val field: CreateInboxForwarderOptions.Field? = null,
    /* Email addresses to forward an email to if it matches the field and match criteria of the forwarder */
    @Json(name = "forwardToRecipients")
    val forwardToRecipients: kotlin.collections.List<kotlin.String>? = null,
    /* String or wildcard style match for field specified when evaluating forwarding rules */
    @Json(name = "match")
    val match: kotlin.String? = null
) {

    /**
     * Field to match against to trigger inbox forwarding for inbound email
     * Values: rECIPIENTS,sENDER,sUBJECT,aTTACHMENTS
     */
    enum class Field(val value: kotlin.String) {
        @Json(name = "RECIPIENTS") rECIPIENTS("RECIPIENTS"),
        @Json(name = "SENDER") sENDER("SENDER"),
        @Json(name = "SUBJECT") sUBJECT("SUBJECT"),
        @Json(name = "ATTACHMENTS") aTTACHMENTS("ATTACHMENTS");
    }
}

