/**
* MailSlurp API
* MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
*
* The version of the OpenAPI document: 6.5.2
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
package com.mailslurp.models


import com.squareup.moshi.Json

/**
 * Preview of an email message. For full message (including body and attachments) call the `getEmail` or other email endpoints with the provided email ID.
 * @param attachments List of IDs of attachments found in the email. Use these IDs with the Inbox and Email Controllers to download attachments and attachment meta data such as filesize, name, extension.
 * @param bcc List of `BCC` recipients email addresses that the email was addressed to. See recipients object for names.
 * @param cc List of `CC` recipients email addresses that the email was addressed to. See recipients object for names.
 * @param createdAt When was the email received by MailSlurp
 * @param from Who the email was sent from. An email address - see fromName for the sender name.
 * @param id ID of the email entity
 * @param read Read flag. Has the email ever been viewed in the dashboard or fetched via the API with a hydrated body? If so the email is marked as read. Paginated results do not affect read status. Read status is different to email opened event as it depends on your own account accessing the email. Email opened is determined by tracking pixels sent to other uses if enable during sending. You can listened for both email read and email opened events using webhooks.
 * @param subject The subject line of the email message as specified by SMTP subject header
 * @param to List of `To` recipient email addresses that the email was addressed to. See recipients object for names.
 */

data class EmailPreview (
    /* List of IDs of attachments found in the email. Use these IDs with the Inbox and Email Controllers to download attachments and attachment meta data such as filesize, name, extension. */
    @Json(name = "attachments")
    val attachments: kotlin.collections.List<kotlin.String>? = null,
    /* List of `BCC` recipients email addresses that the email was addressed to. See recipients object for names. */
    @Json(name = "bcc")
    val bcc: kotlin.collections.List<kotlin.String>? = null,
    /* List of `CC` recipients email addresses that the email was addressed to. See recipients object for names. */
    @Json(name = "cc")
    val cc: kotlin.collections.List<kotlin.String>? = null,
    /* When was the email received by MailSlurp */
    @Json(name = "createdAt")
    val createdAt: java.time.OffsetDateTime? = null,
    /* Who the email was sent from. An email address - see fromName for the sender name. */
    @Json(name = "from")
    val from: kotlin.String? = null,
    /* ID of the email entity */
    @Json(name = "id")
    val id: java.util.UUID? = null,
    /* Read flag. Has the email ever been viewed in the dashboard or fetched via the API with a hydrated body? If so the email is marked as read. Paginated results do not affect read status. Read status is different to email opened event as it depends on your own account accessing the email. Email opened is determined by tracking pixels sent to other uses if enable during sending. You can listened for both email read and email opened events using webhooks. */
    @Json(name = "read")
    val read: kotlin.Boolean? = null,
    /* The subject line of the email message as specified by SMTP subject header */
    @Json(name = "subject")
    val subject: kotlin.String? = null,
    /* List of `To` recipient email addresses that the email was addressed to. See recipients object for names. */
    @Json(name = "to")
    val to: kotlin.collections.List<kotlin.String>? = null
)

