/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.infrastructure;

import com.mailslurp.infrastructure.ApiAbstractionsKt;
import com.mailslurp.infrastructure.ApiClient;
import com.mailslurp.infrastructure.ApiClient$WhenMappings;
import com.mailslurp.infrastructure.ApiInfrastructureResponse;
import com.mailslurp.infrastructure.ClientError;
import com.mailslurp.infrastructure.Informational;
import com.mailslurp.infrastructure.Redirection;
import com.mailslurp.infrastructure.RequestConfig;
import com.mailslurp.infrastructure.ResponseExtensionsKt;
import com.mailslurp.infrastructure.Serializer;
import com.mailslurp.infrastructure.ServerError;
import com.mailslurp.infrastructure.Success;
import com.squareup.moshi.Moshi;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0004J\u0012\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0004J\"\u0010\f\u001a\u00020\u0003\"\n\b\u0000\u0010\r\u0018\u0001*\u00020\u00012\u0006\u0010\u000b\u001a\u0002H\rH\u0084\b\u00a2\u0006\u0002\u0010\u000eJ!\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\r0\u0010\"\u0006\b\u0000\u0010\r\u0018\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0084\bJ(\u0010\u0013\u001a\u00020\u0014\"\u0006\b\u0000\u0010\r\u0018\u00012\u0006\u0010\u0015\u001a\u0002H\r2\b\b\u0002\u0010\u0016\u001a\u00020\u0003H\u0084\b\u00a2\u0006\u0002\u0010\u0017J.\u0010\u0018\u001a\u0004\u0018\u0001H\r\"\u0006\b\u0000\u0010\r\u0018\u00012\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0084\b\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lcom/mailslurp/infrastructure/ApiClient;", "", "baseUrl", "", "(Ljava/lang/String;)V", "getBaseUrl", "()Ljava/lang/String;", "guessContentTypeFromFile", "file", "Ljava/io/File;", "parameterToString", "value", "parseDateToQueryString", "T", "(Ljava/lang/Object;)Ljava/lang/String;", "request", "Lcom/mailslurp/infrastructure/ApiInfrastructureResponse;", "requestConfig", "Lcom/mailslurp/infrastructure/RequestConfig;", "requestBody", "Lokhttp3/RequestBody;", "content", "mediaType", "(Ljava/lang/Object;Ljava/lang/String;)Lokhttp3/RequestBody;", "responseBody", "body", "Lokhttp3/ResponseBody;", "(Lokhttp3/ResponseBody;Ljava/lang/String;)Ljava/lang/Object;", "updateAuthParams", "", "Companion", "mailslurp-client-kotlin"})
public class ApiClient {
    @NotNull
    private final String baseUrl;
    @NotNull
    protected static final String ContentType = "Content-Type";
    @NotNull
    protected static final String Accept = "Accept";
    @NotNull
    protected static final String Authorization = "Authorization";
    @NotNull
    protected static final String JsonMediaType = "application/json";
    @NotNull
    protected static final String FormDataMediaType = "multipart/form-data";
    @NotNull
    protected static final String FormUrlEncMediaType = "application/x-www-form-urlencoded";
    @NotNull
    protected static final String XmlMediaType = "application/xml";
    @NotNull
    private static final Map<String, String> apiKey;
    @NotNull
    private static final Map<String, String> apiKeyPrefix;
    @Nullable
    private static String username;
    @Nullable
    private static String password;
    @Nullable
    private static String accessToken;
    @NotNull
    private static final Lazy client$delegate;
    @NotNull
    private static final OkHttpClient.Builder builder;
    @NotNull
    public static final Companion Companion;

    @NotNull
    protected final String guessContentTypeFromFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        String string = contentType;
        if (string == null) {
            string = "application/octet-stream";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    protected final /* synthetic */ <T> RequestBody requestBody(T content, String mediaType) {
        RequestBody requestBody;
        int $i$f$requestBody = 0;
        Intrinsics.checkParameterIsNotNull((Object)mediaType, (String)"mediaType");
        if (content instanceof File) {
            requestBody = RequestBody.Companion.create((File)content, MediaType.Companion.parse(mediaType));
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)FormDataMediaType)) {
            MultipartBody.Builder builder = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
            boolean bl = false;
            boolean bl2 = false;
            MultipartBody.Builder $this$apply = builder;
            boolean bl3 = false;
            T t = content;
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            }
            Map $this$forEach$iv = (Map)t;
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl4 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Headers partHeaders;
                void key;
                Map.Entry element$iv;
                Map.Entry $dstr$key$value = element$iv = iterator.next();
                boolean bl5 = false;
                Map.Entry entry = $dstr$key$value;
                boolean bl6 = false;
                String string = (String)entry.getKey();
                entry = $dstr$key$value;
                bl6 = false;
                Object value = entry.getValue();
                if (value instanceof File) {
                    partHeaders = Headers.Companion.of(new String[]{"Content-Disposition", "form-data; name=\"" + (String)key + "\"; filename=\"" + ((File)value).getName() + '\"'});
                    MediaType fileMediaType = MediaType.Companion.parse(this.guessContentTypeFromFile((File)value));
                    $this$apply.addPart(partHeaders, RequestBody.Companion.create((File)value, fileMediaType));
                    continue;
                }
                partHeaders = Headers.Companion.of(new String[]{"Content-Disposition", "form-data; name=\"" + (String)key + '\"'});
                $this$apply.addPart(partHeaders, RequestBody.Companion.create(this.parameterToString(value), null));
            }
            requestBody = (RequestBody)builder.build();
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)FormUrlEncMediaType)) {
            FormBody.Builder builder = new FormBody.Builder(null, 1, null);
            boolean bl = false;
            boolean bl7 = false;
            FormBody.Builder $this$apply = builder;
            boolean bl8 = false;
            T t = content;
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            }
            Map $this$forEach$iv = (Map)t;
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl9 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$key$value = element$iv = iterator.next();
                boolean bl10 = false;
                Map.Entry entry = $dstr$key$value;
                boolean bl11 = false;
                String key = (String)entry.getKey();
                entry = $dstr$key$value;
                bl11 = false;
                Object value = entry.getValue();
                $this$apply.add(key, this.parameterToString(value));
            }
            requestBody = (RequestBody)builder.build();
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)JsonMediaType)) {
            Moshi moshi2 = Serializer.getMoshi();
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            String string = moshi2.adapter(Object.class).toJson(content);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Serializer.moshi.adapter\u2026ass.java).toJson(content)");
            requestBody = RequestBody.Companion.create(string, MediaType.Companion.parse(mediaType));
        } else {
            if (Intrinsics.areEqual((Object)mediaType, (Object)XmlMediaType)) {
                throw (Throwable)new UnsupportedOperationException("xml not currently supported.");
            }
            throw (Throwable)new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
        }
        return requestBody;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ RequestBody requestBody$default(ApiClient this_, Object content, String mediaType, int n, Object object) {
        RequestBody requestBody;
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: requestBody");
        }
        if ((n & 2) != 0) {
            mediaType = JsonMediaType;
        }
        boolean $i$f$requestBody = false;
        Intrinsics.checkParameterIsNotNull((Object)mediaType, (String)"mediaType");
        if (content instanceof File) {
            requestBody = RequestBody.Companion.create((File)content, MediaType.Companion.parse(mediaType));
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)FormDataMediaType)) {
            object = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
            boolean bl = false;
            boolean bl2 = false;
            Object $this$apply = object;
            boolean bl3 = false;
            Object object2 = content;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            }
            Map $this$forEach$iv = (Map)object2;
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl4 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Headers partHeaders;
                void key;
                Map.Entry element$iv;
                Map.Entry $dstr$key$value = element$iv = iterator.next();
                boolean bl5 = false;
                Map.Entry entry = $dstr$key$value;
                boolean bl6 = false;
                String string = (String)entry.getKey();
                entry = $dstr$key$value;
                bl6 = false;
                Object value = entry.getValue();
                if (value instanceof File) {
                    partHeaders = Headers.Companion.of(new String[]{"Content-Disposition", "form-data; name=\"" + (String)key + "\"; filename=\"" + ((File)value).getName() + '\"'});
                    MediaType fileMediaType = MediaType.Companion.parse(this_.guessContentTypeFromFile((File)value));
                    $this$apply.addPart(partHeaders, RequestBody.Companion.create((File)value, fileMediaType));
                    continue;
                }
                partHeaders = Headers.Companion.of(new String[]{"Content-Disposition", "form-data; name=\"" + (String)key + '\"'});
                $this$apply.addPart(partHeaders, RequestBody.Companion.create(this_.parameterToString(value), null));
            }
            requestBody = (RequestBody)object.build();
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)FormUrlEncMediaType)) {
            object = new FormBody.Builder(null, 1, null);
            boolean bl = false;
            boolean bl7 = false;
            Object $this$apply = object;
            boolean bl8 = false;
            Object object3 = content;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            }
            Map $this$forEach$iv = (Map)object3;
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl9 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$key$value = element$iv = iterator.next();
                boolean bl10 = false;
                Map.Entry entry = $dstr$key$value;
                boolean bl11 = false;
                String key = (String)entry.getKey();
                entry = $dstr$key$value;
                bl11 = false;
                Object value = entry.getValue();
                $this$apply.add(key, this_.parameterToString(value));
            }
            requestBody = (RequestBody)object.build();
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)JsonMediaType)) {
            Moshi moshi2 = Serializer.getMoshi();
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            String string = moshi2.adapter(Object.class).toJson(content);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Serializer.moshi.adapter\u2026ass.java).toJson(content)");
            requestBody = RequestBody.Companion.create(string, MediaType.Companion.parse(mediaType));
        } else {
            if (Intrinsics.areEqual((Object)mediaType, (Object)XmlMediaType)) {
                throw (Throwable)new UnsupportedOperationException("xml not currently supported.");
            }
            throw (Throwable)new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
        }
        return requestBody;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final /* synthetic */ <T> T responseBody(ResponseBody body, String mediaType) {
        int $i$f$responseBody = 0;
        if (body == null) {
            return null;
        }
        String bodyContent = body.string();
        CharSequence charSequence = bodyContent;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return null;
        }
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (Intrinsics.areEqual(Object.class, File.class)) {
            File f = Files.createTempFile("tmp.com.mailslurp", null, new FileAttribute[0]).toFile();
            f.deleteOnExit();
            BufferedWriter out = new BufferedWriter(new FileWriter(f));
            out.write(bodyContent);
            out.close();
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return (T)f;
        }
        String string = mediaType;
        if (string == null) throw (Throwable)new UnsupportedOperationException("responseBody currently only supports JSON body.");
        charSequence = string;
        switch (((String)charSequence).hashCode()) {
            case -43840953: {
                if (!((String)charSequence).equals(JsonMediaType)) throw (Throwable)new UnsupportedOperationException("responseBody currently only supports JSON body.");
                Moshi moshi2 = Serializer.getMoshi();
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return (T)moshi2.adapter(Object.class).fromJson(bodyContent);
            }
            default: {
                throw (Throwable)new UnsupportedOperationException("responseBody currently only supports JSON body.");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static /* synthetic */ Object responseBody$default(ApiClient this_, ResponseBody body, String mediaType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: responseBody");
        }
        if ((n & 2) != 0) {
            mediaType = JsonMediaType;
        }
        boolean $i$f$responseBody = false;
        if (body == null) {
            return null;
        }
        String bodyContent = body.string();
        CharSequence charSequence = bodyContent;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return null;
        }
        boolean bl2 = false;
        if (bl2) {
            return null;
        }
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (Intrinsics.areEqual(Object.class, File.class)) {
            File f = Files.createTempFile("tmp.com.mailslurp", null, new FileAttribute[0]).toFile();
            f.deleteOnExit();
            BufferedWriter out = new BufferedWriter(new FileWriter(f));
            out.write(bodyContent);
            out.close();
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return f;
        }
        String string = mediaType;
        if (string == null) throw (Throwable)new UnsupportedOperationException("responseBody currently only supports JSON body.");
        charSequence = string;
        switch (((String)charSequence).hashCode()) {
            case -43840953: {
                if (!((String)charSequence).equals(JsonMediaType)) throw (Throwable)new UnsupportedOperationException("responseBody currently only supports JSON body.");
                Moshi moshi2 = Serializer.getMoshi();
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return moshi2.adapter(Object.class).fromJson(bodyContent);
            }
            default: {
                throw (Throwable)new UnsupportedOperationException("responseBody currently only supports JSON body.");
            }
        }
    }

    protected final void updateAuthParams(@NotNull RequestConfig requestConfig) {
        Intrinsics.checkParameterIsNotNull((Object)requestConfig, (String)"requestConfig");
        CharSequence charSequence = requestConfig.getHeaders().get("x-api-key");
        boolean bl = false;
        boolean bl2 = false;
        if ((charSequence == null || charSequence.length() == 0) && apiKey.get("x-api-key") != null) {
            if (apiKeyPrefix.get("x-api-key") != null) {
                Map<String, String> map = requestConfig.getHeaders();
                StringBuilder stringBuilder = new StringBuilder();
                String string = apiKeyPrefix.get("x-api-key");
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                StringBuilder stringBuilder2 = stringBuilder.append(string).append(" ");
                String string2 = apiKey.get("x-api-key");
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                map.put("x-api-key", stringBuilder2.append(string2).toString());
            } else {
                Map<String, String> map = requestConfig.getHeaders();
                String string = apiKey.get("x-api-key");
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                map.put("x-api-key", string);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final /* synthetic */ <T> ApiInfrastructureResponse<T> request(RequestConfig requestConfig) {
        String string;
        Request.Builder builder;
        Map<String, String> headers;
        String string2;
        Iterator<Object> iterator;
        boolean $i$f$forEach;
        Object $this$forEach$iv;
        int $i$f$request = 0;
        Intrinsics.checkParameterIsNotNull((Object)requestConfig, (String)"requestConfig");
        HttpUrl httpUrl = HttpUrl.Companion.parse(this.getBaseUrl());
        if (httpUrl == null) {
            throw (Throwable)new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl2 = httpUrl;
        this.updateAuthParams(requestConfig);
        Object object = httpUrl2.newBuilder().addPathSegments(StringsKt.trimStart((String)requestConfig.getPath(), (char[])new char[]{'/'}));
        boolean bl = false;
        boolean bl2 = false;
        HttpUrl.Builder builder2 = object;
        boolean bl32 = false;
        Map<String, List<String>> $this$forEach$iv2 = requestConfig.getQuery();
        boolean bl4 = false;
        Map<String, List<String>> map = $this$forEach$iv2;
        boolean bl5 = false;
        Iterator<Map.Entry<String, List<String>>> iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, List<String>> element$iv;
            Map.Entry<String, List<String>> query = element$iv = iterator2.next();
            boolean bl6 = false;
            $this$forEach$iv = query.getValue();
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv2 = iterator.next();
                String queryValue = (String)element$iv2;
                boolean bl7 = false;
                builder2.addQueryParameter(query.getKey(), queryValue);
            }
        }
        HttpUrl url = object.build();
        object = requestConfig.getHeaders().get(ContentType);
        bl = false;
        bl2 = false;
        if (object == null || object.length() == 0) {
            requestConfig.getHeaders().put(ContentType, JsonMediaType);
        }
        object = requestConfig.getHeaders().get(Accept);
        bl = false;
        bl2 = false;
        if (object == null || object.length() == 0) {
            requestConfig.getHeaders().put(Accept, JsonMediaType);
        }
        if ((string2 = (headers = requestConfig.getHeaders()).get(ContentType)) == null) {
            string2 = "";
        }
        if (Intrinsics.areEqual((Object)string2, (Object)"")) {
            throw (Throwable)new IllegalStateException("Missing Content-Type header. This is required.");
        }
        String string3 = headers.get(Accept);
        if (string3 == null) {
            string3 = "";
        }
        if (Intrinsics.areEqual((Object)string3, (Object)"")) {
            throw (Throwable)new IllegalStateException("Missing Accept header. This is required.");
        }
        String string4 = headers.get(ContentType);
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String string5 = StringsKt.substringBefore$default((String)string4, (String)";", null, (int)2, null);
        boolean bl8 = false;
        String string6 = string5;
        if (string6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string7 = string6.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toLowerCase()");
        String contentType = string7;
        switch (ApiClient$WhenMappings.$EnumSwitchMapping$0[requestConfig.getMethod().ordinal()]) {
            case 1: {
                boolean bl9;
                Map.Entry partHeaders$iv;
                String key$iv;
                Object value$iv;
                Map.Entry entry;
                boolean bl10;
                Map.Entry $dstr$key$value$iv;
                Map.Entry element$iv$iv;
                boolean $i$f$forEach2;
                Map $this$forEach$iv$iv;
                MultipartBody.Builder $this$apply$iv;
                RequestBody requestBody;
                void content$iv;
                ApiClient apiClient = this;
                Object bl32 = requestConfig.getBody();
                Request.Builder builder3 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv, MediaType.Companion.parse(contentType));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder builder4 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    boolean bl11 = false;
                    bl5 = false;
                    $this$apply$iv = builder4;
                    boolean bl12 = false;
                    void v7 = content$iv;
                    if (v7 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv = (Map)v7;
                    $i$f$forEach2 = false;
                    $this$forEach$iv = $this$forEach$iv$iv;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        $dstr$key$value$iv = element$iv$iv = (Map.Entry)iterator.next();
                        bl10 = false;
                        entry = $dstr$key$value$iv;
                        boolean bl13 = false;
                        String string8 = (String)entry.getKey();
                        entry = $dstr$key$value$iv;
                        bl13 = false;
                        value$iv = entry.getValue();
                        if (value$iv instanceof File) {
                            partHeaders$iv = Headers.Companion.of(new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + "\"; filename=\"" + ((File)value$iv).getName() + '\"'});
                            MediaType fileMediaType$iv = MediaType.Companion.parse(apiClient.guessContentTypeFromFile((File)value$iv));
                            $this$apply$iv.addPart((Headers)partHeaders$iv, RequestBody.Companion.create((File)value$iv, fileMediaType$iv));
                            continue;
                        }
                        partHeaders$iv = Headers.Companion.of(new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + '\"'});
                        $this$apply$iv.addPart((Headers)partHeaders$iv, RequestBody.Companion.create(apiClient.parameterToString(value$iv), null));
                    }
                    requestBody = (RequestBody)builder4.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder builder5 = new FormBody.Builder(null, 1, null);
                    boolean bl14 = false;
                    bl5 = false;
                    $this$apply$iv = builder5;
                    boolean bl15 = false;
                    void v8 = content$iv;
                    if (v8 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv = (Map)v8;
                    $i$f$forEach2 = false;
                    $this$forEach$iv = $this$forEach$iv$iv;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        $dstr$key$value$iv = element$iv$iv = (Map.Entry)iterator.next();
                        bl9 = false;
                        partHeaders$iv = $dstr$key$value$iv;
                        boolean fileMediaType$iv = false;
                        key$iv = (String)partHeaders$iv.getKey();
                        partHeaders$iv = $dstr$key$value$iv;
                        fileMediaType$iv = false;
                        value$iv = partHeaders$iv.getValue();
                        $this$apply$iv.add(key$iv, apiClient.parameterToString(value$iv));
                    }
                    requestBody = (RequestBody)builder5.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)JsonMediaType)) {
                    String string9 = Serializer.getMoshi().adapter(Object.class).toJson((Object)content$iv);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"Serializer.moshi.adapter\u2026ass.java).toJson(content)");
                    requestBody = RequestBody.Companion.create(string9, MediaType.Companion.parse(contentType));
                } else {
                    if (!Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) throw (Throwable)new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                    throw (Throwable)new UnsupportedOperationException("xml not currently supported.");
                }
                RequestBody requestBody2 = requestBody;
                builder = builder3.delete(requestBody2);
                break;
            }
            case 2: {
                builder = new Request.Builder().url(url);
                break;
            }
            case 3: {
                builder = new Request.Builder().url(url).head();
                break;
            }
            case 4: {
                RequestBody requestBody;
                boolean bl9;
                Map.Entry partHeaders$iv;
                String key$iv;
                Object value$iv;
                boolean bl10;
                Map.Entry $dstr$key$value$iv;
                Map.Entry element$iv$iv;
                boolean $i$f$forEach2;
                Map $this$forEach$iv$iv;
                MultipartBody.Builder $this$apply$iv;
                ApiClient apiClient = this;
                Object content$iv = requestConfig.getBody();
                Request.Builder builder3 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv, MediaType.Companion.parse(contentType));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder builder6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    boolean bl16 = false;
                    bl5 = false;
                    $this$apply$iv = builder6;
                    boolean bl17 = false;
                    Object object2 = content$iv;
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv = (Map)object2;
                    $i$f$forEach2 = false;
                    $this$forEach$iv = $this$forEach$iv$iv;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        $dstr$key$value$iv = element$iv$iv = (Map.Entry)iterator.next();
                        bl10 = false;
                        partHeaders$iv = $dstr$key$value$iv;
                        boolean fileMediaType$iv = false;
                        key$iv = (String)partHeaders$iv.getKey();
                        partHeaders$iv = $dstr$key$value$iv;
                        fileMediaType$iv = false;
                        value$iv = partHeaders$iv.getValue();
                        if (value$iv instanceof File) {
                            partHeaders$iv = Headers.Companion.of(new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + "\"; filename=\"" + ((File)value$iv).getName() + '\"'});
                            MediaType fileMediaType$iv2 = MediaType.Companion.parse(apiClient.guessContentTypeFromFile((File)value$iv));
                            $this$apply$iv.addPart((Headers)partHeaders$iv, RequestBody.Companion.create((File)value$iv, fileMediaType$iv2));
                            continue;
                        }
                        partHeaders$iv = Headers.Companion.of(new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + '\"'});
                        $this$apply$iv.addPart((Headers)partHeaders$iv, RequestBody.Companion.create(apiClient.parameterToString(value$iv), null));
                    }
                    requestBody = (RequestBody)builder6.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder builder7 = new FormBody.Builder(null, 1, null);
                    boolean bl18 = false;
                    bl5 = false;
                    $this$apply$iv = builder7;
                    boolean bl19 = false;
                    Object object3 = content$iv;
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv = (Map)object3;
                    $i$f$forEach2 = false;
                    $this$forEach$iv = $this$forEach$iv$iv;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        $dstr$key$value$iv = element$iv$iv = (Map.Entry)iterator.next();
                        bl9 = false;
                        partHeaders$iv = $dstr$key$value$iv;
                        boolean fileMediaType$iv2 = false;
                        key$iv = (String)partHeaders$iv.getKey();
                        partHeaders$iv = $dstr$key$value$iv;
                        fileMediaType$iv2 = false;
                        value$iv = partHeaders$iv.getValue();
                        $this$apply$iv.add(key$iv, apiClient.parameterToString(value$iv));
                    }
                    requestBody = (RequestBody)builder7.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)JsonMediaType)) {
                    String string10 = Serializer.getMoshi().adapter(Object.class).toJson(content$iv);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"Serializer.moshi.adapter\u2026ass.java).toJson(content)");
                    requestBody = RequestBody.Companion.create(string10, MediaType.Companion.parse(contentType));
                } else {
                    if (!Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) throw (Throwable)new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                    throw (Throwable)new UnsupportedOperationException("xml not currently supported.");
                }
                RequestBody requestBody2 = requestBody;
                builder = builder3.patch(requestBody2);
                break;
            }
            case 5: {
                RequestBody requestBody;
                boolean bl9;
                Map.Entry partHeaders$iv;
                String key$iv;
                Object value$iv;
                boolean bl10;
                Map.Entry $dstr$key$value$iv;
                Map.Entry element$iv$iv;
                boolean $i$f$forEach2;
                Map $this$forEach$iv$iv;
                MultipartBody.Builder $this$apply$iv;
                ApiClient apiClient = this;
                Object content$iv = requestConfig.getBody();
                Request.Builder builder3 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv, MediaType.Companion.parse(contentType));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder builder8 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    boolean bl20 = false;
                    bl5 = false;
                    $this$apply$iv = builder8;
                    boolean bl21 = false;
                    Object object4 = content$iv;
                    if (object4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv = (Map)object4;
                    $i$f$forEach2 = false;
                    $this$forEach$iv = $this$forEach$iv$iv;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        $dstr$key$value$iv = element$iv$iv = (Map.Entry)iterator.next();
                        bl10 = false;
                        partHeaders$iv = $dstr$key$value$iv;
                        boolean fileMediaType$iv2 = false;
                        key$iv = (String)partHeaders$iv.getKey();
                        partHeaders$iv = $dstr$key$value$iv;
                        fileMediaType$iv2 = false;
                        value$iv = partHeaders$iv.getValue();
                        if (value$iv instanceof File) {
                            partHeaders$iv = Headers.Companion.of(new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + "\"; filename=\"" + ((File)value$iv).getName() + '\"'});
                            MediaType fileMediaType$iv = MediaType.Companion.parse(apiClient.guessContentTypeFromFile((File)value$iv));
                            $this$apply$iv.addPart((Headers)partHeaders$iv, RequestBody.Companion.create((File)value$iv, fileMediaType$iv));
                            continue;
                        }
                        partHeaders$iv = Headers.Companion.of(new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + '\"'});
                        $this$apply$iv.addPart((Headers)partHeaders$iv, RequestBody.Companion.create(apiClient.parameterToString(value$iv), null));
                    }
                    requestBody = (RequestBody)builder8.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder builder9 = new FormBody.Builder(null, 1, null);
                    boolean bl22 = false;
                    bl5 = false;
                    $this$apply$iv = builder9;
                    boolean bl23 = false;
                    Object object5 = content$iv;
                    if (object5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv = (Map)object5;
                    $i$f$forEach2 = false;
                    $this$forEach$iv = $this$forEach$iv$iv;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        $dstr$key$value$iv = element$iv$iv = (Map.Entry)iterator.next();
                        bl9 = false;
                        partHeaders$iv = $dstr$key$value$iv;
                        boolean fileMediaType$iv = false;
                        key$iv = (String)partHeaders$iv.getKey();
                        partHeaders$iv = $dstr$key$value$iv;
                        fileMediaType$iv = false;
                        value$iv = partHeaders$iv.getValue();
                        $this$apply$iv.add(key$iv, apiClient.parameterToString(value$iv));
                    }
                    requestBody = (RequestBody)builder9.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)JsonMediaType)) {
                    String string11 = Serializer.getMoshi().adapter(Object.class).toJson(content$iv);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"Serializer.moshi.adapter\u2026ass.java).toJson(content)");
                    requestBody = RequestBody.Companion.create(string11, MediaType.Companion.parse(contentType));
                } else {
                    if (!Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) throw (Throwable)new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                    throw (Throwable)new UnsupportedOperationException("xml not currently supported.");
                }
                RequestBody requestBody2 = requestBody;
                builder = builder3.put(requestBody2);
                break;
            }
            case 6: {
                RequestBody requestBody;
                boolean bl9;
                Map.Entry partHeaders$iv;
                String key$iv;
                Object value$iv;
                Map.Entry entry;
                boolean bl10;
                Map.Entry $dstr$key$value$iv;
                Map.Entry element$iv$iv;
                boolean $i$f$forEach2;
                Map $this$forEach$iv$iv;
                MultipartBody.Builder $this$apply$iv;
                ApiClient apiClient = this;
                Object content$iv = requestConfig.getBody();
                Request.Builder builder3 = new Request.Builder().url(url);
                boolean $i$f$requestBody2 = false;
                if (content$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv, MediaType.Companion.parse(contentType));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder builder10 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    boolean bl24 = false;
                    bl5 = false;
                    $this$apply$iv = builder10;
                    boolean bl25 = false;
                    Object object6 = content$iv;
                    if (object6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv = (Map)object6;
                    $i$f$forEach2 = false;
                    $this$forEach$iv = $this$forEach$iv$iv;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        $dstr$key$value$iv = element$iv$iv = (Map.Entry)iterator.next();
                        bl10 = false;
                        partHeaders$iv = $dstr$key$value$iv;
                        boolean fileMediaType$iv = false;
                        key$iv = (String)partHeaders$iv.getKey();
                        partHeaders$iv = $dstr$key$value$iv;
                        fileMediaType$iv = false;
                        value$iv = partHeaders$iv.getValue();
                        if (value$iv instanceof File) {
                            partHeaders$iv = Headers.Companion.of(new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + "\"; filename=\"" + ((File)value$iv).getName() + '\"'});
                            MediaType fileMediaType$iv3 = MediaType.Companion.parse(apiClient.guessContentTypeFromFile((File)value$iv));
                            $this$apply$iv.addPart((Headers)partHeaders$iv, RequestBody.Companion.create((File)value$iv, fileMediaType$iv3));
                            continue;
                        }
                        partHeaders$iv = Headers.Companion.of(new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + '\"'});
                        $this$apply$iv.addPart((Headers)partHeaders$iv, RequestBody.Companion.create(apiClient.parameterToString(value$iv), null));
                    }
                    requestBody = (RequestBody)builder10.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder builder11 = new FormBody.Builder(null, 1, null);
                    boolean bl26 = false;
                    bl5 = false;
                    $this$apply$iv = builder11;
                    boolean bl272 = false;
                    Object object7 = content$iv;
                    if (object7 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv = (Map)object7;
                    $i$f$forEach2 = false;
                    $this$forEach$iv = $this$forEach$iv$iv;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        $dstr$key$value$iv = element$iv$iv = (Map.Entry)iterator.next();
                        bl9 = false;
                        entry = $dstr$key$value$iv;
                        boolean bl28 = false;
                        key$iv = (String)entry.getKey();
                        entry = $dstr$key$value$iv;
                        bl28 = false;
                        value$iv = entry.getValue();
                        $this$apply$iv.add(key$iv, apiClient.parameterToString(value$iv));
                    }
                    requestBody = (RequestBody)builder11.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)JsonMediaType)) {
                    String string12 = Serializer.getMoshi().adapter(Object.class).toJson(content$iv);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"Serializer.moshi.adapter\u2026ass.java).toJson(content)");
                    requestBody = RequestBody.Companion.create(string12, MediaType.Companion.parse(contentType));
                } else {
                    if (!Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) throw (Throwable)new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                    throw (Throwable)new UnsupportedOperationException("xml not currently supported.");
                }
                RequestBody requestBody2 = requestBody;
                builder = builder3.post(requestBody2);
                break;
            }
            case 7: {
                builder = new Request.Builder().url(url).method("OPTIONS", null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Request.Builder builder12 = builder;
        boolean content$iv = false;
        boolean $i$f$requestBody2 = false;
        Request.Builder builder13 = builder12;
        boolean bl29 = false;
        Map<String, String> $this$forEach$iv3 = headers;
        boolean $i$f$forEach32 = false;
        Map<String, String> bl272 = $this$forEach$iv3;
        boolean bl30 = false;
        Iterator<Map.Entry<String, String>> iterator3 = bl272.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> header = element$iv = iterator3.next();
            boolean bl31 = false;
            builder13.addHeader(header.getKey(), header.getValue());
        }
        Request request = builder12.build();
        Response response = Companion.getClient().newCall(request).execute();
        String string13 = Response.header$default((Response)response, (String)ContentType, null, (int)2, null);
        if (string13 != null && (string13 = StringsKt.substringBefore$default((String)string13, (String)";", null, (int)2, null)) != null) {
            String $i$f$requestBody2 = string13;
            boolean bl32 = false;
            String string14 = $i$f$requestBody2;
            if (string14 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string15 = string14.toLowerCase();
            string = string15;
            Intrinsics.checkExpressionValueIsNotNull((Object)string15, (String)"(this as java.lang.String).toLowerCase()");
        } else {
            string = null;
        }
        String accept = string;
        if (response.isRedirect()) {
            return new Redirection(response.code(), response.headers().toMultimap());
        }
        if (ResponseExtensionsKt.isInformational(response)) {
            return new Informational(response.message(), response.code(), response.headers().toMultimap());
        }
        if (response.isSuccessful()) {
            Object object8;
            ApiClient $i$f$requestBody2 = this;
            ResponseBody responseBody = response.body();
            boolean $i$f$responseBody = false;
            if (responseBody == null) {
                object8 = null;
                return new Success<Object>(object8, response.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response.headers().toMultimap()));
            } else {
                String bodyContent$iv = responseBody.string();
                CharSequence $i$f$forEach32 = bodyContent$iv;
                boolean bl272 = false;
                if ($i$f$forEach32.length() == 0) {
                    object8 = null;
                    return new Success<Object>(object8, response.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response.headers().toMultimap()));
                } else {
                    Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                    if (Intrinsics.areEqual(Object.class, File.class)) {
                        File f$iv = Files.createTempFile("tmp.com.mailslurp", null, new FileAttribute[0]).toFile();
                        f$iv.deleteOnExit();
                        BufferedWriter out$iv = new BufferedWriter(new FileWriter(f$iv));
                        out$iv.write(bodyContent$iv);
                        out$iv.close();
                        Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
                        object8 = f$iv;
                        return new Success<Object>(object8, response.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response.headers().toMultimap()));
                    } else {
                        String string16 = accept;
                        if (string16 == null) throw (Throwable)new UnsupportedOperationException("responseBody currently only supports JSON body.");
                        String string17 = string16;
                        switch (string17.hashCode()) {
                            case -43840953: {
                                if (!string17.equals(JsonMediaType)) throw (Throwable)new UnsupportedOperationException("responseBody currently only supports JSON body.");
                                Moshi moshi2 = Serializer.getMoshi();
                                Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                                object8 = moshi2.adapter(Object.class).fromJson(bodyContent$iv);
                                return new Success<Object>(object8, response.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response.headers().toMultimap()));
                            }
                            default: {
                                throw (Throwable)new UnsupportedOperationException("responseBody currently only supports JSON body.");
                            }
                        }
                    }
                }
            }
        }
        if (ResponseExtensionsKt.isClientError(response)) {
            ResponseBody responseBody = response.body();
            return new ClientError(response.message(), responseBody != null ? responseBody.string() : null, response.code(), response.headers().toMultimap());
        }
        ResponseBody responseBody = response.body();
        return new ServerError(response.message(), responseBody != null ? responseBody.string() : null, response.code(), response.headers().toMultimap());
    }

    @NotNull
    protected final String parameterToString(@Nullable Object value) {
        Object object = value;
        if (object == null) {
            return "";
        }
        if (object instanceof Object[]) {
            return ApiAbstractionsKt.toMultiValue$default((Object[])value, "csv", null, 4, null).toString();
        }
        if (object instanceof Iterable) {
            return ApiAbstractionsKt.toMultiValue$default((Iterable)value, "csv", null, 4, null).toString();
        }
        if (object instanceof OffsetDateTime || object instanceof OffsetTime || object instanceof LocalDateTime || object instanceof LocalDate || object instanceof LocalTime || object instanceof Date) {
            ApiClient this_$iv = this;
            boolean $i$f$parseDateToQueryString = false;
            String string = Serializer.getMoshi().adapter(Object.class).toJson(value);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Serializer.moshi.adapter\u2026class.java).toJson(value)");
            return StringsKt.replace$default((String)string, (String)"\"", (String)"", (boolean)false, (int)4, null);
        }
        return value.toString();
    }

    protected final /* synthetic */ <T> String parseDateToQueryString(T value) {
        int $i$f$parseDateToQueryString = 0;
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        Moshi moshi2 = Serializer.getMoshi();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        String string = moshi2.adapter(Object.class).toJson(value);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Serializer.moshi.adapter\u2026class.java).toJson(value)");
        return StringsKt.replace$default((String)string, (String)"\"", (String)"", (boolean)false, (int)4, null);
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    public ApiClient(@NotNull String baseUrl) {
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        this.baseUrl = baseUrl;
    }

    static {
        Companion = new Companion(null);
        boolean bl = false;
        apiKey = new LinkedHashMap();
        bl = false;
        apiKeyPrefix = new LinkedHashMap();
        client$delegate = LazyKt.lazy((Function0)Companion.client.2.INSTANCE);
        builder = new OkHttpClient.Builder();
    }

    public static final /* synthetic */ RequestBody access$requestBody(ApiClient $this, Object content, String mediaType) {
        return $this.requestBody(content, mediaType);
    }

    public static final /* synthetic */ Object access$responseBody(ApiClient $this, ResponseBody body, String mediaType) {
        return $this.responseBody(body, mediaType);
    }

    @NotNull
    public static final OkHttpClient getClient() {
        return Companion.getClient();
    }

    @NotNull
    public static final OkHttpClient.Builder getBuilder() {
        Companion companion = Companion;
        return builder;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001c\u0010\u0016\u001a\u00020\u00178\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\u0002\u001a\u0004\b\u0019\u0010\u001aR!\u0010\u001b\u001a\u00020\u001c8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b \u0010!\u0012\u0004\b\u001d\u0010\u0002\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010\"\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\r\"\u0004\b$\u0010\u000fR\u001c\u0010%\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\r\"\u0004\b'\u0010\u000f\u00a8\u0006("}, d2={"Lcom/mailslurp/infrastructure/ApiClient$Companion;", "", "()V", "Accept", "", "Authorization", "ContentType", "FormDataMediaType", "FormUrlEncMediaType", "JsonMediaType", "XmlMediaType", "accessToken", "getAccessToken", "()Ljava/lang/String;", "setAccessToken", "(Ljava/lang/String;)V", "apiKey", "", "getApiKey", "()Ljava/util/Map;", "apiKeyPrefix", "getApiKeyPrefix", "builder", "Lokhttp3/OkHttpClient$Builder;", "getBuilder$annotations", "getBuilder", "()Lokhttp3/OkHttpClient$Builder;", "client", "Lokhttp3/OkHttpClient;", "getClient$annotations", "getClient", "()Lokhttp3/OkHttpClient;", "client$delegate", "Lkotlin/Lazy;", "password", "getPassword", "setPassword", "username", "getUsername", "setUsername", "mailslurp-client-kotlin"})
    public static final class Companion {
        @NotNull
        public final Map<String, String> getApiKey() {
            return apiKey;
        }

        @NotNull
        public final Map<String, String> getApiKeyPrefix() {
            return apiKeyPrefix;
        }

        @Nullable
        public final String getUsername() {
            return username;
        }

        public final void setUsername(@Nullable String string) {
            username = string;
        }

        @Nullable
        public final String getPassword() {
            return password;
        }

        public final void setPassword(@Nullable String string) {
            password = string;
        }

        @Nullable
        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(@Nullable String string) {
            accessToken = string;
        }

        @JvmStatic
        public static /* synthetic */ void getClient$annotations() {
        }

        @NotNull
        public final OkHttpClient getClient() {
            Lazy lazy = client$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (OkHttpClient)lazy.getValue();
        }

        @JvmStatic
        public static /* synthetic */ void getBuilder$annotations() {
        }

        @NotNull
        public final OkHttpClient.Builder getBuilder() {
            return builder;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

