/*
 * Decompiled with CFR 0.152.
 */
package com.cocoahero.android.geojson;

import android.os.Parcel;
import android.os.Parcelable;
import com.cocoahero.android.geojson.GeoJSONObject;
import com.cocoahero.android.geojson.Geometry;
import com.cocoahero.android.geojson.LineString;
import com.cocoahero.android.geojson.Position;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MultiLineString
extends Geometry {
    private final List<LineString> mLineStrings = new ArrayList<LineString>();
    public static final Parcelable.Creator<MultiLineString> CREATOR = new Parcelable.Creator<MultiLineString>(){

        public MultiLineString createFromParcel(Parcel in) {
            return (MultiLineString)GeoJSONObject.readParcel(in);
        }

        public MultiLineString[] newArray(int size) {
            return new MultiLineString[size];
        }
    };

    public MultiLineString() {
    }

    public MultiLineString(JSONObject json) {
        super(json);
        this.setLineStrings(json.optJSONArray("coordinates"));
    }

    public MultiLineString(JSONArray lineStrings) {
        this.setLineStrings(lineStrings);
    }

    public void addLineString(LineString lineString) {
        this.mLineStrings.add(lineString);
    }

    public void removeLineString(LineString lineString) {
        this.mLineStrings.remove(lineString);
    }

    public List<LineString> getLineStrings() {
        return this.mLineStrings;
    }

    public void setLineStrings(JSONArray lineStrings) {
        this.mLineStrings.clear();
        if (lineStrings != null) {
            for (int i = 0; i < lineStrings.length(); ++i) {
                JSONArray lineJSON = lineStrings.optJSONArray(i);
                if (lineJSON == null) continue;
                this.mLineStrings.add(new LineString(lineJSON));
            }
        }
    }

    public void setLineStrings(List<LineString> lineStrings) {
        this.mLineStrings.clear();
        if (lineStrings != null) {
            this.mLineStrings.addAll(lineStrings);
        }
    }

    @Override
    public String getType() {
        return "MultiLineString";
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject json = super.toJSON();
        JSONArray strings = new JSONArray();
        for (LineString line : this.mLineStrings) {
            JSONArray lineJSON = new JSONArray();
            for (Position position : line.getPositions()) {
                lineJSON.put((Object)position.toJSON());
            }
            strings.put((Object)lineJSON);
        }
        json.put("coordinates", (Object)strings);
        return json;
    }
}

