/*
 * Decompiled with CFR 0.152.
 */
package com.cocoahero.android.geojson;

import android.os.Parcel;
import android.os.Parcelable;
import com.cocoahero.android.geojson.GeoJSONObject;
import com.cocoahero.android.geojson.Geometry;
import com.cocoahero.android.geojson.Ring;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Polygon
extends Geometry {
    private final List<Ring> mRings = new ArrayList<Ring>();
    public static final Parcelable.Creator<Polygon> CREATOR = new Parcelable.Creator<Polygon>(){

        public Polygon createFromParcel(Parcel in) {
            return (Polygon)GeoJSONObject.readParcel(in);
        }

        public Polygon[] newArray(int size) {
            return new Polygon[size];
        }
    };

    public Polygon() {
    }

    public Polygon(Ring ring) {
        this.addRing(ring);
    }

    public Polygon(JSONObject json) {
        super(json);
        this.setRings(json.optJSONArray("coordinates"));
    }

    public Polygon(JSONArray rings) {
        this.setRings(rings);
    }

    public void addRing(Ring ring) {
        this.mRings.add(ring);
    }

    public void removeRing(Ring ring) {
        this.mRings.remove(ring);
    }

    public List<Ring> getRings() {
        return this.mRings;
    }

    public void setRings(JSONArray rings) {
        this.mRings.clear();
        if (rings != null) {
            for (int i = 0; i < rings.length(); ++i) {
                JSONArray ringJSON = rings.optJSONArray(i);
                if (ringJSON == null) continue;
                this.mRings.add(new Ring(ringJSON));
            }
        }
    }

    public void setRings(List<Ring> rings) {
        this.mRings.clear();
        if (rings != null) {
            this.mRings.addAll(rings);
        }
    }

    @Override
    public String getType() {
        return "Polygon";
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject json = super.toJSON();
        JSONArray rings = new JSONArray();
        for (Ring ring : this.mRings) {
            rings.put((Object)ring.toJSON());
        }
        json.put("coordinates", (Object)rings);
        return json;
    }
}

