/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.overlay;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.view.View;
import com.mapbox.mapboxsdk.overlay.Overlay;
import com.mapbox.mapboxsdk.views.MapView;
import com.mapbox.mapboxsdk.views.safecanvas.ISafeCanvas;
import com.mapbox.mapboxsdk.views.safecanvas.SafeTranslatedCanvas;
import com.nineoldandroids.view.ViewHelper;

public abstract class SafeDrawOverlay
extends Overlay {
    private static final SafeTranslatedCanvas sSafeCanvas = new SafeTranslatedCanvas();
    private static final Matrix sMatrix = new Matrix();
    private boolean mUseSafeCanvas = true;

    protected abstract void drawSafe(ISafeCanvas var1, MapView var2, boolean var3);

    @Override
    protected void draw(Canvas c, MapView mapView, boolean shadow) {
        sSafeCanvas.setCanvas(c);
        if (this.mUseSafeCanvas) {
            Rect screenRect = mapView.getProjection().getScreenRect();
            SafeDrawOverlay.sSafeCanvas.xOffset = -screenRect.left;
            SafeDrawOverlay.sSafeCanvas.yOffset = -screenRect.top;
            c.save();
            if (mapView.getMapOrientation() != 0.0f) {
                c.rotate(-mapView.getMapOrientation(), screenRect.exactCenterX(), screenRect.exactCenterY());
            }
            int floatErrorX = screenRect.left - (int)((float)screenRect.left);
            int floatErrorY = screenRect.top - (int)((float)screenRect.top);
            float scaleX = ViewHelper.getScaleX((View)mapView);
            float scaleY = ViewHelper.getScaleY((View)mapView);
            c.translate((float)screenRect.left * scaleX, (float)screenRect.top * scaleY);
            c.translate((float)floatErrorX, (float)floatErrorY);
            if (mapView.getMapOrientation() != 0.0f) {
                sSafeCanvas.rotate(mapView.getMapOrientation(), screenRect.exactCenterX(), screenRect.exactCenterY());
            }
        } else {
            SafeDrawOverlay.sSafeCanvas.xOffset = 0;
            SafeDrawOverlay.sSafeCanvas.yOffset = 0;
        }
        this.drawSafe(sSafeCanvas, mapView, shadow);
        if (this.mUseSafeCanvas) {
            c.restore();
        }
    }

    public boolean isUsingSafeCanvas() {
        return this.mUseSafeCanvas;
    }

    public void setUseSafeCanvas(boolean useSafeCanvas) {
        this.mUseSafeCanvas = useSafeCanvas;
    }
}

