/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.tileprovider;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.Log;
import com.mapbox.mapboxsdk.geometry.BoundingBox;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.tileprovider.IRegisterReceiver;
import com.mapbox.mapboxsdk.tileprovider.MapTile;
import com.mapbox.mapboxsdk.tileprovider.MapTileLayerBase;
import com.mapbox.mapboxsdk.tileprovider.MapTileRequestState;
import com.mapbox.mapboxsdk.tileprovider.modules.MapTileModuleLayerBase;
import com.mapbox.mapboxsdk.tileprovider.modules.NetworkAvailabilityCheck;
import com.mapbox.mapboxsdk.tileprovider.tilesource.ITileLayer;
import com.mapbox.mapboxsdk.util.BitmapUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import uk.co.senab.bitmapcache.CacheableBitmapDrawable;

public class MapTileLayerArray
extends MapTileLayerBase {
    protected final HashMap<MapTile, MapTileRequestState> mWorking = new HashMap();
    protected final List<MapTileModuleLayerBase> mTileProviderList;
    protected final List<MapTile> mUnaccessibleTiles = new ArrayList<MapTile>();
    protected final NetworkAvailabilityCheck mNetworkAvailabilityCheck;
    private static final String TAG = "MapTileLayerArray";

    protected MapTileLayerArray(Context context, ITileLayer pTileSource, IRegisterReceiver pRegisterReceiver) {
        this(context, pTileSource, pRegisterReceiver, null);
    }

    public MapTileLayerArray(Context context, ITileLayer pTileSource, IRegisterReceiver aRegisterReceiver, MapTileModuleLayerBase[] pTileProviderArray) {
        super(context, pTileSource);
        this.mNetworkAvailabilityCheck = new NetworkAvailabilityCheck(context);
        this.mTileProviderList = new ArrayList<MapTileModuleLayerBase>();
        if (pTileProviderArray != null) {
            this.mCacheKey = pTileProviderArray[0].getCacheKey();
            Collections.addAll(this.mTileProviderList, pTileProviderArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach() {
        if (this.getTileSource() != null) {
            this.getTileSource().detach();
        }
        Object object = this.mTileProviderList;
        synchronized (object) {
            for (MapTileModuleLayerBase tileProvider : this.mTileProviderList) {
                tileProvider.detach();
            }
        }
        object = this.mWorking;
        synchronized (object) {
            this.mWorking.clear();
        }
    }

    private boolean networkAvailable() {
        return this.mNetworkAvailabilityCheck == null || this.mNetworkAvailabilityCheck.getNetworkAvailable();
    }

    private boolean tileUnavailable(MapTile pTile) {
        if (this.mUnaccessibleTiles.size() > 0) {
            if (this.networkAvailable()) {
                this.mUnaccessibleTiles.clear();
            } else if (this.mUnaccessibleTiles.contains(pTile)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Drawable getMapTile(MapTile pTile, boolean allowRemote) {
        if (this.tileUnavailable(pTile)) {
            Log.d((String)TAG, (String)("MapTileLayerArray.getMapTile() tileUnavailable: " + pTile));
            return null;
        }
        CacheableBitmapDrawable tileDrawable = this.mTileCache.getMapTileFromMemory(pTile);
        if (tileDrawable != null && tileDrawable.isBitmapValid() && !BitmapUtils.isCacheDrawableExpired((Drawable)tileDrawable)) {
            tileDrawable.setBeingUsed(true);
            return tileDrawable;
        }
        if (allowRemote) {
            boolean alreadyInProgress = false;
            HashMap<MapTile, MapTileRequestState> hashMap = this.mWorking;
            synchronized (hashMap) {
                alreadyInProgress = this.mWorking.containsKey(pTile);
            }
            if (!alreadyInProgress) {
                MapTileRequestState state;
                Object object = this.mTileProviderList;
                synchronized (object) {
                    MapTileModuleLayerBase[] providerArray = new MapTileModuleLayerBase[this.mTileProviderList.size()];
                    state = new MapTileRequestState(pTile, this.mTileProviderList.toArray(providerArray), this);
                }
                object = this.mWorking;
                synchronized (object) {
                    alreadyInProgress = this.mWorking.containsKey(pTile);
                    if (alreadyInProgress) {
                        return null;
                    }
                    this.mWorking.put(pTile, state);
                }
                MapTileModuleLayerBase provider = this.findNextAppropriateProvider(state);
                if (provider != null) {
                    provider.loadMapTileAsync(state);
                } else {
                    this.mapTileRequestFailed(state);
                }
            }
            return tileDrawable;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mapTileRequestCompleted(MapTileRequestState aState, Drawable aDrawable) {
        HashMap<MapTile, MapTileRequestState> hashMap = this.mWorking;
        synchronized (hashMap) {
            this.mWorking.remove(aState.getMapTile());
        }
        super.mapTileRequestCompleted(aState, aDrawable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mapTileRequestFailed(MapTileRequestState aState) {
        MapTileModuleLayerBase nextProvider = this.findNextAppropriateProvider(aState);
        if (nextProvider != null) {
            nextProvider.loadMapTileAsync(aState);
        } else {
            HashMap<MapTile, MapTileRequestState> hashMap = this.mWorking;
            synchronized (hashMap) {
                this.mWorking.remove(aState.getMapTile());
            }
            if (!this.networkAvailable()) {
                this.mUnaccessibleTiles.add(aState.getMapTile());
            }
            super.mapTileRequestFailed(aState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mapTileRequestExpiredTile(MapTileRequestState aState, CacheableBitmapDrawable aDrawable) {
        super.mapTileRequestExpiredTile(aState, aDrawable);
        MapTileModuleLayerBase nextProvider = this.findNextAppropriateProvider(aState);
        if (nextProvider != null) {
            nextProvider.loadMapTileAsync(aState);
        } else {
            HashMap<MapTile, MapTileRequestState> hashMap = this.mWorking;
            synchronized (hashMap) {
                this.mWorking.remove(aState.getMapTile());
            }
        }
    }

    protected MapTileModuleLayerBase findNextAppropriateProvider(MapTileRequestState aState) {
        MapTileModuleLayerBase provider = null;
        boolean providerDoesntExist = false;
        boolean providerCantGetDataConnection = false;
        boolean providerCantServiceZoomlevel = false;
        do {
            if ((provider = aState.getNextProvider()) == null) continue;
            providerDoesntExist = !this.getProviderExists(provider);
            providerCantGetDataConnection = !this.useDataConnection() && provider.getUsesDataConnection();
            int zoomLevel = aState.getMapTile().getZ();
            boolean bl = providerCantServiceZoomlevel = (float)zoomLevel > provider.getMaximumZoomLevel() || (float)zoomLevel < provider.getMinimumZoomLevel();
        } while (provider != null && (providerDoesntExist || providerCantGetDataConnection || providerCantServiceZoomlevel));
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getProviderExists(MapTileModuleLayerBase provider) {
        List<MapTileModuleLayerBase> list = this.mTileProviderList;
        synchronized (list) {
            return this.mTileProviderList.contains(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getMinimumZoomLevel() {
        float result = 0.0f;
        List<MapTileModuleLayerBase> list = this.mTileProviderList;
        synchronized (list) {
            for (MapTileModuleLayerBase tileProvider : this.mTileProviderList) {
                result = Math.max(result, tileProvider.getMinimumZoomLevel());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getMaximumZoomLevel() {
        float result = 22.0f;
        List<MapTileModuleLayerBase> list = this.mTileProviderList;
        synchronized (list) {
            for (MapTileModuleLayerBase tileProvider : this.mTileProviderList) {
                result = Math.min(result, tileProvider.getMaximumZoomLevel());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTileSource(ITileLayer aTileSource) {
        super.setTileSource(aTileSource);
        this.mUnaccessibleTiles.clear();
        List<MapTileModuleLayerBase> list = this.mTileProviderList;
        synchronized (list) {
            this.mTileProviderList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNoSource() {
        List<MapTileModuleLayerBase> list = this.mTileProviderList;
        synchronized (list) {
            return this.mTileProviderList.size() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BoundingBox getBoundingBox() {
        BoundingBox result = null;
        List<MapTileModuleLayerBase> list = this.mTileProviderList;
        synchronized (list) {
            for (MapTileModuleLayerBase tileProvider : this.mTileProviderList) {
                BoundingBox providerBox = tileProvider.getBoundingBox();
                if (result == null) {
                    result = providerBox;
                    continue;
                }
                result = result.union(providerBox);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LatLng getCenterCoordinate() {
        float latitude = 0.0f;
        float longitude = 0.0f;
        int nb = 0;
        List<MapTileModuleLayerBase> list = this.mTileProviderList;
        synchronized (list) {
            for (MapTileModuleLayerBase tileProvider : this.mTileProviderList) {
                LatLng providerCenter = tileProvider.getCenterCoordinate();
                if (providerCenter == null) continue;
                latitude = (float)((double)latitude + providerCenter.getLatitude());
                longitude = (float)((double)longitude + providerCenter.getLongitude());
                ++nb;
            }
        }
        if (nb > 0) {
            return new LatLng(latitude /= (float)nb, longitude /= (float)nb);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getCenterZoom() {
        float centerZoom = 0.0f;
        int nb = 0;
        List<MapTileModuleLayerBase> list = this.mTileProviderList;
        synchronized (list) {
            for (MapTileModuleLayerBase tileProvider : this.mTileProviderList) {
                centerZoom += tileProvider.getCenterZoom();
                ++nb;
            }
        }
        if (centerZoom > 0.0f) {
            return centerZoom / (float)nb;
        }
        return (this.getMaximumZoomLevel() + this.getMinimumZoomLevel()) / 2.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTileSizePixels() {
        int result = 0;
        List<MapTileModuleLayerBase> list = this.mTileProviderList;
        synchronized (list) {
            Iterator<MapTileModuleLayerBase> i$ = this.mTileProviderList.iterator();
            if (i$.hasNext()) {
                MapTileModuleLayerBase tileProvider = i$.next();
                result += tileProvider.getTileSizePixels();
            }
        }
        return result;
    }
}

