/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.tileprovider.tilesource;

import android.content.Context;
import android.content.res.AssetManager;
import android.database.sqlite.SQLiteDatabase;
import android.os.Environment;
import android.util.Log;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.tileprovider.MapTile;
import com.mapbox.mapboxsdk.tileprovider.modules.MBTilesFileArchive;
import com.mapbox.mapboxsdk.tileprovider.modules.MapTileDownloader;
import com.mapbox.mapboxsdk.tileprovider.tilesource.TileLayer;
import com.mapbox.mapboxsdk.views.util.constants.MapViewConstants;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.co.senab.bitmapcache.CacheableBitmapDrawable;

public class MBTilesLayer
extends TileLayer
implements MapViewConstants,
MapboxConstants {
    private static final String TAG = "MBTilesLayer";
    MBTilesFileArchive mbTilesFileArchive;

    public MBTilesLayer(Context context, String url) {
        super(url.substring(url.lastIndexOf(47) + 1, url.lastIndexOf(46)), url);
        this.initialize(url, context);
    }

    public MBTilesLayer(String url) {
        this((Context)null, url);
    }

    public MBTilesLayer(File file) {
        super(file.getName(), file.getAbsolutePath());
        this.initialize(file);
    }

    public MBTilesLayer(SQLiteDatabase db) {
        super(MBTilesLayer.getFileName(db.getPath()), db.getPath());
        this.initialize(db);
    }

    private static final String getFileName(String path) {
        return path.substring(path.lastIndexOf(47) + 1, path.lastIndexOf(46));
    }

    private static File createFileFromInputStream(InputStream inputStream, String URL2) {
        try {
            File f = new File(URL2);
            FileOutputStream outputStream = new FileOutputStream(f);
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = inputStream.read(buffer)) > 0) {
                ((OutputStream)outputStream).write(buffer, 0, length);
            }
            ((OutputStream)outputStream).close();
            inputStream.close();
            return f;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Failed to create file from input stream.", (Throwable)e);
            return null;
        }
    }

    private void initialize(File file) {
        if (file != null) {
            this.mbTilesFileArchive = MBTilesFileArchive.getDatabaseFileArchive(file);
        }
        if (this.mbTilesFileArchive != null) {
            this.mMaximumZoomLevel = this.mbTilesFileArchive.getMaxZoomLevel();
            this.mMinimumZoomLevel = this.mbTilesFileArchive.getMinZoomLevel();
            this.mName = this.mbTilesFileArchive.getName();
            this.mDescription = this.mbTilesFileArchive.getDescription();
            this.mAttribution = this.mbTilesFileArchive.getAttribution();
            this.mBoundingBox = this.mbTilesFileArchive.getBounds();
            this.mCenter = this.mbTilesFileArchive.getCenter();
        }
    }

    private void initialize(SQLiteDatabase db) {
        if (db != null) {
            this.mbTilesFileArchive = new MBTilesFileArchive(db);
        }
        if (this.mbTilesFileArchive != null) {
            this.mMaximumZoomLevel = this.mbTilesFileArchive.getMaxZoomLevel();
            this.mMinimumZoomLevel = this.mbTilesFileArchive.getMinZoomLevel();
            this.mName = this.mbTilesFileArchive.getName();
            this.mDescription = this.mbTilesFileArchive.getDescription();
            this.mAttribution = this.mbTilesFileArchive.getAttribution();
            this.mBoundingBox = this.mbTilesFileArchive.getBounds();
            this.mCenter = this.mbTilesFileArchive.getCenter();
        }
    }

    private void initialize(String url, Context context) {
        this.initialize(this.getFile(url, context));
    }

    private File getFile(String url, Context context) {
        if (context != null) {
            AssetManager am = context.getAssets();
            try {
                InputStream inputStream = am.open(url);
                return MBTilesLayer.createFileFromInputStream(inputStream, Environment.getExternalStorageDirectory() + File.separator + url);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("MBTiles file not found in assets: " + e.toString()));
                return null;
            }
        }
        try {
            return new File(url);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("can't load MBTiles: " + e.toString()));
            return null;
        }
    }

    @Override
    public void detach() {
        if (this.mbTilesFileArchive != null) {
            this.mbTilesFileArchive.close();
            this.mbTilesFileArchive = null;
        }
    }

    public CacheableBitmapDrawable getDrawableFromTile(MapTileDownloader downloader, MapTile aTile, boolean hdpi) {
        InputStream stream;
        if (this.mbTilesFileArchive != null && (stream = this.mbTilesFileArchive.getInputStream(this, aTile)) != null) {
            CacheableBitmapDrawable result = downloader.getCache().putTileStream(aTile, stream, null);
            if (result == null) {
                Log.d((String)TAG, (String)"error reading stream from mbtiles");
            }
            return result;
        }
        return null;
    }
}

