/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.util;

import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Handler;
import com.mapbox.mapboxsdk.tileprovider.MapTile;
import com.mapbox.mapboxsdk.util.GeometryMath;
import com.mapbox.mapboxsdk.views.util.Projection;
import java.util.ArrayList;
import java.util.List;
import uk.co.senab.bitmapcache.CacheableBitmapDrawable;

public abstract class TileLooper {
    protected final Point mUpperLeft = new Point();
    protected final Point mLowerRight = new Point();
    protected final Point center = new Point();
    protected List<CacheableBitmapDrawable> mBeingUsedDrawables = new ArrayList<CacheableBitmapDrawable>();

    public final int loop(Canvas pCanvas, String pCacheKey, float pZoomLevel, int pTileSizePx, Rect pViewPort, Rect pClipRect) {
        Projection.pixelXYToTileXY(pViewPort.left, pViewPort.top, this.mUpperLeft);
        this.mUpperLeft.offset(-1, -1);
        Projection.pixelXYToTileXY(pViewPort.right, pViewPort.bottom, this.mLowerRight);
        this.mLowerRight.offset(1, 1);
        this.center.set((this.mUpperLeft.x + this.mLowerRight.x) / 2, (this.mUpperLeft.y + this.mLowerRight.y) / 2);
        int roundedZoom = (int)Math.floor(pZoomLevel);
        int mapTileUpperBound = 1 << roundedZoom;
        this.initializeLoop(pZoomLevel, pTileSizePx);
        for (int y = this.mUpperLeft.y; y <= this.mLowerRight.y; ++y) {
            for (int x = this.mUpperLeft.x; x <= this.mLowerRight.x; ++x) {
                int tileY = GeometryMath.mod(y, mapTileUpperBound);
                int tileX = GeometryMath.mod(x, mapTileUpperBound);
                MapTile tile = new MapTile(pCacheKey, roundedZoom, tileX, tileY);
                this.handleTile(pCanvas, pCacheKey, pTileSizePx, tile, x, y, pClipRect);
            }
        }
        this.finalizeLoop();
        return (this.mLowerRight.y - this.mUpperLeft.y) * (this.mLowerRight.x - this.mUpperLeft.x);
    }

    public abstract void initializeLoop(float var1, int var2);

    public abstract void handleTile(Canvas var1, String var2, int var3, MapTile var4, int var5, int var6, Rect var7);

    public void finalizeLoop() {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                for (CacheableBitmapDrawable drawable2 : TileLooper.this.mBeingUsedDrawables) {
                    drawable2.setBeingUsed(false);
                }
                TileLooper.this.mBeingUsedDrawables.clear();
            }
        }, 1L);
    }
}

