/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.geometry.LatLng;
import java.util.List;

public final class PolygonOptions {
    private Polygon polygon = new Polygon();

    public PolygonOptions add(LatLng point) {
        this.polygon.addPoint(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        for (LatLng point : points) {
            this.add(point);
        }
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng point : points) {
            this.add(point);
        }
        return this;
    }

    public PolygonOptions alpha(float alpha) {
        this.polygon.setAlpha(alpha);
        return this;
    }

    public float getAlpha() {
        return this.polygon.getAlpha();
    }

    public PolygonOptions fillColor(int color2) {
        this.polygon.setFillColor(color2);
        return this;
    }

    public int getFillColor() {
        return this.polygon.getFillColor();
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    public PolygonOptions strokeColor(int color2) {
        this.polygon.setStrokeColor(color2);
        return this;
    }

    public int getStrokeColor() {
        return this.polygon.getStrokeColor();
    }

    public List<LatLng> getPoints() {
        return this.polygon.getPoints();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolygonOptions polygon = (PolygonOptions)o;
        if (Float.compare(polygon.getAlpha(), this.getAlpha()) != 0) {
            return false;
        }
        if (this.getFillColor() != polygon.getFillColor()) {
            return false;
        }
        if (this.getStrokeColor() != polygon.getStrokeColor()) {
            return false;
        }
        return !(this.getPoints() == null ? polygon.getPoints() != null : !this.getPoints().equals(polygon.getPoints()));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getAlpha() != 0.0f ? Float.floatToIntBits(this.getAlpha()) : 0);
        result = 31 * result + this.getFillColor();
        result = 31 * result + this.getStrokeColor();
        result = 31 * result + (this.getPoints() != null ? this.getPoints().hashCode() : 0);
        return result;
    }
}

