/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.http;

import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;

class HTTPContext {
    private static final int CONNECTION_ERROR = 0;
    private static final int TEMPORARY_ERROR = 1;
    private static final int PERMANENT_ERROR = 2;
    private static final int CANCELED_ERROR = 3;
    private static HTTPContext mInstance = null;
    private OkHttpClient mClient = new OkHttpClient();

    private HTTPContext() {
    }

    public static HTTPContext getInstance() {
        if (mInstance == null) {
            mInstance = new HTTPContext();
        }
        return mInstance;
    }

    public HTTPRequest createRequest(long nativePtr, String resourceUrl, String userAgent, String etag, String modified) {
        return new HTTPRequest(nativePtr, resourceUrl, userAgent, etag, modified);
    }

    public class HTTPRequest
    implements Callback {
        private long mNativePtr = 0L;
        private Call mCall;
        private Request mRequest;

        private native void nativeOnFailure(long var1, int var3, String var4);

        private native void nativeOnResponse(long var1, int var3, String var4, String var5, String var6, String var7, String var8, byte[] var9);

        private HTTPRequest(long nativePtr, String resourceUrl, String userAgent, String etag, String modified) {
            this.mNativePtr = nativePtr;
            Request.Builder builder = new Request.Builder().url(resourceUrl).tag((Object)resourceUrl.toLowerCase(MapboxConstants.MAPBOX_LOCALE)).addHeader("User-Agent", userAgent);
            if (etag.length() > 0) {
                builder = builder.addHeader("If-None-Match", etag);
            } else if (modified.length() > 0) {
                builder = builder.addHeader("If-Modified-Since", modified);
            }
            this.mRequest = builder.build();
        }

        public void start() {
            this.mCall = HTTPContext.getInstance().mClient.newCall(this.mRequest);
            this.mCall.enqueue((Callback)this);
        }

        public void cancel() {
            this.mCall.cancel();
        }

        public void onFailure(Request request, IOException e) {
            int type = 2;
            if (e instanceof UnknownHostException || e instanceof SocketException || e instanceof ProtocolException || e instanceof SSLException) {
                type = 0;
            } else if (e instanceof InterruptedIOException) {
                type = 1;
            } else if (this.mCall.isCanceled()) {
                type = 3;
            }
            this.nativeOnFailure(this.mNativePtr, type, e.getMessage());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(Response response) throws IOException {
            byte[] body;
            try {
                body = response.body().bytes();
            }
            catch (IOException e) {
                this.onFailure(this.mRequest, e);
                return;
            }
            finally {
                response.body().close();
            }
            this.nativeOnResponse(this.mNativePtr, response.code(), response.message(), response.header("ETag"), response.header("Last-Modified"), response.header("Cache-Control"), response.header("Expires"), body);
        }
    }
}

