/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mapbox.mapboxsdk.R;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public final class ApiAccess {
    @Nullable
    public static String getToken(@NonNull Context context) {
        String accessToken = ApiAccess.getReleaseToken(context);
        if (TextUtils.isEmpty((CharSequence)accessToken)) {
            accessToken = ApiAccess.getDevelopmentToken(context);
        }
        return accessToken;
    }

    private static String getReleaseToken(@NonNull Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            return appInfo.metaData.getString("com.mapbox.AccessToken");
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getDevelopmentToken(@NonNull Context context) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(context.getResources().openRawResource(R.raw.token)));
            return reader.readLine();
        }
        catch (IOException e) {
            return null;
        }
    }
}

