/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.views;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.location.Location;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.views.MapView;
import com.mapzen.android.lost.api.LocationListener;
import com.mapzen.android.lost.api.LocationRequest;
import com.mapzen.android.lost.api.LocationServices;
import com.mapzen.android.lost.api.LostApiClient;

final class UserLocationView
extends View {
    private MapView mMapView;
    private static final int BLUE_COLOR = 967625727;
    private float mDensity;
    private boolean mShowMarker;
    private boolean mShowDirection;
    private boolean mShowAccuracy;
    private PointF mMarkerScreenPoint;
    private Matrix mMarkerScreenMatrix;
    private Paint mAccuracyPaintFill;
    private Paint mAccuracyPaintStroke;
    private Path mAccuracyPath;
    private RectF mAccuracyBounds;
    private Drawable mUserLocationDrawable;
    private RectF mUserLocationDrawableBoundsF;
    private Rect mUserLocationDrawableBounds;
    private Drawable mUserLocationBearingDrawable;
    private RectF mUserLocationBearingDrawableBoundsF;
    private Rect mUserLocationBearingDrawableBounds;
    private Drawable mUserLocationStaleDrawable;
    private RectF mUserLocationStaleDrawableBoundsF;
    private Rect mUserLocationStaleDrawableBounds;
    private Rect mDirtyRect;
    private RectF mDirtyRectF;
    private LatLng mMarkerCoordinate;
    private ValueAnimator mMarkerCoordinateAnimator;
    private float mMarkerDirection;
    private ObjectAnimator mMarkerDirectionAnimator;
    private float mMarkerAccuracy;
    private ObjectAnimator mMarkerAccuracyAnimator;
    private boolean mPaused = false;
    private LostApiClient mLocationClient;
    private LocationRequest mLocationRequest;
    private Location mUserLocation;
    private MyLocationListener mLocationListener;
    MapView.OnMyLocationChangeListener mOnMyLocationChangeListener;
    private int mMyLocationTrackingMode;

    public UserLocationView(MapView mapView, Context context) {
        super(context);
        this.initialize(mapView, context);
    }

    public UserLocationView(MapView mapView, Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(mapView, context);
    }

    public UserLocationView(MapView mapView, Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(mapView, context);
    }

    private void initialize(MapView mapView, Context context) {
        this.mMapView = mapView;
        this.setEnabled(false);
        this.setWillNotDraw(false);
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
        this.setLayoutParams(lp);
        this.mLocationClient = new LostApiClient.Builder(this.getContext()).build();
        this.mLocationRequest = LocationRequest.create().setFastestInterval(1000L).setSmallestDisplacement(3.0f).setPriority(100);
        Resources resources = context.getResources();
        this.mDensity = resources.getDisplayMetrics().density;
        this.mMarkerCoordinate = new LatLng(0.0, 0.0);
        this.mMarkerScreenPoint = new PointF();
        this.mMarkerScreenMatrix = new Matrix();
        this.mAccuracyPaintFill = new Paint();
        this.mAccuracyPaintFill.setAntiAlias(true);
        this.mAccuracyPaintFill.setStyle(Paint.Style.FILL);
        this.mAccuracyPaintFill.setColor(967625727);
        this.mAccuracyPaintFill.setAlpha(63);
        this.mAccuracyPaintStroke = new Paint();
        this.mAccuracyPaintStroke.setAntiAlias(true);
        this.mAccuracyPaintStroke.setStyle(Paint.Style.STROKE);
        this.mAccuracyPaintStroke.setStrokeWidth(0.5f * this.mDensity);
        this.mAccuracyPaintStroke.setColor(967625727);
        this.mAccuracyPaintStroke.setAlpha(127);
        this.mAccuracyPath = new Path();
        this.mAccuracyBounds = new RectF();
        this.mUserLocationDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.user_location);
        this.mUserLocationDrawableBounds = new Rect(-this.mUserLocationDrawable.getIntrinsicWidth() / 2, -this.mUserLocationDrawable.getIntrinsicHeight() / 2, this.mUserLocationDrawable.getIntrinsicWidth() / 2, this.mUserLocationDrawable.getIntrinsicHeight() / 2);
        this.mUserLocationDrawableBoundsF = new RectF((float)(-this.mUserLocationDrawable.getIntrinsicWidth() / 2), (float)(-this.mUserLocationDrawable.getIntrinsicHeight() / 2), (float)(this.mUserLocationDrawable.getIntrinsicWidth() / 2), (float)(this.mUserLocationDrawable.getIntrinsicHeight() / 2));
        this.mUserLocationDrawable.setBounds(this.mUserLocationDrawableBounds);
        this.mUserLocationBearingDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.user_location_bearing);
        this.mUserLocationBearingDrawableBounds = new Rect(-this.mUserLocationBearingDrawable.getIntrinsicWidth() / 2, -this.mUserLocationBearingDrawable.getIntrinsicHeight() / 2, this.mUserLocationBearingDrawable.getIntrinsicWidth() / 2, this.mUserLocationBearingDrawable.getIntrinsicHeight() / 2);
        this.mUserLocationBearingDrawableBoundsF = new RectF((float)(-this.mUserLocationBearingDrawable.getIntrinsicWidth() / 2), (float)(-this.mUserLocationBearingDrawable.getIntrinsicHeight() / 2), (float)(this.mUserLocationBearingDrawable.getIntrinsicWidth() / 2), (float)(this.mUserLocationBearingDrawable.getIntrinsicHeight() / 2));
        this.mUserLocationBearingDrawable.setBounds(this.mUserLocationBearingDrawableBounds);
        this.mUserLocationStaleDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.user_location_stale);
        this.mUserLocationStaleDrawableBounds = new Rect(-this.mUserLocationStaleDrawable.getIntrinsicWidth() / 2, -this.mUserLocationStaleDrawable.getIntrinsicHeight() / 2, this.mUserLocationStaleDrawable.getIntrinsicWidth() / 2, this.mUserLocationStaleDrawable.getIntrinsicHeight() / 2);
        this.mUserLocationStaleDrawableBoundsF = new RectF((float)(-this.mUserLocationStaleDrawable.getIntrinsicWidth() / 2), (float)(-this.mUserLocationStaleDrawable.getIntrinsicHeight() / 2), (float)(this.mUserLocationStaleDrawable.getIntrinsicWidth() / 2), (float)(this.mUserLocationStaleDrawable.getIntrinsicHeight() / 2));
        this.mUserLocationStaleDrawable.setBounds(this.mUserLocationStaleDrawableBounds);
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.mShowMarker) {
            return;
        }
        canvas.concat(this.mMarkerScreenMatrix);
        Drawable dotDrawable = this.mShowDirection ? this.mUserLocationBearingDrawable : this.mUserLocationDrawable;
        RectF dotBounds = this.mShowDirection ? this.mUserLocationBearingDrawableBoundsF : this.mUserLocationDrawableBoundsF;
        boolean willDraw = this.mShowAccuracy && !canvas.quickReject(this.mAccuracyPath, Canvas.EdgeType.AA);
        boolean bl = !canvas.quickReject(dotBounds, Canvas.EdgeType.AA);
        dotBounds.offset((float)((int)(-this.mMarkerScreenPoint.x)), (float)((int)(-this.mMarkerScreenPoint.y)));
        if (willDraw |= bl) {
            if (this.mShowAccuracy) {
                canvas.drawPath(this.mAccuracyPath, this.mAccuracyPaintFill);
                canvas.drawPath(this.mAccuracyPath, this.mAccuracyPaintStroke);
            }
            dotDrawable.draw(canvas);
        }
    }

    public void setMyLocationTrackingMode(int myLocationTrackingMode) {
        this.mMyLocationTrackingMode = myLocationTrackingMode;
        if (myLocationTrackingMode != 0 && this.mUserLocation != null) {
            this.mMapView.setCenterCoordinate(new LatLng(this.mUserLocation.getLatitude(), this.mUserLocation.getLongitude()));
        }
    }

    public int getMyLocationTrackingMode() {
        return this.mMyLocationTrackingMode;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setVisibility(enabled ? 0 : 4);
        this.toggleGps(enabled);
    }

    public void update() {
        if (this.isEnabled() && this.mShowMarker) {
            this.setVisibility(0);
            this.mMarkerScreenPoint = this.mMapView.toScreenLocation(this.mMarkerCoordinate);
            this.mMarkerScreenMatrix.reset();
            this.mMarkerScreenMatrix.setTranslate(this.mMarkerScreenPoint.x, this.mMarkerScreenPoint.y);
            if (this.mShowDirection) {
                this.mMarkerScreenMatrix.preRotate(this.mMarkerDirection + (float)this.mMapView.getDirection());
            }
            if (this.mShowAccuracy) {
                this.mAccuracyPath.reset();
                this.mAccuracyPath.addCircle(0.0f, 0.0f, (float)((double)this.mMarkerAccuracy / this.mMapView.getMetersPerPixelAtLatitude(this.mMarkerCoordinate.getLatitude())), Path.Direction.CW);
                this.mAccuracyPath.computeBounds(this.mAccuracyBounds, false);
                this.mAccuracyBounds.inset(-1.0f, -1.0f);
            }
            if (this.mDirtyRect == null) {
                this.mDirtyRect = new Rect();
                this.mDirtyRectF = new RectF();
            } else {
                this.invalidate(this.mDirtyRect);
            }
            RectF dotBounds = this.mShowDirection ? this.mUserLocationBearingDrawableBoundsF : this.mUserLocationDrawableBoundsF;
            RectF largerBounds = this.mAccuracyBounds.contains(dotBounds) ? this.mAccuracyBounds : dotBounds;
            this.mMarkerScreenMatrix.mapRect(this.mDirtyRectF, largerBounds);
            this.mDirtyRectF.roundOut(this.mDirtyRect);
            this.invalidate(this.mDirtyRect);
        } else {
            this.setVisibility(4);
        }
    }

    public Location getLocation() {
        return this.mUserLocation;
    }

    private void toggleGps(boolean enableGps) {
        if (this.mLocationClient == null) {
            return;
        }
        if (enableGps) {
            if (!this.mLocationClient.isConnected()) {
                this.mUserLocation = null;
                this.mLocationClient.connect();
                this.setLocation(LocationServices.FusedLocationApi.getLastLocation());
                this.mLocationListener = new MyLocationListener();
                LocationServices.FusedLocationApi.requestLocationUpdates(this.mLocationRequest, (LocationListener)this.mLocationListener);
            }
        } else if (this.mLocationClient.isConnected()) {
            LocationServices.FusedLocationApi.removeLocationUpdates((LocationListener)this.mLocationListener);
            this.mLocationListener = null;
            this.mLocationClient.disconnect();
            this.mUserLocation = null;
        }
    }

    private void setLocation(Location location) {
        if (location == null) {
            this.mShowMarker = false;
            this.mShowDirection = false;
            this.mShowAccuracy = false;
            this.cancelAnimations();
            this.mUserLocation = null;
            return;
        }
        if (this.mMarkerCoordinateAnimator != null) {
            this.mMarkerCoordinateAnimator.end();
            this.mMarkerCoordinateAnimator = null;
        }
        if (this.mMarkerDirectionAnimator != null) {
            this.mMarkerDirectionAnimator.end();
            this.mMarkerDirectionAnimator = null;
        }
        if (this.mMarkerAccuracyAnimator != null) {
            this.mMarkerAccuracyAnimator.end();
            this.mMarkerAccuracyAnimator = null;
        }
        this.mShowMarker = true;
        LatLng previousCoordinate = this.mUserLocation == null ? new LatLng(location) : new LatLng(this.mUserLocation);
        if (this.mMyLocationTrackingMode == 0) {
            this.mMarkerCoordinateAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            this.mMarkerCoordinateAnimator.setDuration(1000L);
            this.mMarkerCoordinateAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new MarkerCoordinateAnimatorListener(previousCoordinate, new LatLng(location)));
            this.mMarkerCoordinateAnimator.start();
        } else {
            this.mMarkerCoordinate = new LatLng(location);
            this.mMapView.setCenterCoordinate(this.mMarkerCoordinate, true);
        }
        this.mShowDirection = location.hasBearing();
        if (this.mShowDirection) {
            float newDir;
            float oldDir;
            float diff;
            if (this.mUserLocation != null && this.mUserLocation.hasBearing()) {
                this.mMarkerDirection = this.mUserLocation.getBearing();
            }
            if ((diff = (oldDir = this.mMarkerDirection) - (newDir = location.getBearing())) > 180.0f) {
                newDir += 360.0f;
            } else if (diff < -180.0f) {
                newDir -= 360.0f;
            }
            this.mMarkerDirectionAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"direction", (float[])new float[]{oldDir, newDir});
            this.mMarkerDirectionAnimator.setDuration(1000L);
            this.mMarkerDirectionAnimator.start();
        }
        this.mShowAccuracy = location.hasAccuracy();
        if (this.mShowAccuracy) {
            if (this.mUserLocation != null && this.mUserLocation.hasAccuracy()) {
                this.mMarkerAccuracy = this.mUserLocation.getAccuracy();
            }
            this.mMarkerAccuracyAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"accuracy", (float[])new float[]{location.getAccuracy()});
            this.mMarkerAccuracyAnimator.setDuration(1000L);
            this.mMarkerAccuracyAnimator.start();
        }
        this.mUserLocation = location;
        this.updateOnNextFrame();
        if (this.mOnMyLocationChangeListener != null) {
            this.mOnMyLocationChangeListener.onMyLocationChange(location);
        }
    }

    void updateOnNextFrame() {
        this.mMapView.update();
    }

    public void pause() {
        this.mPaused = true;
        this.toggleGps(false);
    }

    public void resume() {
        this.mPaused = false;
        if (this.isEnabled()) {
            this.toggleGps(true);
        }
    }

    public void setOnMyLocationChangeListener(@Nullable MapView.OnMyLocationChangeListener listener) {
        this.mOnMyLocationChangeListener = listener;
    }

    public float getDirection() {
        return this.mMarkerDirection;
    }

    public void setDirection(float direction) {
        this.mMarkerDirection = direction % 360.0f;
        this.updateOnNextFrame();
    }

    public float getAccuracy() {
        return this.mMarkerAccuracy;
    }

    public void setAccuracy(float accuracy) {
        this.mMarkerAccuracy = accuracy;
        this.updateOnNextFrame();
    }

    public void cancelAnimations() {
        if (this.mMarkerCoordinateAnimator != null) {
            this.mMarkerCoordinateAnimator.cancel();
            this.mMarkerCoordinateAnimator = null;
        }
        if (this.mMarkerDirectionAnimator != null) {
            this.mMarkerDirectionAnimator.cancel();
            this.mMarkerDirectionAnimator = null;
        }
        if (this.mMarkerAccuracyAnimator != null) {
            this.mMarkerAccuracyAnimator.cancel();
            this.mMarkerAccuracyAnimator = null;
        }
    }

    private class MarkerCoordinateAnimatorListener
    implements ValueAnimator.AnimatorUpdateListener {
        private double mFromLat;
        private double mFromLng;
        private double mToLat;
        private double mToLng;

        private MarkerCoordinateAnimatorListener(LatLng from, LatLng to) {
            this.mFromLat = from.getLatitude();
            this.mFromLng = from.getLongitude();
            this.mToLat = to.getLatitude();
            this.mToLng = to.getLongitude();
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            float frac = animation.getAnimatedFraction();
            double latitude = this.mFromLat + (this.mToLat - this.mFromLat) * (double)frac;
            double longitude = this.mFromLng + (this.mToLng - this.mFromLng) * (double)frac;
            UserLocationView.this.mMarkerCoordinate.setLatitude(latitude);
            UserLocationView.this.mMarkerCoordinate.setLongitude(longitude);
            UserLocationView.this.updateOnNextFrame();
        }
    }

    private class MyLocationListener
    implements LocationListener {
        private MyLocationListener() {
        }

        public void onLocationChanged(Location location) {
            if (UserLocationView.this.mPaused) {
                return;
            }
            UserLocationView.this.setLocation(location);
        }
    }
}

