/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.geometry;

import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import com.mapbox.mapboxsdk.geometry.ILatLng;
import com.mapbox.mapboxsdk.utils.MathUtils;

public class LatLng
implements ILatLng,
Parcelable {
    public static final Parcelable.Creator<LatLng> CREATOR = new Parcelable.Creator<LatLng>(){

        public LatLng createFromParcel(Parcel in) {
            return new LatLng(in);
        }

        public LatLng[] newArray(int size) {
            return new LatLng[size];
        }
    };
    private double latitude;
    private double longitude;
    private double altitude = 0.0;

    public LatLng() {
        this.latitude = 0.0;
        this.longitude = 0.0;
    }

    public LatLng(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public LatLng(double latitude, double longitude, double altitude) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
    }

    public LatLng(Location location) {
        this(location.getLatitude(), location.getLongitude(), location.getAltitude());
    }

    public LatLng(LatLng aLatLng) {
        this.latitude = aLatLng.latitude;
        this.longitude = aLatLng.longitude;
        this.altitude = aLatLng.altitude;
    }

    protected LatLng(Parcel in) {
        this.latitude = in.readDouble();
        this.longitude = in.readDouble();
        this.altitude = in.readDouble();
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    @Override
    public double getLatitude() {
        return this.latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    @Override
    public double getLongitude() {
        return this.longitude;
    }

    public void setAltitude(double altitude) {
        this.altitude = altitude;
    }

    @Override
    public double getAltitude() {
        return this.altitude;
    }

    public LatLng wrap() {
        LatLng wrappedVersion = new LatLng(this);
        double lon = wrappedVersion.getLongitude();
        if (lon < -180.0 || lon > 180.0) {
            wrappedVersion.setLongitude(MathUtils.wrap(wrappedVersion.getLongitude(), -180.0, 180.0));
        }
        return wrappedVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LatLng latLng = (LatLng)o;
        return Double.compare(latLng.altitude, this.altitude) == 0 && Double.compare(latLng.latitude, this.latitude) == 0 && Double.compare(latLng.longitude, this.longitude) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.latitude);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.altitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "LatLng [latitude=" + this.latitude + ", longitude=" + this.longitude + ", altitude=" + this.altitude + "]";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeDouble(this.latitude);
        out.writeDouble(this.longitude);
        out.writeDouble(this.altitude);
    }

    public double distanceTo(LatLng other) {
        if (this.latitude == other.latitude && this.longitude == other.longitude) {
            return 0.0;
        }
        double a1 = Math.PI / 180 * this.latitude;
        double a2 = Math.PI / 180 * this.longitude;
        double b1 = Math.PI / 180 * other.getLatitude();
        double b2 = Math.PI / 180 * other.getLongitude();
        double cosa1 = Math.cos(a1);
        double cosb1 = Math.cos(b1);
        double t1 = cosa1 * Math.cos(a2) * cosb1 * Math.cos(b2);
        double t2 = cosa1 * Math.sin(a2) * cosb1 * Math.sin(b2);
        double t3 = Math.sin(a1) * Math.sin(b1);
        double tt = Math.acos(t1 + t2 + t3);
        return 6378137.0 * tt;
    }
}

