/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api.rx.geocoding.v5;

import com.google.gson.Gson;
import com.mapbox.services.api.ServicesException;
import com.mapbox.services.api.geocoding.v5.MapboxGeocoding;
import com.mapbox.services.api.geocoding.v5.models.GeocodingResponse;
import com.mapbox.services.api.rx.geocoding.v5.GeocodingServiceRx;
import java.util.List;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;
import rx.Observable;

public class MapboxGeocodingRx
extends MapboxGeocoding {
    private GeocodingServiceRx serviceRx = null;
    private Observable<GeocodingResponse> observable = null;
    private Observable<List<GeocodingResponse>> batchObservable = null;

    public MapboxGeocodingRx(Builder builder) {
        super((MapboxGeocoding.Builder)builder);
    }

    private GeocodingServiceRx getServiceRx() {
        if (this.serviceRx != null) {
            return this.serviceRx;
        }
        Retrofit retrofit = new Retrofit.Builder().client(this.getOkHttpClient()).baseUrl(this.builder.getBaseUrl()).addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.getGson())).build();
        this.serviceRx = (GeocodingServiceRx)retrofit.create(GeocodingServiceRx.class);
        return this.serviceRx;
    }

    public Observable<GeocodingResponse> getObservable() {
        if (this.observable != null) {
            return this.observable;
        }
        if (this.builder.getQuery().contains(";")) {
            throw new IllegalArgumentException("Use getBatchObservable() for batch calls.");
        }
        this.observable = this.getServiceRx().getObservable(MapboxGeocodingRx.getHeaderUserAgent((String)this.builder.getClientAppName()), this.builder.getMode(), this.builder.getQuery(), this.builder.getAccessToken(), this.builder.getCountry(), this.builder.getProximity(), this.builder.getGeocodingTypes(), this.builder.getAutocomplete(), this.builder.getBbox(), this.builder.getLimit(), this.builder.getLanguage());
        return this.observable;
    }

    public Observable<List<GeocodingResponse>> getBatchObservable() {
        if (this.batchObservable != null) {
            return this.batchObservable;
        }
        if (!this.builder.getQuery().contains(";")) {
            throw new IllegalArgumentException("Use getObservable() for non-batch calls.");
        }
        this.batchObservable = this.getServiceRx().getBatchObservable(MapboxGeocodingRx.getHeaderUserAgent((String)this.builder.getClientAppName()), this.builder.getMode(), this.builder.getQuery(), this.builder.getAccessToken(), this.builder.getCountry(), this.builder.getProximity(), this.builder.getGeocodingTypes(), this.builder.getAutocomplete(), this.builder.getBbox(), this.builder.getLimit(), this.builder.getLanguage());
        return this.batchObservable;
    }

    public static class Builder
    extends MapboxGeocoding.Builder<Builder> {
        public MapboxGeocodingRx build() throws ServicesException {
            super.build();
            return new MapboxGeocodingRx(this);
        }
    }
}

