/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api.rx.optimizedtrips.v1;

import com.mapbox.services.api.ServicesException;
import com.mapbox.services.api.optimizedtrips.v1.MapboxOptimizedTrips;
import com.mapbox.services.api.optimizedtrips.v1.models.OptimizedTripsResponse;
import com.mapbox.services.api.rx.optimizedtrips.v1.OptimizedTripsServiceRx;
import io.reactivex.Observable;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class MapboxOptimizedTripsRx
extends MapboxOptimizedTrips {
    private OptimizedTripsServiceRx serviceRx = null;
    private Observable<OptimizedTripsResponse> observable = null;

    public MapboxOptimizedTripsRx(Builder builder) {
        super((MapboxOptimizedTrips.Builder)builder);
    }

    private OptimizedTripsServiceRx getServiceRx() {
        if (this.serviceRx != null) {
            return this.serviceRx;
        }
        Retrofit retrofit = new Retrofit.Builder().client(this.getOkHttpClient()).baseUrl(this.builder.getBaseUrl()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        this.serviceRx = (OptimizedTripsServiceRx)retrofit.create(OptimizedTripsServiceRx.class);
        return this.serviceRx;
    }

    public Observable<OptimizedTripsResponse> getObservable() {
        if (this.observable != null) {
            return this.observable;
        }
        this.observable = this.getServiceRx().getObservable(MapboxOptimizedTripsRx.getHeaderUserAgent((String)this.builder.getClientAppName()), this.builder.getUser(), this.builder.getProfile(), this.builder.getCoordinates(), this.builder.getAccessToken(), this.builder.getRoundTrip(), this.builder.getRadiuses(), this.builder.getBearings(), this.builder.getSteps(), this.builder.getOverview(), this.builder.getGeometries(), this.builder.getAnnotation(), this.builder.getDestination(), this.builder.getSource());
        return this.observable;
    }

    public static class Builder
    extends MapboxOptimizedTrips.Builder<Builder> {
        public MapboxOptimizedTripsRx build() throws ServicesException {
            super.build();
            return new MapboxOptimizedTripsRx(this);
        }
    }
}

