/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api.rx.distance.v1;

import com.google.gson.Gson;
import com.mapbox.services.api.ServicesException;
import com.mapbox.services.api.distance.v1.MapboxDistance;
import com.mapbox.services.api.distance.v1.models.DistanceResponse;
import com.mapbox.services.api.rx.distance.v1.DistanceServiceRx;
import io.reactivex.Observable;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class MapboxDistanceRx
extends MapboxDistance {
    private DistanceServiceRx serviceRx = null;
    private Observable<DistanceResponse> observable = null;

    public MapboxDistanceRx(Builder builder) {
        super((MapboxDistance.Builder)builder);
    }

    private DistanceServiceRx getServiceRx() {
        if (this.serviceRx != null) {
            return this.serviceRx;
        }
        Retrofit retrofit = new Retrofit.Builder().client(this.getOkHttpClient()).baseUrl(this.builder.getBaseUrl()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.getGson())).build();
        this.serviceRx = (DistanceServiceRx)retrofit.create(DistanceServiceRx.class);
        return this.serviceRx;
    }

    public Observable<DistanceResponse> getObservable() {
        if (this.observable != null) {
            return this.observable;
        }
        this.observable = this.getServiceRx().getObservable(MapboxDistanceRx.getHeaderUserAgent((String)this.builder.getClientAppName()), this.builder.getUser(), this.builder.getProfile(), this.builder.getAccessToken(), this.builder.getCoordinates());
        return this.observable;
    }

    public static class Builder
    extends MapboxDistance.Builder<Builder> {
        public MapboxDistanceRx build() throws ServicesException {
            super.build();
            return new MapboxDistanceRx(this);
        }
    }
}

