/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.core;

import java.io.IOException;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class MapboxService<T> {
    private boolean enableDebug;
    private OkHttpClient okHttpClient;
    private Call.Factory callFactory;

    public abstract Response<T> executeCall() throws IOException;

    public abstract void enqueueCall(Callback<T> var1);

    public abstract void cancelCall();

    public abstract Call<T> cloneCall();

    public boolean isEnableDebug() {
        return this.enableDebug;
    }

    public void enableDebug(boolean enableDebug) {
        this.enableDebug = enableDebug;
    }

    public Call.Factory getCallFactory() {
        return this.callFactory;
    }

    public void setCallFactory(Call.Factory callFactory) {
        this.callFactory = callFactory;
    }

    public OkHttpClient getOkHttpClient() {
        if (this.okHttpClient == null) {
            if (this.isEnableDebug()) {
                HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
                logging.setLevel(HttpLoggingInterceptor.Level.BASIC);
                OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
                httpClient.addInterceptor((Interceptor)logging);
                this.okHttpClient = httpClient.build();
            } else {
                this.okHttpClient = new OkHttpClient();
            }
        }
        return this.okHttpClient;
    }
}

