/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.common.accessor;

import com.mx.path.core.common.http.HttpStatus;
import javax.annotation.Nullable;

public enum PathResponseStatus {
    OK(200, "Successful", false),
    ACCEPTED(202, "Accepted", false),
    NO_CONTENT(204, "No response context", false),
    BAD_REQUEST(400, "Bad request", true),
    UNAUTHORIZED(401, "Unauthorized", true),
    NOT_ALLOWED(403, "Operation not allowed", true),
    NOT_FOUND(404, "Resource not found", true),
    USER_ERROR(422, "User-correctable error", true),
    TOO_MANY_REQUESTS(429, "Too many requests", true),
    INTERNAL_ERROR(500, "Internal error", true),
    NOT_IMPLEMENTED(501, "API not implemented", true),
    UNAVAILABLE(503, "Service unavailable", true),
    TIMEOUT(504, "Timeout", true),
    UPSTREAM_SERVICE_UNAVAILABLE(531, "Upstream service unavailable", true);

    private final String description;
    private final boolean error;
    private final int value;

    private PathResponseStatus(int value, String description, boolean error) {
        this.description = description;
        this.error = error;
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public boolean isError() {
        return this.error;
    }

    public String getReasonPhrase() {
        return this.description;
    }

    public Series series() {
        return Series.valueOf(this);
    }

    public HttpStatus toHttpStatus() {
        return HttpStatus.resolve(this.value);
    }

    public String toString() {
        return this.value + " " + this.name();
    }

    public static PathResponseStatus valueOf(int statusCode) {
        PathResponseStatus status = PathResponseStatus.resolve(statusCode);
        if (status == null) {
            throw new IllegalArgumentException("No matching constant for [" + statusCode + "]");
        }
        return status;
    }

    @Nullable
    public static PathResponseStatus resolve(int statusCode) {
        for (PathResponseStatus status : PathResponseStatus.values()) {
            if (status.value != statusCode) continue;
            return status;
        }
        return null;
    }

    public static enum Series {
        INFORMATIONAL(1),
        SUCCESSFUL(2),
        REDIRECTION(3),
        CLIENT_ERROR(4),
        SERVER_ERROR(5);

        private final int value;

        private Series(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static Series valueOf(PathResponseStatus status) {
            return Series.valueOf(status.value);
        }

        public static Series valueOf(int statusCode) {
            Series series = Series.resolve(statusCode);
            if (series == null) {
                throw new IllegalArgumentException("No matching constant for [" + statusCode + "]");
            }
            return series;
        }

        @Nullable
        public static Series resolve(int statusCode) {
            int seriesCode = statusCode / 100;
            for (Series series : Series.values()) {
                if (series.value != seriesCode) continue;
                return series;
            }
            return null;
        }
    }
}

