/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.common.collection;

import com.mx.path.core.common.collection.MultiValueMappable;
import com.mx.path.core.common.collection.SingleValueMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiValueMap<K, V>
implements Map<K, List<V>>,
MultiValueMappable<K, V> {
    private Map<K, List<V>> rawMap;

    public static <K, V> MultiValueMap<K, V> forMap(Map<K, List<V>> rawMap) {
        MultiValueMap<K, V> multiValueMap = new MultiValueMap<K, V>();
        multiValueMap.setRawMap(rawMap);
        return multiValueMap;
    }

    @Override
    public Map<K, List<V>> getRawMap() {
        return this.rawMap;
    }

    @Override
    public void setRawMap(Map<K, List<V>> rawMap) {
        this.rawMap = rawMap;
    }

    public MultiValueMap() {
        this.rawMap = new LinkedHashMap<K, List<V>>();
    }

    public MultiValueMap(MultiValueMappable<K, V> multiValueMappable) {
        this.rawMap = multiValueMappable.getRawMap();
    }

    public void add(K key, V value) {
        List values = this.getRawMap().computeIfAbsent(key, k -> new LinkedList());
        values.add(value);
    }

    public void addAll(K key, List<? extends V> values) {
        List currentValues = this.getRawMap().computeIfAbsent(key, k -> new LinkedList());
        currentValues.addAll(values);
    }

    public void addIfAbsent(K key, V value) {
        if (!this.containsKey(key)) {
            this.add(key, value);
        }
    }

    @Override
    public void clear() {
        this.getRawMap().clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getRawMap().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.getRawMap().containsValue(value)) {
            return true;
        }
        return this.flatValues().contains(value);
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.getRawMap().entrySet();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (MultiValueMappable.class.isAssignableFrom(other.getClass())) {
            return this.rawMap.equals(((MultiValueMappable)other).getRawMap());
        }
        return this.getRawMap().equals(other);
    }

    @Override
    public List<V> get(Object key) {
        return this.getRawMap().get(key);
    }

    public V getFirst(K key) {
        List<V> values = this.getRawMap().get(key);
        if (values != null && !values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    @Override
    public int hashCode() {
        return this.getRawMap().hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.getRawMap().isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.getRawMap().keySet();
    }

    @Override
    public List<V> put(K key, List<V> value) {
        return this.getRawMap().put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends List<V>> map) {
        this.getRawMap().putAll(map);
    }

    @Override
    public List<V> remove(Object key) {
        return this.getRawMap().remove(key);
    }

    public void set(K key, V value) {
        LinkedList<V> values = new LinkedList<V>();
        values.add(value);
        this.getRawMap().put(key, values);
    }

    @Override
    public int size() {
        return this.getRawMap().size();
    }

    public SingleValueMap<K, V> toSingleValueMap() {
        return new SingleValueMap(this);
    }

    public String toString() {
        return this.getRawMap().toString();
    }

    @Override
    public Collection<List<V>> values() {
        return this.getRawMap().values();
    }
}

