/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.common.collection;

import com.mx.path.core.common.collection.ObjectMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public class ObjectArray
extends ArrayList<Object> {
    public final ObjectArray createArray() {
        ObjectArray array = new ObjectArray();
        this.add(array);
        return array;
    }

    public final ObjectMap createMap() {
        ObjectMap map = new ObjectMap();
        this.add(map);
        return map;
    }

    public final <T> T getAs(Class<T> t, int index) {
        return (T)this.get(index);
    }

    public final <T> T getAs(Class<T> t, int index, T def) {
        if (this.isNotNull(index)) {
            return (T)this.get(index);
        }
        return def;
    }

    public final ObjectArray getArray(int index) {
        if (this.isArray(index)) {
            return (ObjectArray)this.get(index);
        }
        return null;
    }

    @Nullable
    public final Boolean getAsBoolean(int index) {
        if (this.isValue(index)) {
            Object value = this.get(index);
            if (value.getClass() == Boolean.class) {
                return (Boolean)value;
            }
            if (value.getClass() == Double.class) {
                value = ((Double)value).intValue();
            }
            if (value.getClass() == BigDecimal.class) {
                value = ((BigDecimal)value).intValue();
            }
            Object valueToTest = value;
            return ObjectMap.TRUE_VALUES.stream().anyMatch(trueValue -> Objects.equals(trueValue, valueToTest));
        }
        return null;
    }

    public final boolean getAsBoolean(int key, boolean def) {
        Boolean value = this.getAsBoolean(key);
        if (value == null) {
            return def;
        }
        return value;
    }

    public final Integer getAsInteger(int index) {
        if (this.isValue(index)) {
            Object value = this.get(index);
            if (value.getClass() == Integer.class || value.getClass() == Double.class) {
                return (Integer)value;
            }
            if (value.getClass() == Long.class) {
                return ((Long)value).intValue();
            }
            if (value.getClass() == BigDecimal.class) {
                return ((BigDecimal)value).intValue();
            }
            if (value.getClass() == String.class) {
                return Integer.parseInt((String)value);
            }
        }
        return null;
    }

    public final Integer getAsInteger(int index, int def) {
        Integer value = this.getAsInteger(index);
        if (value == null) {
            return def;
        }
        return value;
    }

    public final Long getAsLong(int index) {
        if (this.isValue(index)) {
            Object value = this.get(index);
            if (value.getClass() == Long.class || value.getClass() == Double.class) {
                return (Long)value;
            }
            if (value.getClass() == Integer.class) {
                return ((Integer)value).longValue();
            }
            if (value.getClass() == BigDecimal.class) {
                return ((BigDecimal)value).longValue();
            }
            if (value.getClass() == String.class) {
                return Long.parseLong((String)value);
            }
        }
        return null;
    }

    public final Long getAsLong(int index, long def) {
        Long value = this.getAsLong(index);
        if (value == null) {
            return def;
        }
        return value;
    }

    public final String getAsString(int index) {
        if (this.isValue(index)) {
            return String.valueOf(this.get(index));
        }
        return null;
    }

    public final String getAsString(int index, String def) {
        String value = this.getAsString(index);
        if (value == null) {
            return def;
        }
        return value;
    }

    public final ObjectMap getMap(int index) {
        if (this.isMap(index)) {
            return (ObjectMap)this.get(index);
        }
        return null;
    }

    public final boolean isArray(int index) {
        return this.isNotNull(index) && ObjectArray.class.isAssignableFrom(this.get(index).getClass());
    }

    public final boolean isMap(int index) {
        return this.isNotNull(index) && ObjectMap.class.isAssignableFrom(this.get(index).getClass());
    }

    public final boolean isValue(int index) {
        if (this.isNotNull(index)) {
            Class<?> valueClass = this.get(index).getClass();
            return valueClass == String.class || valueClass == Boolean.class || valueClass == Integer.class || valueClass == Long.class || valueClass == BigDecimal.class || valueClass == Float.class;
        }
        return false;
    }

    public final boolean isNotNull(int index) {
        return !this.isNull(index);
    }

    public final boolean isNull(int index) {
        return this.get(index) == null;
    }

    @Override
    public final Object get(int index) {
        if (index >= this.size()) {
            return null;
        }
        return super.get(index);
    }
}

