/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.common.collection;

import com.mx.path.core.common.collection.ObjectArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class ObjectMap
extends LinkedHashMap<String, Object> {
    public static final List<Object> TRUE_VALUES;

    public final ObjectArray createArray(String key) {
        ObjectArray newArray = new ObjectArray();
        this.put(key, newArray);
        return newArray;
    }

    public final ObjectMap createMap(String key) {
        ObjectMap map = new ObjectMap();
        this.put(key, map);
        return map;
    }

    public final ObjectMap deepMerge(ObjectMap m) {
        m.forEach((k, v) -> {
            if (this.isMap((String)k) && v instanceof ObjectMap) {
                this.getMap((String)k).deepMerge((ObjectMap)v);
            } else if (this.isArray((String)k) && v instanceof ObjectArray) {
                this.getArray((String)k).addAll((ObjectArray)v);
            } else {
                this.put(k, v);
            }
        });
        return this;
    }

    public final <T> T getAs(Class<T> t, String key) {
        return (T)this.get(key);
    }

    public final <T> T getAs(Class<T> t, String key, T def) {
        if (this.isNotNull(key)) {
            return (T)this.get(key);
        }
        return def;
    }

    public final ObjectArray getArray(String key) {
        if (this.isArray(key)) {
            return this.getAs(ObjectArray.class, key);
        }
        return null;
    }

    @Nullable
    public final Boolean getAsBoolean(String key) {
        if (this.isValue(key)) {
            Object value = this.get(key);
            if (value.getClass() == Boolean.class) {
                return (Boolean)value;
            }
            if (value.getClass() == Double.class) {
                value = ((Double)value).intValue();
            }
            if (value.getClass() == BigDecimal.class) {
                value = ((BigDecimal)value).intValue();
            }
            Object valueToTest = value;
            return TRUE_VALUES.stream().anyMatch(trueValue -> Objects.equals(trueValue, valueToTest));
        }
        return null;
    }

    public final boolean getAsBoolean(String key, boolean def) {
        Boolean value = this.getAsBoolean(key);
        if (value == null) {
            return def;
        }
        return value;
    }

    public final Integer getAsInteger(String key) {
        if (this.isValue(key)) {
            Object value = this.get(key);
            if (value.getClass() == Integer.class || value.getClass() == Double.class) {
                return (Integer)value;
            }
            if (value.getClass() == Long.class) {
                return ((Long)value).intValue();
            }
            if (value.getClass() == BigDecimal.class) {
                return ((BigDecimal)value).intValue();
            }
            if (value.getClass() == String.class) {
                return Integer.parseInt((String)value);
            }
        }
        return null;
    }

    public final Integer getAsInteger(String key, int def) {
        Integer value = this.getAsInteger(key);
        if (value == null) {
            return def;
        }
        return value;
    }

    public final Long getAsLong(String key) {
        if (this.isValue(key)) {
            Object value = this.get(key);
            if (value.getClass() == Long.class || value.getClass() == Double.class) {
                return (Long)value;
            }
            if (value.getClass() == Integer.class) {
                return ((Integer)value).longValue();
            }
            if (value.getClass() == BigDecimal.class) {
                return ((BigDecimal)value).longValue();
            }
            if (value.getClass() == String.class) {
                return Long.parseLong((String)value);
            }
        }
        return null;
    }

    public final Long getAsLong(String key, long def) {
        Long value = this.getAsLong(key);
        if (value == null) {
            return def;
        }
        return value;
    }

    public final String getAsString(String key) {
        if (this.isValue(key)) {
            return String.valueOf(this.get(key));
        }
        return null;
    }

    public final String getAsString(String key, String def) {
        String value = this.getAsString(key);
        if (value == null) {
            return def;
        }
        return value;
    }

    public final ObjectMap getMap(String key) {
        if (this.isMap(key)) {
            return this.getAs(ObjectMap.class, key);
        }
        return null;
    }

    public final boolean isArray(String key) {
        if (this.isNotNull(key)) {
            return ObjectArray.class.isAssignableFrom(this.get(key).getClass());
        }
        return false;
    }

    public final boolean isMap(String key) {
        if (this.isNotNull(key)) {
            return ObjectMap.class.isAssignableFrom(this.get(key).getClass());
        }
        return false;
    }

    public final boolean isValue(String key) {
        if (this.isNotNull(key)) {
            Class<?> valueClass = this.get(key).getClass();
            return valueClass == String.class || valueClass == Boolean.class || valueClass == Integer.class || valueClass == Long.class || valueClass == BigDecimal.class || valueClass == Float.class || valueClass == Double.class;
        }
        return false;
    }

    public final boolean isNotNull(String key) {
        return !this.isNull(key);
    }

    public final boolean isNull(String key) {
        return !this.containsKey(key) || this.get(key) == null;
    }

    static {
        ArrayList<Object> newTrueList = new ArrayList<Object>();
        newTrueList.add(1);
        newTrueList.add(1L);
        newTrueList.add(1.0);
        newTrueList.add("1");
        newTrueList.add("true");
        TRUE_VALUES = Collections.unmodifiableList(newTrueList);
    }
}

