/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.common.collection;

import com.mx.path.core.common.collection.MultiValueMap;
import com.mx.path.core.common.collection.MultiValueMappable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SingleValueMap<K, V>
implements Map<K, V>,
MultiValueMappable<K, V> {
    private Map<K, List<V>> rawMap;

    public static <K, V> SingleValueMap<K, V> forMap(Map<K, List<V>> rawMap) {
        SingleValueMap<K, V> singleValueMap = new SingleValueMap<K, V>();
        singleValueMap.setRawMap(rawMap);
        return singleValueMap;
    }

    @Override
    public Map<K, List<V>> getRawMap() {
        return this.rawMap;
    }

    @Override
    public void setRawMap(Map<K, List<V>> rawMap) {
        this.rawMap = rawMap;
    }

    public SingleValueMap() {
        this.rawMap = new LinkedHashMap<K, List<V>>();
    }

    public SingleValueMap(MultiValueMappable<K, V> multiValueMap) {
        this.rawMap = multiValueMap.getRawMap();
    }

    @Override
    public void clear() {
        this.getRawMap().clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getRawMap().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.toMap().entrySet();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (MultiValueMappable.class.isAssignableFrom(other.getClass())) {
            return this.rawMap.equals(((MultiValueMappable)other).getRawMap());
        }
        return this.getRawMap().equals(other);
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return null;
        }
        return this.getFirst(key);
    }

    @Override
    public int hashCode() {
        return this.getRawMap().hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.getRawMap().isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.getRawMap().keySet();
    }

    @Override
    public V put(K key, V value) {
        return this.setFirst(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        map.forEach(this::setFirst);
    }

    @Override
    public V remove(Object key) {
        V value = this.getFirst(key);
        this.getRawMap().remove(key);
        return value;
    }

    @Override
    public int size() {
        return this.getRawMap().size();
    }

    public Map<K, V> toMap() {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (Map.Entry<K, List<V>> entry : this.getRawMap().entrySet()) {
            List<V> values = entry.getValue();
            if (values != null && !values.isEmpty()) {
                map.put(entry.getKey(), values.get(0));
                continue;
            }
            map.put(entry.getKey(), null);
        }
        return map;
    }

    public MultiValueMap<K, V> toMultiValueMap() {
        return new MultiValueMap(this);
    }

    public String toString() {
        return this.getRawMap().toString();
    }

    @Override
    public Collection<V> values() {
        return this.toMap().values();
    }

    private V getFirst(K key) {
        List<V> values = this.getRawMap().get(key);
        if (values != null && !values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    private V setFirst(K key, V value) {
        List values = this.getRawMap().computeIfAbsent(key, k -> new ArrayList(1));
        values.clear();
        values.add(value);
        return value;
    }
}

